﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/memorydb/MemoryDB_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MemoryDB {
namespace Model {

/**
 * <p>Indicates if the cluster has a Multi-AZ configuration (multiaz) or not
 * (singleaz).</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/AvailabilityZone">AWS
 * API Reference</a></p>
 */
class AvailabilityZone {
 public:
  AWS_MEMORYDB_API AvailabilityZone() = default;
  AWS_MEMORYDB_API AvailabilityZone(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEMORYDB_API AvailabilityZone& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEMORYDB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the Availability Zone.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  AvailabilityZone& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;
};

}  // namespace Model
}  // namespace MemoryDB
}  // namespace Aws
