/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.ModelProblem;

public final class MavenApiConverterUtil {
    private MavenApiConverterUtil() {
    }

    public static List<org.apache.maven.model.building.ModelProblem> convertFromApiProblems(List<ModelProblem> problems) {
        return problems.stream().map(it -> new DefaultModelProblem(it.getMessage(), MavenApiConverterUtil.convertFromApiSeverity(it.getSeverity()), MavenApiConverterUtil.convertFromApiVersion(it.getVersion()), it.getSource(), it.getLineNumber(), it.getColumnNumber(), it.getModelId(), it.getException())).collect(Collectors.toList());
    }

    private static ModelProblem.Version convertFromApiVersion(ModelProblem.Version version) {
        return switch (version) {
            case ModelProblem.Version.BASE -> ModelProblem.Version.BASE;
            case ModelProblem.Version.V20 -> ModelProblem.Version.V20;
            case ModelProblem.Version.V30 -> ModelProblem.Version.V30;
            case ModelProblem.Version.V31 -> ModelProblem.Version.V31;
            case ModelProblem.Version.V40 -> ModelProblem.Version.V40;
            default -> throw new IllegalArgumentException(version.toString());
        };
    }

    private static ModelProblem.Severity convertFromApiSeverity(BuilderProblem.Severity severity) {
        return switch (severity) {
            default -> throw new IncompatibleClassChangeError();
            case BuilderProblem.Severity.FATAL -> ModelProblem.Severity.FATAL;
            case BuilderProblem.Severity.ERROR -> ModelProblem.Severity.ERROR;
            case BuilderProblem.Severity.WARNING -> ModelProblem.Severity.WARNING;
        };
    }
}

