'''OpenGL extension ANGLE.texture_usage

This module customises the behaviour of the 
OpenGL.raw.GLES2.ANGLE.texture_usage to provide a more 
Python-friendly API

Overview (from the spec)
	
	In some implementations it is advantageous to know the expected
	usage of a texture before the backing storage for it is allocated.  
	This can help to inform the implementation's choice of format
	and type of memory used for the allocation. If the usage is not
	known in advance, the implementation essentially has to make a 
	guess as to how it will be used.  If it is later proven wrong,
	it may need to perform costly re-allocations and/or reformatting 
	of the texture data, resulting in reduced performance.
	
	This extension adds a texture usage flag that is specified via
	the TEXTURE_USAGE_ANGLE TexParameter.  This can be used to 
	indicate that the application knows that this texture will be 
	used for rendering.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ANGLE/texture_usage.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.ANGLE.texture_usage import *
from OpenGL.raw.GLES2.ANGLE.texture_usage import _EXTENSION_NAME

def glInitTextureUsageANGLE():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION