/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.ZipDataEntry;

public class JarReader
implements DataEntryReader {
    private final DataEntryReader dataEntryReader;
    private final boolean jmod;

    public JarReader(DataEntryReader dataEntryReader) {
        this(dataEntryReader, false);
    }

    public JarReader(DataEntryReader dataEntryReader, boolean jmod) {
        this.dataEntryReader = dataEntryReader;
        this.jmod = jmod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(DataEntry dataEntry) throws IOException {
        if (this.jmod) {
            dataEntry.getInputStream().read(new byte[4]);
        }
        ZipInputStream zipInputStream = new ZipInputStream(dataEntry.getInputStream(), Charset.forName("UTF-8"));
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                this.dataEntryReader.read(new ZipDataEntry(dataEntry, zipEntry, zipInputStream));
            }
        }
        finally {
            dataEntry.closeInputStream();
        }
    }
}

