/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.autorefresh;

import java.util.ArrayList;
import java.util.function.Supplier;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.controls.autorefresh.AutoRefreshConfigDialog;
import org.jkiss.dbeaver.ui.controls.autorefresh.AutoRefreshJob;
import org.jkiss.dbeaver.ui.controls.autorefresh.RefreshSettings;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;

public class AutoRefreshControl {
    private Control parent;
    private String controlId;
    private DBRRunnableWithProgress runnable;
    private AutoRefreshJob autoRefreshJob;
    private RefreshSettings refreshSettings;
    private volatile boolean autoRefreshEnabled = false;
    private ToolItem autoRefreshButton;
    private DBPImage defRefreshIcon;
    private Menu schedulerMenu;
    private String defRefreshText;
    private Supplier<String> hintSupplier;
    private static final int[] AUTO_REFRESH_DEFAULTS = new int[]{1, 5, 10, 15, 30, 60};

    public AutoRefreshControl(Control parent, String controlId, DBRRunnableWithProgress runnable) {
        this.parent = parent;
        this.controlId = controlId;
        this.runnable = runnable;
        parent.addDisposeListener(e -> {
            if (this.schedulerMenu != null) {
                this.schedulerMenu.dispose();
                this.schedulerMenu = null;
            }
        });
    }

    String getControlId() {
        return this.controlId;
    }

    public DBRRunnableWithProgress getRunnable() {
        return this.runnable;
    }

    public void setHintSupplier(Supplier<String> hintSupplier) {
        this.hintSupplier = hintSupplier;
    }

    private synchronized RefreshSettings getRefreshSettings() {
        if (this.refreshSettings == null) {
            this.refreshSettings = new RefreshSettings(this.controlId);
            this.refreshSettings.loadSettings();
        }
        return this.refreshSettings;
    }

    private synchronized void setRefreshSettings(RefreshSettings refreshSettings) {
        this.refreshSettings = refreshSettings;
        this.refreshSettings.saveSettings();
    }

    synchronized boolean isAutoRefreshEnabled() {
        return this.autoRefreshEnabled;
    }

    public synchronized void enableAutoRefresh(boolean enable) {
        this.autoRefreshEnabled = enable;
        this.scheduleAutoRefresh(false);
        this.updateAutoRefreshToolbar();
    }

    public synchronized void enableControls(boolean enable) {
        if (this.autoRefreshButton != null && !this.autoRefreshButton.isDisposed()) {
            this.autoRefreshButton.setEnabled(enable);
        }
    }

    public synchronized void scheduleAutoRefresh(boolean afterError) {
        if (this.autoRefreshJob != null) {
            this.autoRefreshJob.cancel();
            this.autoRefreshJob = null;
        }
        if (!this.autoRefreshEnabled || this.parent.isDisposed()) {
            return;
        }
        RefreshSettings settings = this.getRefreshSettings();
        if (afterError && settings.isStopOnError()) {
            this.enableAutoRefresh(false);
            return;
        }
        this.autoRefreshJob = new AutoRefreshJob(this);
        this.autoRefreshJob.schedule((long)settings.getRefreshInterval() * 1000L);
    }

    public void cancelRefresh() {
        AutoRefreshJob refreshJob = this.autoRefreshJob;
        if (refreshJob != null) {
            refreshJob.cancel();
            this.autoRefreshJob = null;
        }
    }

    public ToolItem populateRefreshButton(ToolBar toolbar) {
        return this.populateRefreshButton(toolbar, null, UIMessages.sql_editor_resultset_filter_panel_btn_config_refresh, (DBPImage)UIIcon.CLOCK_START, this.createDefaultRefreshAction());
    }

    public ToolItem populateRefreshButton(ToolBar toolbar, String itemText, String defTooltip, DBPImage defImage, Runnable defAction) {
        if (this.autoRefreshButton != null && !this.autoRefreshButton.isDisposed()) {
            this.autoRefreshButton.dispose();
        }
        this.defRefreshText = defTooltip;
        this.defRefreshIcon = defImage;
        this.autoRefreshButton = new ToolItem(toolbar, 524292);
        this.autoRefreshButton.setImage(DBeaverIcons.getImage(this.defRefreshIcon));
        if (itemText != null) {
            this.autoRefreshButton.setText(itemText);
        }
        UIStyles.fixToolBarForeground(toolbar);
        this.autoRefreshButton.addSelectionListener((SelectionListener)new AutoRefreshMenuListener(this.autoRefreshButton, defAction));
        this.updateAutoRefreshToolbar();
        return this.autoRefreshButton;
    }

    public void populateRefreshButton(IContributionManager contributionManager) {
        contributionManager.add((IContributionItem)new ContributionItem(){

            public void fill(ToolBar parent, int index) {
                AutoRefreshControl.this.populateRefreshButton(parent);
            }
        });
    }

    private Runnable createDefaultRefreshAction() {
        return this::runCustomized;
    }

    private void updateAutoRefreshToolbar() {
        if (this.autoRefreshButton != null && !this.autoRefreshButton.isDisposed()) {
            if (this.isAutoRefreshEnabled()) {
                this.autoRefreshButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.CLOCK_STOP));
                this.autoRefreshButton.setToolTipText(UIMessages.sql_editor_resultset_filter_panel_btn_stop_refresh);
            } else {
                this.autoRefreshButton.setImage(DBeaverIcons.getImage(this.defRefreshIcon));
                this.autoRefreshButton.setToolTipText(this.defRefreshText);
            }
        }
    }

    private void runCustomized() {
        AutoRefreshConfigDialog dialog = new AutoRefreshConfigDialog(this.parent.getShell(), this.getRefreshSettings());
        if (dialog.open() == 0) {
            this.setRefreshSettings(dialog.getRefreshSettings());
            this.enableAutoRefresh(true);
        }
    }

    private class AutoRefreshMenuListener
    extends SelectionAdapter {
        private final ToolItem dropdown;
        private final Runnable defaultAction;

        AutoRefreshMenuListener(ToolItem item, Runnable defaultAction) {
            this.dropdown = item;
            this.defaultAction = defaultAction;
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.detail == 4) {
                String hintText;
                ToolItem item = (ToolItem)e.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                if (AutoRefreshControl.this.schedulerMenu != null) {
                    AutoRefreshControl.this.schedulerMenu.dispose();
                }
                AutoRefreshControl.this.schedulerMenu = new Menu((Control)this.dropdown.getParent().getShell());
                MenuItem mi = new MenuItem(AutoRefreshControl.this.schedulerMenu, 0);
                mi.setText(UIMessages.sql_editor_resultset_filter_panel_menu_customize);
                mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AutoRefreshControl.this.runCustomized();
                    }
                });
                mi = new MenuItem(AutoRefreshControl.this.schedulerMenu, 0);
                mi.setText(UIMessages.sql_editor_resultset_filter_panel_menu_stop);
                mi.setEnabled(AutoRefreshControl.this.isAutoRefreshEnabled());
                mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AutoRefreshControl.this.enableAutoRefresh(false);
                    }
                });
                new MenuItem(AutoRefreshControl.this.schedulerMenu, 2);
                ArrayList<Integer> presetList = new ArrayList<Integer>();
                int[] nArray = AUTO_REFRESH_DEFAULTS;
                int n = AUTO_REFRESH_DEFAULTS.length;
                int n2 = 0;
                while (n2 < n) {
                    int t = nArray[n2];
                    presetList.add(t);
                    ++n2;
                }
                int defaultInterval = AutoRefreshControl.this.getRefreshSettings().getRefreshInterval();
                if (defaultInterval > 0 && !presetList.contains(defaultInterval)) {
                    presetList.add(0, defaultInterval);
                }
                int i = 0;
                while (i < presetList.size()) {
                    final Integer timeout = (Integer)presetList.get(i);
                    mi = new MenuItem(AutoRefreshControl.this.schedulerMenu, 8);
                    String text = i == 0 ? NLS.bind((String)UIMessages.sql_editor_resultset_filter_panel_menu_refresh_interval, (Object)timeout) : NLS.bind((String)UIMessages.sql_editor_resultset_filter_panel_menu_refresh_interval_1, (Object)timeout);
                    mi.setText(text);
                    if (AutoRefreshControl.this.isAutoRefreshEnabled() && timeout == defaultInterval) {
                        AutoRefreshControl.this.schedulerMenu.setDefaultItem(mi);
                    }
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            AutoRefreshMenuListener.this.runPreset(timeout);
                        }
                    });
                    ++i;
                }
                if (AutoRefreshControl.this.hintSupplier != null && !CommonUtils.isEmpty((String)(hintText = AutoRefreshControl.this.hintSupplier.get()))) {
                    new MenuItem(AutoRefreshControl.this.schedulerMenu, 2);
                    MenuItem hintItem = new MenuItem(AutoRefreshControl.this.schedulerMenu, 8);
                    hintItem.setText(hintText);
                    hintItem.setEnabled(false);
                }
                AutoRefreshControl.this.schedulerMenu.setLocation(pt.x, pt.y + rect.height);
                AutoRefreshControl.this.schedulerMenu.setVisible(true);
            } else if (AutoRefreshControl.this.isAutoRefreshEnabled()) {
                AutoRefreshControl.this.enableAutoRefresh(false);
            } else {
                this.defaultAction.run();
            }
        }

        private void runPreset(int interval) {
            RefreshSettings settings = new RefreshSettings(AutoRefreshControl.this.getRefreshSettings());
            settings.setRefreshInterval(interval);
            AutoRefreshControl.this.setRefreshSettings(settings);
            AutoRefreshControl.this.enableAutoRefresh(true);
        }
    }
}

