/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.echosvg.css.engine.value.AbstractValue;
import io.sf.carte.echosvg.css.engine.value.TypedValue;
import org.w3c.css.om.typed.CSSNumericValue;
import org.w3c.css.om.unit.CSSUnit;

public abstract class NumericValue
extends AbstractValue
implements TypedValue,
CSSNumericValue {
    private static final long serialVersionUID = 1L;

    @Override
    public NumericValue clone() {
        return (NumericValue)super.clone();
    }

    abstract short getCSSUnit();

    public CSSNumericValue.CSSNumericType type() {
        return new NumericType();
    }

    class NumericType
    implements CSSNumericValue.CSSNumericType {
        NumericType() {
        }

        public int getLength() {
            return CSSUnit.isLengthUnitType((short)NumericValue.this.getCSSUnit()) ? 1 : 0;
        }

        public int getAngle() {
            return CSSUnit.isAngleUnitType((short)NumericValue.this.getCSSUnit()) ? 1 : 0;
        }

        public int getTime() {
            return CSSUnit.isTimeUnitType((short)NumericValue.this.getCSSUnit()) ? 1 : 0;
        }

        public int getFrequency() {
            short unit = NumericValue.this.getCSSUnit();
            return unit == 100 || unit == 101 ? 1 : 0;
        }

        public int getResolution() {
            return CSSUnit.isResolutionUnitType((short)NumericValue.this.getCSSUnit()) ? 1 : 0;
        }

        public int getFlex() {
            return NumericValue.this.getCSSUnit() == 70 ? 1 : 0;
        }

        public int getPercent() {
            return NumericValue.this.getCSSUnit() == 2 ? 1 : 0;
        }

        public CSSNumericValue.CSSNumericBaseType getPercentHint() {
            short unitType = NumericValue.this.getCSSUnit();
            CSSNumericValue.CSSNumericBaseType baseType = null;
            if (CSSUnit.isLengthUnitType((short)unitType)) {
                baseType = CSSNumericValue.CSSNumericBaseType.length;
            } else if (unitType == 2) {
                baseType = CSSNumericValue.CSSNumericBaseType.percent;
            } else if (CSSUnit.isTimeUnitType((short)unitType)) {
                baseType = CSSNumericValue.CSSNumericBaseType.time;
            } else if (CSSUnit.isAngleUnitType((short)unitType)) {
                baseType = CSSNumericValue.CSSNumericBaseType.angle;
            } else if (CSSUnit.isResolutionUnitType((short)unitType)) {
                baseType = CSSNumericValue.CSSNumericBaseType.resolution;
            } else if (unitType == 100 || unitType == 101) {
                baseType = CSSNumericValue.CSSNumericBaseType.frequency;
            } else if (unitType == 70) {
                baseType = CSSNumericValue.CSSNumericBaseType.flex;
            }
            return baseType;
        }
    }
}

