/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractElementLiveList;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.NDTNode;
import org.w3c.dom.Node;

class TagnameElementListNS
extends AbstractElementLiveList {
    private static final long serialVersionUID = 1L;
    private final String localName;
    private final String namespaceURI;
    private final boolean matchAll;
    private final boolean matchAllNS;

    TagnameElementListNS(NDTNode ndtNode, String localName, String namespaceURI, boolean matchAll, boolean matchAllNS) {
        super(ndtNode);
        this.localName = localName;
        this.namespaceURI = namespaceURI;
        this.matchAll = matchAll;
        this.matchAllNS = matchAllNS;
    }

    @Override
    boolean matches(DOMElement element, Node lookFor) {
        return element == lookFor && (this.matchAll || element.getLocalName().equals(this.localName)) && this.isSameNamespace(element);
    }

    @Override
    boolean matches(DOMElement element) {
        return (this.matchAll || element.getLocalName().equals(this.localName)) && this.isSameNamespace(element);
    }

    private boolean isSameNamespace(DOMElement element) {
        if (this.matchAllNS) {
            return true;
        }
        String ns1 = element.getNamespaceURI();
        if (ns1 == null) {
            return this.namespaceURI == null || element.isDefaultNamespace(this.namespaceURI);
        }
        return ns1.equals(this.namespaceURI) || this.namespaceURI == null && element.isDefaultNamespace(ns1);
    }
}

