/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.color.Illuminants;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.A98RGBColorProfile;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ChromaticAdaption;
import io.sf.carte.doc.style.css.property.ColorFunction;
import io.sf.carte.doc.style.css.property.ColorProfile;
import io.sf.carte.doc.style.css.property.ColorSpaceHelper;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.DisplayP3ColorProfile;
import io.sf.carte.doc.style.css.property.LinearSRGBColorProfile;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProPhotoRGBColorProfile;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.Rec2020ColorProfile;
import io.sf.carte.doc.style.css.property.SRGBColorProfile;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.jclf.math.linear3.Matrices;
import java.util.Arrays;
import java.util.Objects;
import org.w3c.dom.DOMException;

class ProfiledRGBColor
extends RGBColor {
    private static final long serialVersionUID = 1L;
    private final String colorSpace;
    private final BaseColor.Space space;

    ProfiledRGBColor(String lcColorSpace) {
        this.colorSpace = lcColorSpace;
        this.space = ColorSpaceHelper.rgbSpaceEnum(lcColorSpace);
    }

    ProfiledRGBColor(ProfiledRGBColor copyMe) {
        super(copyMe);
        this.colorSpace = copyMe.colorSpace;
        this.space = copyMe.space;
    }

    @Override
    public String getColorSpace() {
        return this.colorSpace;
    }

    @Override
    BaseColor.Space getSpace() {
        return this.space;
    }

    @Override
    PrimitiveValue enforceColorComponentType(PrimitiveValue primi) {
        return ColorFunction.enforceColorComponentType(primi);
    }

    @Override
    double rgbComponentNormalized(TypedValue typed) {
        double comp;
        short unit = typed.getUnitType();
        if (unit == 2) {
            comp = (double)typed.getFloatValue((short)2) * 0.01;
        } else if (unit == 0) {
            comp = typed.getFloatValue((short)0);
        } else if (typed.getPrimitiveType() == CSSValue.Type.IDENT) {
            comp = 0.0;
        } else {
            throw new DOMException(17, "Wrong component: " + typed.getCssText());
        }
        return comp;
    }

    @Override
    void setColorComponents(double[] rgb) {
        NumberValue red = new NumberValue();
        red.setFloatValue((short)0, (float)rgb[0]);
        red.setSubproperty(true);
        red.setAbsolutizedUnit();
        red.setMaximumFractionDigits(4);
        this.setRed(red);
        NumberValue green = new NumberValue();
        green.setFloatValue((short)0, (float)rgb[1]);
        green.setSubproperty(true);
        green.setAbsolutizedUnit();
        green.setMaximumFractionDigits(4);
        this.setGreen(green);
        NumberValue blue = new NumberValue();
        blue.setFloatValue((short)0, (float)rgb[2]);
        blue.setSubproperty(true);
        blue.setAbsolutizedUnit();
        blue.setMaximumFractionDigits(4);
        this.setBlue(blue);
    }

    @Override
    public double[] toXYZ(Illuminant white) {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double r = this.rgbComponentNormalized((TypedValue)this.getRed());
        double g = this.rgbComponentNormalized((TypedValue)this.getGreen());
        double b = this.rgbComponentNormalized((TypedValue)this.getBlue());
        double[] xyz = new double[3];
        switch (this.space) {
            case p3: {
                DisplayP3ColorProfile profile = new DisplayP3ColorProfile();
                r = profile.linearComponent(r);
                g = profile.linearComponent(g);
                b = profile.linearComponent(b);
                profile.linearRgbToXYZ(r, g, b, xyz);
                if (white != Illuminant.D50) break;
                xyz = ColorUtil.d65xyzToD50(xyz);
                break;
            }
            case A98_RGB: {
                A98RGBColorProfile profile = new A98RGBColorProfile();
                r = ((ColorProfile)profile).linearComponent(r);
                g = ((ColorProfile)profile).linearComponent(g);
                b = ((ColorProfile)profile).linearComponent(b);
                profile.linearRgbToXYZ(r, g, b, xyz);
                if (white != Illuminant.D50) break;
                xyz = ColorUtil.d65xyzToD50(xyz);
                break;
            }
            case ProPhoto_RGB: {
                ProPhotoRGBColorProfile profile = new ProPhotoRGBColorProfile();
                r = ((ColorProfile)profile).linearComponent(r);
                g = ((ColorProfile)profile).linearComponent(g);
                b = ((ColorProfile)profile).linearComponent(b);
                profile.linearRgbToXYZ(r, g, b, xyz);
                if (white != Illuminant.D65) break;
                xyz = ColorUtil.d50xyzToD65(xyz);
                break;
            }
            case Rec2020: {
                Rec2020ColorProfile profile = new Rec2020ColorProfile();
                r = ((ColorProfile)profile).linearComponent(r);
                g = ((ColorProfile)profile).linearComponent(g);
                b = ((ColorProfile)profile).linearComponent(b);
                profile.linearRgbToXYZ(r, g, b, xyz);
                if (white != Illuminant.D50) break;
                xyz = ColorUtil.d65xyzToD50(xyz);
                break;
            }
            case Linear_sRGB: {
                LinearSRGBColorProfile profile = new LinearSRGBColorProfile();
                profile.linearRgbToXYZ(r, g, b, xyz);
                if (white != Illuminant.D50) break;
                xyz = ColorUtil.d65xyzToD50(xyz);
                break;
            }
            case sRGB: {
                return super.toXYZ(white);
            }
            default: {
                throw new DOMException(9, "Color space is not supported.");
            }
        }
        return xyz;
    }

    @Override
    public double[] toXYZ(double[] white) {
        double[] rgb = this.toNumberArray();
        ColorProfile profile = this.getColorProfile();
        double[] xyz = new double[3];
        profile.linearizeComponents(rgb);
        profile.linearRgbToXYZ(rgb, xyz);
        if (profile.getIlluminant() == Illuminant.D50) {
            if (!Arrays.equals(Illuminants.whiteD50, white)) {
                double[][] cam = new double[3][3];
                ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD50, white, cam);
                double[] result = new double[3];
                Matrices.multiplyByVector3((double[][])cam, (double[])xyz, (double[])result);
                xyz = result;
            }
        } else if (!Arrays.equals(Illuminants.whiteD65, white)) {
            double[][] cam = new double[3][3];
            ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD65, white, cam);
            double[] result = new double[3];
            Matrices.multiplyByVector3((double[][])cam, (double[])xyz, (double[])result);
            xyz = result;
        }
        return xyz;
    }

    private ColorProfile getColorProfile() {
        ColorProfile profile;
        switch (this.space) {
            case sRGB: {
                profile = new SRGBColorProfile();
                break;
            }
            case p3: {
                profile = new DisplayP3ColorProfile();
                break;
            }
            case A98_RGB: {
                profile = new A98RGBColorProfile();
                break;
            }
            case ProPhoto_RGB: {
                profile = new ProPhotoRGBColorProfile();
                break;
            }
            case Rec2020: {
                profile = new Rec2020ColorProfile();
                break;
            }
            case Linear_sRGB: {
                profile = new LinearSRGBColorProfile();
                break;
            }
            default: {
                throw new DOMException(9, "Color space is not supported.");
            }
        }
        return profile;
    }

    @Override
    double[] toSRGB(boolean clamp) {
        double[] xyz;
        double[] xyzD50 = null;
        if (this.space == BaseColor.Space.sRGB) {
            return super.toSRGB(clamp);
        }
        if (this.space == BaseColor.Space.ProPhoto_RGB) {
            xyzD50 = this.toXYZ(Illuminant.D50);
            xyz = ColorUtil.d50xyzToD65(xyzD50);
        } else {
            if (this.space == BaseColor.Space.Linear_sRGB) {
                return this.linearToSRGB();
            }
            xyz = this.toXYZ(Illuminant.D65);
        }
        double[] rgb = new double[3];
        ColorUtil.d65xyzToSRGB(xyz, rgb);
        if (!ColorUtil.rangeRoundCheck(rgb) && clamp) {
            if (this.space != BaseColor.Space.ProPhoto_RGB) {
                xyzD50 = ColorUtil.d65xyzToD50(xyz);
            }
            double[] lab = new double[3];
            ColorUtil.xyzD50ToLab(xyzD50, lab);
            SRGBColorProfile profile = new SRGBColorProfile();
            ColorUtil.clampRGB(lab[0], lab[1], lab[2], profile, rgb);
        }
        return rgb;
    }

    private double[] linearToSRGB() {
        double r = this.rgbComponentNormalized((TypedValue)this.getRed());
        double g = this.rgbComponentNormalized((TypedValue)this.getGreen());
        double b = this.rgbComponentNormalized((TypedValue)this.getBlue());
        double[] rgb = new double[]{ColorUtil.sRGBCompanding(r), ColorUtil.sRGBCompanding(g), ColorUtil.sRGBCompanding(b)};
        return rgb;
    }

    RGBColor toSRGBColor(boolean clamp) {
        if (this.space == BaseColor.Space.sRGB) {
            return this;
        }
        double[] rgb = this.toSRGB(clamp);
        RGBColor color = new RGBColor();
        color.setColorComponents(rgb);
        color.setAlpha(this.getAlpha().clone());
        return color;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("color(").append(this.getColorSpace()).append(' ');
        this.appendComponentCssText(buf, this.getRed()).append(' ');
        this.appendComponentCssText(buf, this.getGreen()).append(' ');
        this.appendComponentCssText(buf, this.getBlue());
        if (this.isNonOpaque()) {
            buf.append(" / ");
            this.appendAlphaChannel(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String toMinifiedString() {
        StringBuilder buf = new StringBuilder(58);
        buf.append("color(").append(this.getColorSpace()).append(' ');
        this.appendComponentMinifiedCssText(buf, this.getRed()).append(' ');
        this.appendComponentMinifiedCssText(buf, this.getGreen()).append(' ');
        this.appendComponentMinifiedCssText(buf, this.getBlue());
        if (this.isNonOpaque()) {
            buf.append('/');
            this.appendAlphaChannelMinified(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.colorSpace);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfiledRGBColor other = (ProfiledRGBColor)obj;
        return Objects.equals(this.colorSpace, other.colorSpace);
    }

    @Override
    public ColorValue packInValue() {
        return new ColorFunction(this);
    }

    @Override
    public ProfiledRGBColor clone() {
        return new ProfiledRGBColor(this);
    }
}

