/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.LexicalCallbackTH;
import io.sf.carte.doc.style.css.parser.LexicalProvider;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.UnicodeRangeUnitImpl;
import io.sf.carte.doc.style.css.parser.UnicodeWildcardUnitImpl;

class UnicodeRangeTH
extends LexicalCallbackTH {
    UnicodeRangeTH(LexicalProvider caller) {
        super(caller);
    }

    @Override
    protected void initializeBuffer() {
        this.buffer = new StringBuilder(10);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void processBuffer(int index, int triggerCp) {
        LexicalUnitImpl lu1;
        int buflen = this.buffer.length();
        if (buflen == 0) {
            return;
        }
        LexicalUnitImpl lu2 = null;
        String s = this.rawBuffer();
        int idx = s.indexOf(45);
        if (idx == -1) {
            byte check = UnicodeRangeTH.rangeLengthCheck(s);
            if (check == 1) {
                lu1 = new LexicalUnitImpl(LexicalUnit.LexicalType.INTEGER);
                lu1.intValue = Integer.parseInt(s, 16);
                lu1.setCssUnit((short)0);
            } else {
                if (check != 2) {
                    this.handleError(index - buflen, (byte)9, "Invalid unicode range: " + s);
                    return;
                }
                lu1 = new UnicodeWildcardUnitImpl();
                lu1.value = s;
            }
        } else if (idx > 0 && idx < s.length() - 1) {
            String range1 = s.substring(0, idx);
            String range2 = s.substring(idx + 1);
            byte check = UnicodeRangeTH.rangeLengthCheck(range1);
            if (check != 1) {
                this.handleError(index - buflen, (byte)9, "Invalid unicode range: " + s);
                return;
            }
            lu1 = new LexicalUnitImpl(LexicalUnit.LexicalType.INTEGER);
            lu1.intValue = Integer.parseInt(range1, 16);
            lu1.setCssUnit((short)0);
            check = UnicodeRangeTH.rangeLengthCheck(range2);
            if (check != 1) {
                this.handleError(index - buflen, (byte)9, "Invalid unicode range: " + s);
                return;
            }
            lu2 = new LexicalUnitImpl(LexicalUnit.LexicalType.INTEGER);
            lu2.intValue = Integer.parseInt(range2, 16);
            lu2.setCssUnit((short)0);
        } else {
            this.handleError(index - buflen, (byte)9, "Invalid unicode range: " + s);
            return;
        }
        UnicodeRangeUnitImpl range = new UnicodeRangeUnitImpl();
        range.addFunctionParameter(lu1);
        if (lu2 != null) {
            range.addFunctionParameter(lu2);
        }
        this.addPlainLexicalUnit(range);
        this.yieldBack();
    }

    private static byte rangeLengthCheck(String range) {
        int wildcardCount = 0;
        int len = range.length();
        if (len < 7) {
            for (int i = 0; i < len; ++i) {
                if (range.charAt(i) == '?') {
                    wildcardCount = (byte)(wildcardCount + 1);
                    continue;
                }
                if (wildcardCount == 0) continue;
                return 0;
            }
            if (wildcardCount == 0) {
                return 1;
            }
            if (wildcardCount != 6) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void separator(int index, int codePoint) {
        if (this.buffer.length() != 0) {
            this.processBuffer(index, codePoint);
        }
        this.setWhitespacePrevCp();
    }

    @Override
    public void character(int index, int codePoint) {
        if (codePoint == 45) {
            this.buffer.append('-');
            codePoint = 65;
        } else if (codePoint == 44) {
            this.processBuffer(index, codePoint);
            if (!this.isInError()) {
                LexicalUnitImpl lu = new LexicalUnitImpl(LexicalUnit.LexicalType.OPERATOR_COMMA);
                this.getCaller().addPlainLexicalUnit(lu);
            }
        } else if (codePoint == 63 && this.buffer.length() < 6) {
            this.buffer.append('?');
        } else if (codePoint == 59) {
            this.handleSemicolon(index);
        } else {
            this.unexpectedCharError(index, codePoint);
        }
        this.prevcp = codePoint;
    }

    @Override
    public void escaped(int index, int codePoint) {
        this.unexpectedCharError(index, codePoint);
    }
}

