# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ArtifactRegistry
      module V1
        # The Artifact Registry settings that apply to a Project.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the project's settings.
        #
        #     Always of the form:
        #     projects/\\{project-id}/projectSettings
        #
        #     In update request: never set
        #     In response: always set
        # @!attribute [rw] legacy_redirection_state
        #   @return [::Google::Cloud::ArtifactRegistry::V1::ProjectSettings::RedirectionState]
        #     The redirection state of the legacy repositories in this project.
        class ProjectSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The possible redirection states for legacy repositories.
          module RedirectionState
            # No redirection status has been set.
            REDIRECTION_STATE_UNSPECIFIED = 0

            # Redirection is disabled.
            REDIRECTION_FROM_GCR_IO_DISABLED = 1

            # Redirection is enabled.
            REDIRECTION_FROM_GCR_IO_ENABLED = 2

            # Redirection is enabled, and has been finalized so cannot be reverted.
            REDIRECTION_FROM_GCR_IO_FINALIZED = 3
          end
        end

        # Gets the redirection status for a project.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the projectSettings resource.
        class GetProjectSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Sets the settings of the project.
        # @!attribute [rw] project_settings
        #   @return [::Google::Cloud::ArtifactRegistry::V1::ProjectSettings]
        #     The project settings.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Field mask to support partial updates.
        class UpdateProjectSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
