/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.templates.mpp;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.KotlinNewProjectWizardBundle;
import org.jetbrains.kotlin.tools.projectWizard.core.Context;
import org.jetbrains.kotlin.tools.projectWizard.core.TaskResult;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.BuildSystemIR;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.KotlinBuildSystemPluginIR;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.ModuleIR;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.gradle.GradleIRBuilderKt;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.gradle.GradleIRListBuilder;
import org.jetbrains.kotlin.tools.projectWizard.moduleConfigurators.ModuleConfigurator;
import org.jetbrains.kotlin.tools.projectWizard.moduleConfigurators.MppModuleConfigurator;
import org.jetbrains.kotlin.tools.projectWizard.moduleConfigurators.SimpleTargetConfigurator;
import org.jetbrains.kotlin.tools.projectWizard.mpp.MppKt;
import org.jetbrains.kotlin.tools.projectWizard.mpp.MppSources;
import org.jetbrains.kotlin.tools.projectWizard.mpp.SimpleFiles;
import org.jetbrains.kotlin.tools.projectWizard.plugins.StructurePluginKt;
import org.jetbrains.kotlin.tools.projectWizard.plugins.kotlin.ModuleSubType;
import org.jetbrains.kotlin.tools.projectWizard.plugins.kotlin.ProjectKind;
import org.jetbrains.kotlin.tools.projectWizard.settings.JavaPackage;
import org.jetbrains.kotlin.tools.projectWizard.settings.JavaPackageKt;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.Module;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.SourcesetType;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileTemplateDescriptor;
import org.jetbrains.kotlin.tools.projectWizard.templates.Template;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n0\u0013R\u00020\u0014j\u0002`\u0015H\u0016J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\n0\u0019R\u00020\u0014j\u0002`\u001a2\u0006\u0010\u000e\u001a\u00020\u001bH\u0016J\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d*\n0\u0019R\u00020\u0014j\u0002`\u001a2\u0006\u0010\u000e\u001a\u00020\u001bH\u0016R\u0016\u0010\u0004\u001a\u00020\u00058\u0016X\u0097D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/templates/mpp/MobileMppTemplate;", "Lorg/jetbrains/kotlin/tools/projectWizard/templates/Template;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "title", "getTitle", "description", "getDescription", "isApplicableTo", "", "module", "Lorg/jetbrains/kotlin/tools/projectWizard/settings/buildsystem/Module;", "projectKind", "Lorg/jetbrains/kotlin/tools/projectWizard/plugins/kotlin/ProjectKind;", "reader", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context$Reader;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Reader;", "getIrsToAddToBuildFile", "", "Lorg/jetbrains/kotlin/tools/projectWizard/ir/buildsystem/BuildSystemIR;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context$Writer;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Writer;", "Lorg/jetbrains/kotlin/tools/projectWizard/ir/buildsystem/ModuleIR;", "runArbitratyTask", "Lorg/jetbrains/kotlin/tools/projectWizard/core/TaskResult;", "", "kotlin.project-wizard.core"})
@SourceDebugExtension(value={"SMAP\nMobileMppTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobileMppTemplate.kt\norg/jetbrains/kotlin/tools/projectWizard/templates/mpp/MobileMppTemplate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1761#2,3:72\n*S KotlinDebug\n*F\n+ 1 MobileMppTemplate.kt\norg/jetbrains/kotlin/tools/projectWizard/templates/mpp/MobileMppTemplate\n*L\n39#1:72,3\n*E\n"})
public final class MobileMppTemplate
extends Template {
    @NonNls
    @NotNull
    private final String id;
    @NotNull
    private final String title = KotlinNewProjectWizardBundle.message("module.template.mpp.mobile.title", new Object[0]);
    @NotNull
    private final String description = KotlinNewProjectWizardBundle.message("module.template.mpp.mobile.description", new Object[0]);

    public MobileMppTemplate() {
        this.id = "mobileMppModule";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isApplicableTo(@NotNull Module module, @NotNull ProjectKind projectKind, @NotNull Context.Reader reader) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)projectKind, (String)"projectKind");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return Intrinsics.areEqual((Object)module.getConfigurator(), (Object)MppModuleConfigurator.INSTANCE);
    }

    @Override
    @NotNull
    public List<BuildSystemIR> getIrsToAddToBuildFile(@NotNull Context.Writer $this$getIrsToAddToBuildFile, @NotNull ModuleIR module) {
        Intrinsics.checkNotNullParameter((Object)$this$getIrsToAddToBuildFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return GradleIRBuilderKt.irsList((Function1<? super GradleIRListBuilder, Unit>)((Function1)arg_0 -> MobileMppTemplate.getIrsToAddToBuildFile$lambda$1(module, arg_0)));
    }

    @Override
    @NotNull
    public TaskResult<Unit> runArbitratyTask(@NotNull Context.Writer $this$runArbitratyTask, @NotNull ModuleIR module) {
        Intrinsics.checkNotNullParameter((Object)$this$runArbitratyTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        JavaPackage javaPackage = JavaPackageKt.javaPackage(module.getOriginalModule(), StructurePluginKt.pomIR($this$runArbitratyTask));
        MppSources mpp = MppKt.mppSources(javaPackage, (Function1<? super MppSources.Builder, Unit>)((Function1)MobileMppTemplate::runArbitratyTask$lambda$5));
        return MppKt.applyMppStructure($this$runArbitratyTask, mpp, module.getOriginalModule(), module.getPath());
    }

    private static final Unit getIrsToAddToBuildFile$lambda$1(ModuleIR $module, GradleIRListBuilder $this$irsList) {
        boolean cocoaPods;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$irsList, (String)"$this$irsList");
            Iterable $this$any$iv = $module.getOriginalModule().getSubModules();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Module it = (Module)element$iv;
                    boolean bl = false;
                    ModuleConfigurator moduleConfigurator = it.getConfigurator();
                    SimpleTargetConfigurator simpleTargetConfigurator = moduleConfigurator instanceof SimpleTargetConfigurator ? (SimpleTargetConfigurator)moduleConfigurator : null;
                    if (!((simpleTargetConfigurator != null ? simpleTargetConfigurator.getModuleSubType() : null) == ModuleSubType.iosCocoaPods)) continue;
                    v0 = true;
                    break block4;
                }
                v0 = cocoaPods = false;
            }
        }
        if (cocoaPods) {
            $this$irsList.unaryPlus(new KotlinBuildSystemPluginIR(KotlinBuildSystemPluginIR.Type.nativeCocoapods, null, null, 4, null));
        }
        return Unit.INSTANCE;
    }

    private static final Unit runArbitratyTask$lambda$5$lambda$2(SimpleFiles.Builder $this$filesFor) {
        Intrinsics.checkNotNullParameter((Object)$this$filesFor, (String)"$this$filesFor");
        SimpleFiles.Builder.file$default($this$filesFor, new FileTemplateDescriptor("mppCommon/Greeting.kt.vm", null), "Greeting.kt", SourcesetType.main, null, 8, null);
        SimpleFiles.Builder.file$default($this$filesFor, new FileTemplateDescriptor("mppCommon/Platform.kt.vm", null), "Platform.kt", SourcesetType.main, null, 8, null);
        return Unit.INSTANCE;
    }

    private static final Unit runArbitratyTask$lambda$5$lambda$3(SimpleFiles.Builder $this$filesFor) {
        Intrinsics.checkNotNullParameter((Object)$this$filesFor, (String)"$this$filesFor");
        SimpleFiles.Builder.file$default($this$filesFor, new FileTemplateDescriptor("android/Platform.kt.vm", null), "Platform.kt", SourcesetType.main, null, 8, null);
        SimpleFiles.Builder.file$default($this$filesFor, new FileTemplateDescriptor("android/androidTest.kt.vm", null), "androidTest.kt", SourcesetType.test, null, 8, null);
        return Unit.INSTANCE;
    }

    private static final Unit runArbitratyTask$lambda$5$lambda$4(SimpleFiles.Builder $this$filesFor) {
        Intrinsics.checkNotNullParameter((Object)$this$filesFor, (String)"$this$filesFor");
        SimpleFiles.Builder.file$default($this$filesFor, new FileTemplateDescriptor("ios/Platform.kt.vm", null), "Platform.kt", SourcesetType.main, null, 8, null);
        SimpleFiles.Builder.file$default($this$filesFor, new FileTemplateDescriptor("ios/iosTest.kt.vm", null), "iosTest.kt", SourcesetType.test, null, 8, null);
        return Unit.INSTANCE;
    }

    private static final Unit runArbitratyTask$lambda$5(MppSources.Builder $this$mppSources) {
        Intrinsics.checkNotNullParameter((Object)$this$mppSources, (String)"$this$mppSources");
        ModuleSubType[] moduleSubTypeArray = new ModuleSubType[]{ModuleSubType.common};
        $this$mppSources.filesFor(moduleSubTypeArray, (Function1<? super SimpleFiles.Builder, Unit>)((Function1)MobileMppTemplate::runArbitratyTask$lambda$5$lambda$2));
        moduleSubTypeArray = new ModuleSubType[]{ModuleSubType.android};
        $this$mppSources.filesFor(moduleSubTypeArray, (Function1<? super SimpleFiles.Builder, Unit>)((Function1)MobileMppTemplate::runArbitratyTask$lambda$5$lambda$3));
        moduleSubTypeArray = new ModuleSubType[]{ModuleSubType.iosArm64, ModuleSubType.iosX64, ModuleSubType.ios, ModuleSubType.iosCocoaPods};
        $this$mppSources.filesFor(moduleSubTypeArray, (Function1<? super SimpleFiles.Builder, Unit>)((Function1)MobileMppTemplate::runArbitratyTask$lambda$5$lambda$4));
        return Unit.INSTANCE;
    }
}

