/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\u0003H\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\nH\u0014J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\u0003H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenApplicableConfigurator;", "", "pluginGroupId", "", "pluginArtifactId", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "isApplicable", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "findConfigValue", "p", "path", "getConfig", "Lorg/jdom/Element;", "intellij.maven"})
@ApiStatus.Internal
public class MavenApplicableConfigurator {
    @NotNull
    private final String pluginGroupId;
    @NotNull
    private final String pluginArtifactId;

    public MavenApplicableConfigurator(@NotNull String pluginGroupId, @NotNull String pluginArtifactId) {
        Intrinsics.checkNotNullParameter((Object)pluginGroupId, (String)"pluginGroupId");
        Intrinsics.checkNotNullParameter((Object)pluginArtifactId, (String)"pluginArtifactId");
        this.pluginGroupId = pluginGroupId;
        this.pluginArtifactId = pluginArtifactId;
    }

    public boolean isApplicable(@NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        return MavenProject.findPlugin$default(mavenProject, this.pluginGroupId, this.pluginArtifactId, false, 4, null) != null;
    }

    @Nullable
    protected String findConfigValue(@NotNull MavenProject p, @NonNls @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return MavenJDOMUtil.findChildValueByPath$default(this.getConfig(p), path, null, 4, null);
    }

    @Nullable
    protected Element getConfig(@NotNull MavenProject p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return p.getPluginConfiguration(this.pluginGroupId, this.pluginArtifactId);
    }

    @Nullable
    protected Element getConfig(@NotNull MavenProject p, @NonNls @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return MavenJDOMUtil.findChildByPath(this.getConfig(p), path);
    }
}

