/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Locale;
import org.jdom.Verifier;
import org.jdom.output.EscapeStrategy;

public final class Format
implements Cloneable {
    private static final EscapeStrategy UTFEscapeStrategy = new EscapeStrategy(){

        @Override
        public boolean shouldEscape(char ch) {
            return Verifier.isHighSurrogate(ch);
        }
    };
    private static final EscapeStrategy Bits8EscapeStrategy = new EscapeStrategy(){

        @Override
        public boolean shouldEscape(char ch) {
            return ch >>> 8 != 0;
        }
    };
    private static final EscapeStrategy Bits7EscapeStrategy = new EscapeStrategy(){

        @Override
        public boolean shouldEscape(char ch) {
            return ch >>> 7 != 0;
        }
    };
    private static final EscapeStrategy DEFAULT_ESCAPE_STRATEGY = new EscapeStrategy(){

        @Override
        public boolean shouldEscape(char ch) {
            return Verifier.isHighSurrogate(ch);
        }
    };
    private static final String STANDARD_LINE_SEPARATOR = System.lineSeparator();
    String indent = null;
    String lineSeparator = "\n";
    String encoding = "UTF-8";
    boolean omitDeclaration = false;
    boolean omitEncoding = false;
    boolean expandEmptyElements = false;
    boolean ignoreTrAXEscapingPIs = false;
    TextMode mode = TextMode.PRESERVE;
    EscapeStrategy escapeStrategy = DEFAULT_ESCAPE_STRATEGY;

    public static Format getRawFormat() {
        return new Format();
    }

    public static String compact(String str) {
        int left;
        int right = str.length() - 1;
        for (left = 0; left <= right && Verifier.isXMLWhitespace(str.charAt(left)); ++left) {
        }
        while (right > left && Verifier.isXMLWhitespace(str.charAt(right))) {
            --right;
        }
        if (left > right) {
            return "";
        }
        boolean space = true;
        StringBuilder buffer = new StringBuilder(right - left + 1);
        while (left <= right) {
            char c = str.charAt(left);
            if (Verifier.isXMLWhitespace(c)) {
                if (space) {
                    buffer.append(' ');
                    space = false;
                }
            } else {
                buffer.append(c);
                space = true;
            }
            ++left;
        }
        return buffer.toString();
    }

    private static EscapeStrategy chooseStrategy(String encoding) {
        if ("UTF-8".equalsIgnoreCase(encoding) || "UTF-16".equalsIgnoreCase(encoding)) {
            return UTFEscapeStrategy;
        }
        if (encoding.toUpperCase(Locale.ENGLISH).startsWith("ISO-8859-") || "Latin1".equalsIgnoreCase(encoding)) {
            return Bits8EscapeStrategy;
        }
        if ("US-ASCII".equalsIgnoreCase(encoding) || "ASCII".equalsIgnoreCase(encoding)) {
            return Bits7EscapeStrategy;
        }
        try {
            CharsetEncoder cse = Charset.forName(encoding).newEncoder();
            return new DefaultCharsetEscapeStrategy(cse);
        }
        catch (Exception exception) {
            return DEFAULT_ESCAPE_STRATEGY;
        }
    }

    private Format() {
        this.setEncoding("UTF-8");
    }

    public Format setEncoding(String encoding) {
        this.encoding = encoding;
        this.escapeStrategy = Format.chooseStrategy(encoding);
        return this;
    }

    public Format clone() {
        Format format = null;
        try {
            format = (Format)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return format;
    }

    public static enum TextMode {
        PRESERVE,
        TRIM,
        NORMALIZE,
        TRIM_FULL_WHITE;

    }

    private static final class DefaultCharsetEscapeStrategy
    implements EscapeStrategy {
        private final CharsetEncoder encoder;

        private DefaultCharsetEscapeStrategy(CharsetEncoder cse) {
            this.encoder = cse;
        }

        @Override
        public boolean shouldEscape(char ch) {
            if (Verifier.isHighSurrogate(ch)) {
                return true;
            }
            return !this.encoder.canEncode(ch);
        }
    }
}

