/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.IOException;
import java.util.Map;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructCodeAttribute
extends StructGeneralAttribute {
    public int localVariables = 0;
    public int codeLength = 0;
    public int codeFullLength = 0;
    public Map<String, StructGeneralAttribute> codeAttributes;

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool) throws IOException {
        data.discard(2);
        this.localVariables = data.readUnsignedShort();
        this.codeLength = data.readInt();
        data.discard(this.codeLength);
        int excLength = data.readUnsignedShort();
        data.discard(excLength * 8);
        this.codeFullLength = this.codeLength + excLength * 8 + 2;
        this.codeAttributes = StructMember.readAttributes(data, pool);
    }
}

