/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.opto;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.opto.JVMState;
import sun.jvm.hotspot.opto.MachReturnNode;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class MachSafePointNode
extends MachReturnNode {
    private static AddressField jvmsField;
    private static CIntField jvmadjField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("MachSafePointNode");
        jvmsField = type.getAddressField("_jvms");
        jvmadjField = new CIntField(type.getCIntegerField("_jvmadj"), 0L);
    }

    public MachSafePointNode(Address addr) {
        super(addr);
    }

    public JVMState jvms() {
        return JVMState.create(jvmsField.getValue(this.getAddress()));
    }

    @Override
    public void dumpSpec(PrintStream out) {
        try {
            JVMState jvms = this.jvms();
            if (jvms != null) {
                out.print(" !");
            }
            if (jvms == null) {
                out.print("empty jvms");
            }
            while (jvms != null) {
                Method m = jvms.method().method();
                int bci = jvms.bci();
                out.print(" " + m.getMethodHolder().getName().asString().replace('/', '.') + "::" + m.getName().asString() + " @ bci:" + bci);
                jvms = jvms.caller();
            }
        }
        catch (Exception e) {
            out.print(e);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                MachSafePointNode.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

