/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.Parseable;
import org.linuxsampler.lscp.Parser;

public class SamplerEngine
implements Parseable {
    private String name = null;
    private String desc = null;
    private String ver = null;

    public SamplerEngine() {
    }

    public SamplerEngine(String[] stringArray) {
        for (String string : stringArray) {
            if (this.parse(string)) continue;
            Client.getLogger().info(LscpI18n.getLogMsg("unknownLine", string));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getVersion() {
        return this.ver;
    }

    @Override
    public boolean parse(String string) {
        if (string.startsWith("DESCRIPTION: ")) {
            this.desc = string.substring("DESCRIPTION: ".length(), string.length());
            this.desc = Parser.toNonEscapedString(this.desc);
        } else if (string.startsWith("VERSION: ")) {
            this.ver = string.substring("VERSION: ".length(), string.length());
        } else {
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getName() == null || object == null) {
            return false;
        }
        if (object instanceof SamplerEngine) {
            return this.getName().equals(((SamplerEngine)object).getName());
        }
        return false;
    }

    public String toString() {
        return this.getName() + " engine";
    }
}

