/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.SimpleBuildItem;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.logging.Logger;

public final class CuratedApplicationShutdownBuildItem
extends SimpleBuildItem {
    private static final Logger log = Logger.getLogger(CuratedApplicationShutdownBuildItem.class);
    private final boolean firstRun;
    private final CopyOnWriteArrayList<Runnable> tasks = new CopyOnWriteArrayList();
    private final QuarkusClassLoader baseCl;
    boolean registered;

    public CuratedApplicationShutdownBuildItem(QuarkusClassLoader baseCl, boolean firstRun) {
        this.firstRun = firstRun;
        this.baseCl = baseCl;
    }

    public synchronized void addCloseTask(Runnable task, boolean firstRunOnly) {
        if (firstRunOnly || this.firstRun) {
            if (!this.registered) {
                this.registered = true;
                this.baseCl.addCloseTask(new Runnable(){

                    @Override
                    public void run() {
                        for (Runnable i : CuratedApplicationShutdownBuildItem.this.tasks) {
                            try {
                                i.run();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to run close task", t);
                            }
                        }
                    }
                });
            }
            this.tasks.add(task);
        }
    }
}

