/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import org.jboss.logging.Logger;

public class MediaTypeMatcher {
    private static final Logger logger = Logger.getLogger(MediaTypeMatcher.class);

    public static boolean isHtmlRequest(HttpHeaders headers) {
        return MediaTypeMatcher.isAcceptMediaType(headers, MediaType.TEXT_HTML_TYPE);
    }

    public static boolean isJsonRequest(HttpHeaders headers) {
        return MediaTypeMatcher.isAcceptMediaType(headers, MediaType.APPLICATION_JSON_TYPE);
    }

    private static boolean isAcceptMediaType(HttpHeaders headers, MediaType textHtmlType) {
        try {
            for (MediaType m : headers.getAcceptableMediaTypes()) {
                if (m.isWildcardType() || !m.isCompatible(textHtmlType)) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Could not determine if the media type is accepted", (Throwable)e);
        }
        return false;
    }
}

