/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import io.smallrye.config.ConfigValue;
import java.io.PrintWriter;
import java.nio.file.FileSystemException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.keycloak.platform.Platform;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.ShortErrorMessageHandler;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.integration.QuarkusPlatform;
import picocli.CommandLine;

public final class ExecutionExceptionHandler
implements CommandLine.IExecutionExceptionHandler {
    private static Logger logger;
    private boolean verbose;
    private static Map<String, Function<Throwable, Throwable>> exceptionTransformers;

    public int handleExecutionException(Exception cause, CommandLine cmd, CommandLine.ParseResult parseResult) {
        Throwable exception = ExecutionExceptionHandler.handleExceptionTransformers(cause);
        if (exception instanceof PropertyException) {
            PrintWriter writer = cmd.getErr();
            writer.println(cmd.getColorScheme().errorText(exception.getMessage()));
            if (this.verbose && exception.getCause() != null) {
                this.dumpException(writer, exception.getCause());
            }
            return ShortErrorMessageHandler.getInvalidInputExitCode(exception, cmd);
        }
        this.error(cmd.getErr(), "Failed to run '" + parseResult.subcommands().stream().map(CommandLine.ParseResult::commandSpec).map(CommandLine.Model.CommandSpec::name).findFirst().orElse(Environment.getCommand()) + "' command.", exception);
        return cmd.getCommandSpec().exitCodeOnExecutionException();
    }

    public void error(PrintWriter errorWriter, String message, Throwable cause) {
        Throwable exception = ExecutionExceptionHandler.handleExceptionTransformers(cause);
        if (message != null) {
            this.logError(errorWriter, "ERROR: " + message);
        }
        if (exception != null) {
            this.dumpException(errorWriter, exception);
            if (!this.verbose) {
                this.logError(errorWriter, "For more details run the same command passing the '--verbose' option. Also you can use '--help' to see the details about the usage of the particular command.");
            }
        }
    }

    private void dumpException(PrintWriter errorWriter, Throwable cause) {
        if (this.verbose) {
            this.logError(errorWriter, cause == null ? "Unknown error." : "Error details:", cause);
        } else {
            do {
                if (cause.getMessage() != null) {
                    this.logError(errorWriter, String.format("ERROR: %s", cause.getMessage()));
                }
                this.printErrorHints(errorWriter, cause);
            } while ((cause = cause.getCause()) != null);
        }
        this.printErrorHints(errorWriter, cause);
    }

    private void printErrorHints(PrintWriter errorWriter, Throwable cause) {
        if (cause instanceof FileSystemException) {
            FileSystemException fse = (FileSystemException)cause;
            ConfigValue httpsCertFile = Configuration.getConfig().getConfigValue("kc.https-certificate-file");
            if (fse.getFile().equals(Optional.ofNullable(httpsCertFile.getValue()).orElse(null))) {
                this.logError(errorWriter, Messages.httpsConfigurationNotSet());
            }
        }
    }

    private void logError(PrintWriter errorWriter, String errorMessage) {
        this.logError(errorWriter, errorMessage, null);
    }

    private void logError(PrintWriter errorWriter, String errorMessage, Throwable cause) {
        QuarkusPlatform platform = (QuarkusPlatform)Platform.getPlatform();
        if (platform.isStarted()) {
            if (cause == null) {
                ExecutionExceptionHandler.getLogger().error((Object)errorMessage);
            } else {
                ExecutionExceptionHandler.getLogger().error((Object)errorMessage, cause);
            }
        } else if (cause == null) {
            errorWriter.println(errorMessage);
        } else {
            errorWriter.println(errorMessage);
            cause.printStackTrace(errorWriter);
        }
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger(ExecutionExceptionHandler.class);
        }
        return logger;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static void addExceptionTransformer(Class<?> fromClass, Function<Throwable, Throwable> transformer) {
        if (exceptionTransformers.get(fromClass.getName()) != null) {
            ExecutionExceptionHandler.getLogger().warnf("Transformer for the '%s' class is overridden", (Object)fromClass.getName());
        }
        exceptionTransformers.put(fromClass.getName(), transformer);
    }

    public static void resetExceptionTransformers() {
        exceptionTransformers = new HashMap<String, Function<Throwable, Throwable>>();
    }

    private static Throwable handleExceptionTransformers(Throwable exception) {
        StackTraceElement[] stackTrace;
        if (exception == null) {
            return null;
        }
        if (exceptionTransformers.isEmpty()) {
            return exception;
        }
        for (StackTraceElement trace : stackTrace = exception.getStackTrace()) {
            Function<Throwable, Throwable> transformer = exceptionTransformers.get(trace.getClassName());
            if (transformer == null) continue;
            return transformer.apply(exception);
        }
        return exception;
    }

    static {
        exceptionTransformers = new HashMap<String, Function<Throwable, Throwable>>();
    }
}

