/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Rectangle;
import ai.djl.modality.cv.translator.Sam2Translator;
import ai.djl.ndarray.BytesSupplier;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import org.apache.commons.codec.binary.Base64OutputStream;

public class Sam2ServingTranslator
implements Translator<Input, Output> {
    private Sam2Translator translator;

    public Sam2ServingTranslator(Sam2Translator translator) {
        this.translator = translator;
    }

    @Override
    public Batchifier getBatchifier() {
        return this.translator.getBatchifier();
    }

    @Override
    public Output processOutput(TranslatorContext ctx, NDList list) throws IOException {
        Output output = new Output();
        Sam2Translator.Sam2Input sam2 = (Sam2Translator.Sam2Input)ctx.getAttachment("input");
        output.addProperty("Content-Type", "application/json");
        DetectedObjects detection = this.translator.processOutput(ctx, list);
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("result", detection);
        if (sam2.isVisualize()) {
            Image img = sam2.getImage();
            img.drawBoundingBoxes(detection, 0.8f);
            img.drawMarks(sam2.getPoints());
            for (Rectangle rect : sam2.getBoxes()) {
                img.drawRectangle(rect, 0xFF0000, 6);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write("data:image/png;base64,".getBytes(StandardCharsets.UTF_8));
            Base64OutputStream bos = new Base64OutputStream((OutputStream)os, true, 0, null);
            img.save((OutputStream)bos, "png");
            bos.close();
            os.close();
            ret.put("image", os.toString(StandardCharsets.UTF_8.name()));
        }
        output.add(BytesSupplier.wrapAsJson(ret));
        return output;
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Input input) throws Exception {
        BytesSupplier data = input.getData();
        try {
            if (data == null) {
                throw new TranslateException("Input data is empty.");
            }
            Sam2Translator.Sam2Input sam2 = Sam2Translator.Sam2Input.fromJson(data.getAsString());
            ctx.setAttachment("input", sam2);
            return this.translator.processInput(ctx, sam2);
        }
        catch (IOException e) {
            throw new TranslateException("Input is not an Image data type", e);
        }
    }

    @Override
    public void prepare(TranslatorContext ctx) throws Exception {
        this.translator.prepare(ctx);
    }
}

