/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.security.UpdateDistinguishedNameResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class UpdateDistinguishedNameRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, UpdateDistinguishedNameRequest> {
    @Nonnull
    private final String clusterName;
    @Nonnull
    private final List<String> nodesDn;
    public static final JsonpDeserializer<UpdateDistinguishedNameRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateDistinguishedNameRequest::setupUpdateDistinguishedNameRequestDeserializer);
    public static final Endpoint<UpdateDistinguishedNameRequest, UpdateDistinguishedNameResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateDistinguishedNameRequest, UpdateDistinguishedNameResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_security/api/nodesdn/");
        SimpleEndpoint.pathEncode(request.clusterName, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, UpdateDistinguishedNameResponse._DESERIALIZER);

    private UpdateDistinguishedNameRequest(Builder builder) {
        super(builder);
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.nodesDn = ApiTypeHelper.unmodifiable(builder.nodesDn);
    }

    public static UpdateDistinguishedNameRequest of(Function<Builder, ObjectBuilder<UpdateDistinguishedNameRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String clusterName() {
        return this.clusterName;
    }

    @Nonnull
    public final List<String> nodesDn() {
        return this.nodesDn;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.nodesDn)) {
            generator.writeKey("nodes_dn");
            generator.writeStartArray();
            for (String item0 : this.nodesDn) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupUpdateDistinguishedNameRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodesDn, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "nodes_dn");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.clusterName.hashCode();
        result = 31 * result + Objects.hashCode(this.nodesDn);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateDistinguishedNameRequest other = (UpdateDistinguishedNameRequest)o;
        return this.clusterName.equals(other.clusterName) && Objects.equals(this.nodesDn, other.nodesDn);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, UpdateDistinguishedNameRequest> {
        private String clusterName;
        @Nullable
        private List<String> nodesDn;

        public Builder() {
        }

        private Builder(UpdateDistinguishedNameRequest o) {
            super(o);
            this.clusterName = o.clusterName;
            this.nodesDn = Builder._listCopy(o.nodesDn);
        }

        private Builder(Builder o) {
            super(o);
            this.clusterName = o.clusterName;
            this.nodesDn = Builder._listCopy(o.nodesDn);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        @Nonnull
        public final Builder nodesDn(List<String> list) {
            this.nodesDn = Builder._listAddAll(this.nodesDn, list);
            return this;
        }

        @Nonnull
        public final Builder nodesDn(String value, String ... values) {
            this.nodesDn = Builder._listAdd(this.nodesDn, value, values);
            return this;
        }

        @Override
        @Nonnull
        public UpdateDistinguishedNameRequest build() {
            this._checkSingleUse();
            return new UpdateDistinguishedNameRequest(this);
        }
    }
}

