/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.protobuf;

import com.oracle.labs.mlrg.olcut.config.SerializedObject;
import com.oracle.labs.mlrg.olcut.config.io.ConfigWriter;
import com.oracle.labs.mlrg.olcut.config.io.ConfigWriterException;
import com.oracle.labs.mlrg.olcut.config.property.ListProperty;
import com.oracle.labs.mlrg.olcut.config.property.MapProperty;
import com.oracle.labs.mlrg.olcut.config.property.Property;
import com.oracle.labs.mlrg.olcut.config.property.SimpleProperty;
import com.oracle.labs.mlrg.olcut.config.protobuf.protos.ComponentProto;
import com.oracle.labs.mlrg.olcut.config.protobuf.protos.ConfigProto;
import com.oracle.labs.mlrg.olcut.config.protobuf.protos.PropertyListProto;
import com.oracle.labs.mlrg.olcut.config.protobuf.protos.PropertyMapProto;
import com.oracle.labs.mlrg.olcut.config.protobuf.protos.SerializedObjectProto;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;

public final class ProtoConfigWriter
implements ConfigWriter {
    private final OutputStream writer;
    private final boolean writeAsText;
    private final ConfigProto.Builder builder;

    public ProtoConfigWriter(OutputStream writer, boolean writeAsText) {
        this.writer = writer;
        this.writeAsText = writeAsText;
        this.builder = ConfigProto.newBuilder();
    }

    public void writeStartDocument() throws ConfigWriterException {
    }

    public void writeEndDocument() throws ConfigWriterException {
    }

    public void writeGlobalProperties(Map<String, String> props) throws ConfigWriterException {
        this.builder.putAllProperties(props);
    }

    public void writeSerializedObjects(Map<String, SerializedObject> map) throws ConfigWriterException {
        for (Map.Entry<String, SerializedObject> e : map.entrySet()) {
            SerializedObject serObj = e.getValue();
            SerializedObjectProto.Builder serObjBuilder = SerializedObjectProto.newBuilder();
            serObjBuilder.setName(serObj.getName());
            serObjBuilder.setType(serObj.getClassName());
            serObjBuilder.setLocation(serObj.getLocation());
            this.builder.addSerializedObject(serObjBuilder.build());
        }
    }

    public void writeStartComponents() throws ConfigWriterException {
    }

    public void writeComponent(Map<String, String> attributes, Map<String, Property> properties) {
        ComponentProto.Builder componentBuilder = ComponentProto.newBuilder();
        componentBuilder.setName(attributes.get("name"));
        componentBuilder.setType(attributes.get("type"));
        if (attributes.get("export").equalsIgnoreCase("true")) {
            componentBuilder.setExportable(true);
        }
        if (attributes.get("import").equalsIgnoreCase("true")) {
            componentBuilder.setImportable(true);
        }
        if (attributes.containsKey("entries")) {
            componentBuilder.setEntries(attributes.get("entries"));
        }
        if (attributes.containsKey("leasetime")) {
            componentBuilder.setLeaseTime(Long.parseLong(attributes.get("leasetime")));
        }
        if (attributes.containsKey("serialized")) {
            componentBuilder.setSerialized(attributes.get("serialized"));
        }
        for (Map.Entry<String, Property> property : properties.entrySet()) {
            String key = property.getKey();
            Property value = property.getValue();
            if (value instanceof ListProperty) {
                PropertyListProto.Builder listBuilder = PropertyListProto.newBuilder();
                listBuilder.setName(key);
                for (SimpleProperty simpleProperty : ((ListProperty)value).getSimpleList()) {
                    listBuilder.addItem(simpleProperty.getValue());
                }
                for (Class clazz : ((ListProperty)value).getClassList()) {
                    listBuilder.addType(clazz.getName());
                }
                componentBuilder.addListProperty(listBuilder.build());
                continue;
            }
            if (value instanceof MapProperty) {
                PropertyMapProto.Builder mapBuilder = PropertyMapProto.newBuilder();
                mapBuilder.setName(key);
                for (Map.Entry entry : ((MapProperty)value).getMap().entrySet()) {
                    mapBuilder.putElements((String)entry.getKey(), ((SimpleProperty)entry.getValue()).getValue());
                }
                componentBuilder.addMapProperty(mapBuilder.build());
                continue;
            }
            componentBuilder.putProperties(key, value.toString());
        }
        this.builder.addComponents(componentBuilder.build());
    }

    public void writeEndComponents() throws ConfigWriterException {
    }

    public void close() throws ConfigWriterException {
        ConfigProto proto = this.builder.build();
        try {
            if (this.writeAsText) {
                PrintStream stream = new PrintStream(this.writer);
                stream.println(proto.toString());
                stream.close();
            } else {
                proto.writeTo(this.writer);
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new ConfigWriterException((Exception)e);
        }
    }
}

