/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.stats.info;

import java.io.IOException;
import java.util.concurrent.atomic.LongAdder;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.neuralsearch.stats.common.StatSnapshot;
import org.opensearch.neuralsearch.stats.info.InfoStatName;

public class CountableInfoStatSnapshot
implements StatSnapshot<Long> {
    private LongAdder adder;
    private InfoStatName statName;

    public CountableInfoStatSnapshot(InfoStatName statName) {
        this.statName = statName;
        this.adder = new LongAdder();
    }

    @Override
    public Long getValue() {
        return this.adder.longValue();
    }

    public void incrementBy(Long delta) {
        this.adder.add(delta);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("value", this.getValue());
        builder.field("stat_type", this.statName.getStatType().getTypeString());
        builder.endObject();
        return builder;
    }
}

