/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class KeepWordsTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, KeepWordsTokenFilter> {
    @Nonnull
    private final List<String> keepWords;
    @Nullable
    private final Boolean keepWordsCase;
    @Nullable
    private final String keepWordsPath;
    public static final JsonpDeserializer<KeepWordsTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeepWordsTokenFilter::setupKeepWordsTokenFilterDeserializer);

    private KeepWordsTokenFilter(Builder builder) {
        super(builder);
        this.keepWords = ApiTypeHelper.unmodifiable(builder.keepWords);
        this.keepWordsCase = builder.keepWordsCase;
        this.keepWordsPath = builder.keepWordsPath;
    }

    public static KeepWordsTokenFilter of(Function<Builder, ObjectBuilder<KeepWordsTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Keep;
    }

    @Nonnull
    public final List<String> keepWords() {
        return this.keepWords;
    }

    @Nullable
    public final Boolean keepWordsCase() {
        return this.keepWordsCase;
    }

    @Nullable
    public final String keepWordsPath() {
        return this.keepWordsPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keep");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.keepWords)) {
            generator.writeKey("keep_words");
            generator.writeStartArray();
            for (String item0 : this.keepWords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.keepWordsCase != null) {
            generator.writeKey("keep_words_case");
            generator.write(this.keepWordsCase.booleanValue());
        }
        if (this.keepWordsPath != null) {
            generator.writeKey("keep_words_path");
            generator.write(this.keepWordsPath);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupKeepWordsTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        KeepWordsTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::keepWords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "keep_words");
        op.add(Builder::keepWordsCase, JsonpDeserializer.booleanDeserializer(), "keep_words_case");
        op.add(Builder::keepWordsPath, JsonpDeserializer.stringDeserializer(), "keep_words_path");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.keepWords);
        result = 31 * result + Objects.hashCode(this.keepWordsCase);
        result = 31 * result + Objects.hashCode(this.keepWordsPath);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeepWordsTokenFilter other = (KeepWordsTokenFilter)o;
        return Objects.equals(this.keepWords, other.keepWords) && Objects.equals(this.keepWordsCase, other.keepWordsCase) && Objects.equals(this.keepWordsPath, other.keepWordsPath);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, KeepWordsTokenFilter> {
        @Nullable
        private List<String> keepWords;
        @Nullable
        private Boolean keepWordsCase;
        @Nullable
        private String keepWordsPath;

        public Builder() {
        }

        private Builder(KeepWordsTokenFilter o) {
            super(o);
            this.keepWords = Builder._listCopy(o.keepWords);
            this.keepWordsCase = o.keepWordsCase;
            this.keepWordsPath = o.keepWordsPath;
        }

        private Builder(Builder o) {
            super(o);
            this.keepWords = Builder._listCopy(o.keepWords);
            this.keepWordsCase = o.keepWordsCase;
            this.keepWordsPath = o.keepWordsPath;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder keepWords(List<String> list) {
            this.keepWords = Builder._listAddAll(this.keepWords, list);
            return this;
        }

        @Nonnull
        public final Builder keepWords(String value, String ... values) {
            this.keepWords = Builder._listAdd(this.keepWords, value, values);
            return this;
        }

        @Nonnull
        public final Builder keepWordsCase(@Nullable Boolean value) {
            this.keepWordsCase = value;
            return this;
        }

        @Nonnull
        public final Builder keepWordsPath(@Nullable String value) {
            this.keepWordsPath = value;
            return this;
        }

        @Override
        @Nonnull
        public KeepWordsTokenFilter build() {
            this._checkSingleUse();
            return new KeepWordsTokenFilter(this);
        }
    }
}

