/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.util.Collection;
import net.sourceforge.plantuml.asciiart.AsciiShape;
import net.sourceforge.plantuml.asciiart.BasicCharAreaImpl;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;

public class UmlCharAreaImpl
extends BasicCharAreaImpl
implements UmlCharArea {
    @Override
    public void drawBoxSimple(int x, int y, int width, int height) {
        this.drawHLine('-', y, x + 1, x + width - 1);
        this.drawHLine('-', y + height - 1, x + 1, x + width - 1);
        this.drawVLine('|', x, y + 1, y + height - 1);
        this.drawVLine('|', x + width - 1, y + 1, y + height - 1);
        this.drawChar(',', x, y);
        this.drawChar('.', x + width - 1, y);
        this.drawChar('`', x, y + height - 1);
        this.drawChar('\'', x + width - 1, y + height - 1);
    }

    @Override
    public void drawBoxSimpleUnicode(int x, int y, int width, int height) {
        this.drawHLine('\u2500', y, x + 1, x + width - 1);
        this.drawHLine('\u2500', y + height - 1, x + 1, x + width - 1);
        this.drawVLine('\u2502', x, y + 1, y + height - 1);
        this.drawVLine('\u2502', x + width - 1, y + 1, y + height - 1);
        this.drawChar('\u250c', x, y);
        this.drawChar('\u2510', x + width - 1, y);
        this.drawChar('\u2514', x, y + height - 1);
        this.drawChar('\u2518', x + width - 1, y + height - 1);
    }

    @Override
    public void drawShape(AsciiShape shape, int x, int y) {
        shape.draw(this, x, y);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawStringsLRSimple(Collection<? extends CharSequence> strings, int x, int y) {
        int i = 0;
        if (x < 0) {
            x = 0;
        }
        for (CharSequence charSequence : strings) {
            void var6_6;
            if (charSequence instanceof MessageNumber) {
                String string = ((MessageNumber)charSequence).getNumberRaw();
            }
            this.drawStringLR(var6_6.toString(), x, y + i);
            ++i;
        }
    }

    @Override
    public void drawStringsLRUnicode(Collection<? extends CharSequence> strings, int x, int y) {
        int i = 0;
        if (x < 0) {
            x = 0;
        }
        for (CharSequence charSequence : strings) {
            this.drawStringLR(charSequence.toString(), x, y + i);
            ++i;
        }
    }

    @Override
    public void drawNoteSimple(int x, int y, int width, int height) {
        this.drawHLine('-', y, x + 1, x + width - 1);
        this.drawHLine('-', y + height - 1, x + 1, x + width - 1);
        this.drawVLine('|', x, y + 1, y + height - 1);
        this.drawVLine('|', x + width - 1, y + 1, y + height - 1);
        this.drawChar(',', x, y);
        this.drawStringLR("!. ", x + width - 3, y);
        this.drawStringLR("|_\\", x + width - 3, y + 1);
        this.drawChar('`', x, y + height - 1);
        this.drawChar('\'', x + width - 1, y + height - 1);
    }

    @Override
    public void drawNoteSimpleUnicode(int x, int y, int width, int height) {
        this.drawChar('\u2591', x + width - 2, y + 1);
        this.drawHLine('\u2550', y, x + 1, x + width - 1, '\u2502', '\u2567');
        this.drawHLine('\u2550', y + height - 1, x + 1, x + width - 1, '\u2502', '\u2564');
        this.drawVLine('\u2551', x, y + 1, y + height - 1);
        this.drawVLine('\u2551', x + width - 1, y + 1, y + height - 1);
        this.drawChar('\u2554', x, y);
        this.drawChar('\u2557', x + width - 1, y);
        this.drawChar('\u255a', x, y + height - 1);
        this.drawChar('\u255d', x + width - 1, y + height - 1);
    }
}

