/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.metadata.AbstractMetadataMethod;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;
import org.firebirdsql.jdbc.metadata.TypeMetadata;
import org.firebirdsql.util.FirebirdSupportInfo;

public abstract class GetColumns
extends AbstractMetadataMethod {
    private static final RowDescriptor ROW_DESCRIPTOR = new RowDescriptorBuilder(26, DbMetadataMediator.datatypeCoder).at(0).simple(449, 63, "TABLE_CAT", "COLUMNINFO").addField().at(1).simple(449, 63, "TABLE_SCHEM", "COLUMNINFO").addField().at(2).simple(448, 63, "TABLE_NAME", "COLUMNINFO").addField().at(3).simple(448, 63, "COLUMN_NAME", "COLUMNINFO").addField().at(4).simple(496, 0, "DATA_TYPE", "COLUMNINFO").addField().at(5).simple(449, 31, "TYPE_NAME", "COLUMNINFO").addField().at(6).simple(496, 0, "COLUMN_SIZE", "COLUMNINFO").addField().at(7).simple(496, 0, "BUFFER_LENGTH", "COLUMNINFO").addField().at(8).simple(496, 0, "DECIMAL_DIGITS", "COLUMNINFO").addField().at(9).simple(496, 0, "NUM_PREC_RADIX", "COLUMNINFO").addField().at(10).simple(496, 0, "NULLABLE", "COLUMNINFO").addField().at(11).simple(449, Integer.MAX_VALUE, "REMARKS", "COLUMNINFO").addField().at(12).simple(449, Integer.MAX_VALUE, "COLUMN_DEF", "COLUMNINFO").addField().at(13).simple(496, 0, "SQL_DATA_TYPE", "COLUMNINFO").addField().at(14).simple(496, 0, "SQL_DATETIME_SUB", "COLUMNINFO").addField().at(15).simple(496, 0, "CHAR_OCTET_LENGTH", "COLUMNINFO").addField().at(16).simple(496, 0, "ORDINAL_POSITION", "COLUMNINFO").addField().at(17).simple(448, 3, "IS_NULLABLE", "COLUMNINFO").addField().at(18).simple(448, 63, "SCOPE_CATALOG", "COLUMNINFO").addField().at(19).simple(448, 63, "SCOPE_SCHEMA", "COLUMNINFO").addField().at(20).simple(448, 63, "SCOPE_TABLE", "COLUMNINFO").addField().at(21).simple(500, 0, "SOURCE_DATA_TYPE", "COLUMNINFO").addField().at(22).simple(448, 3, "IS_AUTOINCREMENT", "COLUMNINFO").addField().at(23).simple(448, 3, "IS_GENERATEDCOLUMN", "COLUMNINFO").addField().at(24).simple(448, 3, "JB_IS_IDENTITY", "COLUMNINFO").addField().at(25).simple(448, 10, "JB_IDENTITY_TYPE", "COLUMNINFO").addField().toRowDescriptor();

    private GetColumns(DbMetadataMediator mediator) {
        super(ROW_DESCRIPTOR, mediator);
    }

    public final ResultSet getColumns(String tableNamePattern, String columnNamePattern) throws SQLException {
        if ("".equals(tableNamePattern) || "".equals(columnNamePattern)) {
            return this.createEmpty();
        }
        DbMetadataMediator.MetadataQuery metadataQuery = this.createGetColumnsQuery(tableNamePattern, columnNamePattern);
        return this.createMetaDataResultSet(metadataQuery);
    }

    @Override
    final RowValue createMetadataRow(ResultSet rs, RowValueBuilder valueBuilder) throws SQLException {
        TypeMetadata typeMetadata = TypeMetadata.builder(this.mediator.getFirebirdSupportInfo()).fromCurrentRow(rs).build();
        boolean isNullable = rs.getBoolean("IS_NULLABLE");
        boolean isComputed = rs.getBoolean("IS_COMPUTED");
        boolean isIdentity = rs.getBoolean("IS_IDENTITY");
        return valueBuilder.at(2).setString(rs.getString("RELATION_NAME")).at(3).setString(rs.getString("FIELD_NAME")).at(4).setInt(typeMetadata.getJdbcType()).at(5).setString(typeMetadata.getSqlTypeName()).at(6).setInt(typeMetadata.getColumnSize()).at(8).setInt(typeMetadata.getScale()).at(9).setInt(typeMetadata.getRadix()).at(10).setInt(isNullable ? 1 : 0).at(11).setString(rs.getString("REMARKS")).at(12).setString(GetColumns.extractDefault(rs.getString("DEFAULT_SOURCE"))).at(15).setInt(typeMetadata.getCharOctetLength()).at(16).setInt(rs.getInt("FIELD_POSITION")).at(17).setString(isNullable ? "YES" : "NO").at(22).setString(this.getIsAutoIncrementValue(isIdentity, typeMetadata)).at(23).setString(isComputed || isIdentity ? "YES" : "NO").at(24).setString(isIdentity ? "YES" : "NO").at(25).setString(rs.getString("JB_IDENTITY_TYPE")).toRowValue(true);
    }

    private String getIsAutoIncrementValue(boolean isIdentity, TypeMetadata typeMetadata) {
        if (isIdentity) {
            return "YES";
        }
        switch (typeMetadata.getJdbcType()) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "";
            }
            case 2: 
            case 3: {
                if (Objects.equals(typeMetadata.getScale(), 0) && typeMetadata.getType() != 26) {
                    return "";
                }
                return "NO";
            }
        }
        return "NO";
    }

    abstract DbMetadataMediator.MetadataQuery createGetColumnsQuery(String var1, String var2);

    public static GetColumns create(DbMetadataMediator mediator) {
        FirebirdSupportInfo firebirdSupportInfo = mediator.getFirebirdSupportInfo();
        if (firebirdSupportInfo.isVersionEqualOrAbove(3, 0)) {
            return FB3.createInstance(mediator);
        }
        return FB2_5.createInstance(mediator);
    }

    private static class FB3
    extends GetColumns {
        private static final String GET_COLUMNS_FRAGMENT_3 = "select\n  trim(trailing from RF.RDB$RELATION_NAME) as RELATION_NAME,\n  trim(trailing from RF.RDB$FIELD_NAME) as FIELD_NAME,\n  F.RDB$FIELD_TYPE as FIELD_TYPE,\n  F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE,\n  F.RDB$FIELD_PRECISION as FIELD_PRECISION,\n  F.RDB$FIELD_SCALE as FIELD_SCALE,\n  F.RDB$FIELD_LENGTH as FIELD_LENGTH,\n  F.RDB$CHARACTER_LENGTH as CHAR_LEN,\n  F.RDB$CHARACTER_SET_ID as CHARSET_ID,\n  RF.RDB$DESCRIPTION as REMARKS,\n  coalesce(RF.RDB$DEFAULT_SOURCE, F.RDB$DEFAULT_SOURCE) as DEFAULT_SOURCE,\n  RF.RDB$FIELD_POSITION + 1 as FIELD_POSITION,\n  (coalesce(RF.RDB$NULL_FLAG, 0) + coalesce(F.RDB$NULL_FLAG, 0) = 0) as IS_NULLABLE,\n  (F.RDB$COMPUTED_BLR is not NULL) as IS_COMPUTED,\n  (RF.RDB$IDENTITY_TYPE IS NOT NULL) as IS_IDENTITY,\n  trim(trailing from decode(RF.RDB$IDENTITY_TYPE, 0, 'ALWAYS', 1, 'BY DEFAULT')) as JB_IDENTITY_TYPE\nfrom RDB$RELATION_FIELDS RF inner join RDB$FIELDS F on RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME";
        private static final String GET_COLUMNS_ORDER_BY_3 = "\norder by RF.RDB$RELATION_NAME, RF.RDB$FIELD_POSITION";

        private FB3(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetColumns createInstance(DbMetadataMediator mediator) {
            return new FB3(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetColumnsQuery(String tableNamePattern, String columnNamePattern) {
            Clause tableNameClause = new Clause("RF.RDB$RELATION_NAME", tableNamePattern);
            Clause columnNameClause = new Clause("RF.RDB$FIELD_NAME", columnNamePattern);
            String sql = GET_COLUMNS_FRAGMENT_3 + (Clause.anyCondition(tableNameClause, columnNameClause) ? "\nwhere " + tableNameClause.getCondition(columnNameClause.hasCondition()) + columnNameClause.getCondition(false) : "") + GET_COLUMNS_ORDER_BY_3;
            return new DbMetadataMediator.MetadataQuery(sql, Clause.parameters(tableNameClause, columnNameClause));
        }
    }

    private static class FB2_5
    extends GetColumns {
        private static final String GET_COLUMNS_FRAGMENT_2_5 = "select\n  RF.RDB$RELATION_NAME as RELATION_NAME,\n  RF.RDB$FIELD_NAME as FIELD_NAME,\n  F.RDB$FIELD_TYPE as FIELD_TYPE,\n  F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE,\n  F.RDB$FIELD_PRECISION as FIELD_PRECISION,\n  F.RDB$FIELD_SCALE as FIELD_SCALE,\n  F.RDB$FIELD_LENGTH as FIELD_LENGTH,\n  F.RDB$CHARACTER_LENGTH as CHAR_LEN,\n  F.RDB$CHARACTER_SET_ID as CHARSET_ID,\n  RF.RDB$DESCRIPTION as REMARKS,\n  coalesce(RF.RDB$DEFAULT_SOURCE, F.RDB$DEFAULT_SOURCE) as DEFAULT_SOURCE,\n  RF.RDB$FIELD_POSITION + 1 as FIELD_POSITION,\n  iif(coalesce(RF.RDB$NULL_FLAG, 0) + coalesce(F.RDB$NULL_FLAG, 0) = 0, 'T', 'F') as IS_NULLABLE,\n  iif(F.RDB$COMPUTED_BLR is not NULL, 'T', 'F') as IS_COMPUTED,\n  'F' as IS_IDENTITY,\n  cast(NULL as VARCHAR(10)) as JB_IDENTITY_TYPE\nfrom RDB$RELATION_FIELDS RF inner join RDB$FIELDS F on RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME";
        private static final String GET_COLUMNS_ORDER_BY_2_5 = "\norder by RF.RDB$RELATION_NAME, RF.RDB$FIELD_POSITION";

        private FB2_5(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetColumns createInstance(DbMetadataMediator mediator) {
            return new FB2_5(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetColumnsQuery(String tableNamePattern, String columnNamePattern) {
            Clause tableNameClause = new Clause("RF.RDB$RELATION_NAME", tableNamePattern);
            Clause columnNameClause = new Clause("RF.RDB$FIELD_NAME", columnNamePattern);
            String sql = GET_COLUMNS_FRAGMENT_2_5 + (Clause.anyCondition(tableNameClause, columnNameClause) ? "\nwhere " + tableNameClause.getCondition(columnNameClause.hasCondition()) + columnNameClause.getCondition(false) : "") + GET_COLUMNS_ORDER_BY_2_5;
            return new DbMetadataMediator.MetadataQuery(sql, Clause.parameters(tableNameClause, columnNameClause));
        }
    }
}

