/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.deque;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.HashNotImplemented;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.deque.DequeBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.deque.DequeBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.deque.DequeBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.deque.PDeque;
import com.oracle.graal.python.builtins.objects.deque.PDequeIter;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqAssItem;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqContains;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectGetStateNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.Iterator;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDeque})
@HashNotImplemented
public final class DequeBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = DequeBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DequeBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Bind PythonLanguage language) {
            return PFactory.createGenericAlias(language, cls, key);
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    public static abstract class DequeRichCmpNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        @Specialization(guards={"self == other", "op.isEqOrNe()"})
        static boolean doSame(PDeque self, PDeque other, RichCmpOp op) {
            return op == RichCmpOp.Py_EQ;
        }

        @Specialization(guards={"self.getSize() != other.getSize()", "op.isEqOrNe()"})
        static boolean doDifferentLengths(PDeque self, PDeque other, RichCmpOp op) {
            return op == RichCmpOp.Py_NE;
        }

        @Specialization(guards={"!isPDeque(self) || !isPDeque(other)"})
        static Object doOther(Object self, Object other, RichCmpOp op) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @Specialization(guards={"isGenericCase(self, other, op)"})
        static Object doGeneric(VirtualFrame frame, PDeque self, PDeque other, RichCmpOp op, @Bind Node inliningTarget, @Cached PyObjectGetIter getIterSelf, @Cached PyObjectGetIter getIterOther, @Cached PyIterNextNode selfItNextNode, @Cached PyIterNextNode otherItNextNode, @Cached PyObjectRichCompareBool eqNode, @Cached PyObjectRichCompareBool cmpNode) {
            block3: {
                Object otherItem;
                Object selfItem;
                Object ait = getIterSelf.execute((Frame)frame, inliningTarget, self);
                Object bit = getIterOther.execute((Frame)frame, inliningTarget, other);
                do {
                    try {
                        selfItem = selfItNextNode.execute((Frame)frame, inliningTarget, ait);
                        otherItem = otherItNextNode.execute((Frame)frame, inliningTarget, bit);
                    }
                    catch (IteratorExhausted e) {
                        break block3;
                    }
                } while (eqNode.execute((Frame)frame, inliningTarget, selfItem, otherItem, RichCmpOp.Py_EQ));
                return cmpNode.execute((Frame)frame, inliningTarget, selfItem, otherItem, op);
            }
            return cmpNode.execute((Frame)frame, inliningTarget, self.getSize(), other.getSize(), op);
        }

        static boolean isPDeque(Object object) {
            return object instanceof PDeque;
        }

        static boolean isGenericCase(PDeque self, PDeque other, RichCmpOp op) {
            return !op.isEqOrNe() || self != other && self.getSize() == other.getSize();
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DequeReduceNode
    extends PythonUnaryBuiltinNode {
        DequeReduceNode() {
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, PDeque self, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached PyObjectGetStateNode getStateNode, @Cached GetClassNode getClassNode, @Bind PythonLanguage language) {
            Object clazz = getClassNode.execute(inliningTarget, self);
            Object state = getStateNode.execute(frame, inliningTarget, self);
            Object it = getIter.execute((Frame)frame, inliningTarget, self);
            PTuple emptyTuple = PFactory.createEmptyTuple(language);
            int maxLength = self.getMaxLength();
            if (maxLength != -1) {
                return PFactory.createTuple(language, new Object[]{clazz, PFactory.createTuple(language, new Object[]{emptyTuple, maxLength}), state, it});
            }
            return PFactory.createTuple(language, new Object[]{clazz, emptyTuple, state, it});
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class DequeReprNode
    extends PythonUnaryBuiltinNode {
        DequeReprNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        @CompilerDirectives.TruffleBoundary
        TruffleString repr(PDeque self) {
            if (!this.getContext().reprEnter(self)) {
                return StringLiterals.T_ELLIPSIS_IN_BRACKETS;
            }
            EncapsulatingNodeReference ref = EncapsulatingNodeReference.getCurrent();
            Node outerNode = ref.set((Node)this);
            try {
                Object[] items = self.data.toArray();
                PList asList = PFactory.createList(PythonLanguage.get(null), items);
                int maxLength = self.getMaxLength();
                TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                sb.appendStringUncached(TypeNodes.GetNameNode.executeUncached(GetClassNode.GetPythonObjectClassNode.executeUncached(self)));
                sb.appendStringUncached(StringLiterals.T_LPAREN);
                sb.appendStringUncached(PyObjectStrAsTruffleStringNode.executeUncached(asList));
                if (maxLength != -1) {
                    sb.appendStringUncached(PythonUtils.toTruffleStringUncached(", maxlen="));
                    sb.appendIntNumberUncached(maxLength);
                }
                sb.appendStringUncached(StringLiterals.T_RPAREN);
                TruffleString truffleString = sb.toStringUncached();
                return truffleString;
            }
            finally {
                ref.set(outerNode);
                this.getContext().reprLeave(self);
            }
        }
    }

    @Builtin(name="__reversed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeReversedNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDequeIter doGeneric(PDeque self, @Bind PythonLanguage language) {
            return PFactory.createDequeRevIter(language, self);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class DequeIterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDequeIter doGeneric(PDeque self, @Bind PythonLanguage language) {
            return PFactory.createDequeIter(language, self);
        }
    }

    @Slot(value=Slot.SlotKind.sq_ass_item, isComplex=true)
    @GenerateNodeFactory
    public static abstract class DequeSetItemNode
    extends TpSlotSqAssItem.SqAssItemBuiltinNode {
        @Specialization
        static void setOrDel(PDeque self, int idx, Object value, @Cached IndexNodes.NormalizeIndexCustomMessageNode normalizeIndexNode) {
            int normIdx = normalizeIndexNode.execute(idx, self.getSize(), ErrorMessages.DEQUE_INDEX_OUT_OF_RANGE);
            self.setItem(normIdx, value != PNone.NO_VALUE ? value : null);
        }
    }

    @Slot(value=Slot.SlotKind.sq_item, isComplex=true)
    @GenerateNodeFactory
    public static abstract class DequeGetItemNode
    extends TpSlotSizeArgFun.SqItemBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object doGeneric(PDeque self, int idx, @Cached IndexNodes.NormalizeIndexCustomMessageNode normalizeIndexNode) {
            int normIdx = normalizeIndexNode.execute(idx, self.getSize(), ErrorMessages.DEQUE_INDEX_OUT_OF_RANGE);
            return this.doGetItem(self, normIdx);
        }

        @CompilerDirectives.TruffleBoundary
        Object doGetItem(PDeque self, int idx) {
            assert (0 <= idx && idx < self.getSize());
            Iterator<Object> it = self.data.iterator();
            for (int i = 0; i < idx; ++i) {
                it.next();
            }
            return it.next();
        }
    }

    @Slot(value=Slot.SlotKind.sq_contains, isComplex=true)
    @GenerateNodeFactory
    public static abstract class DequeContainsNode
    extends TpSlotSqContains.SqContainsBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        boolean doGeneric(PDeque self, Object value) {
            int startState = self.getState();
            for (Object item : self.data) {
                if (PyObjectRichCompareBool.executeUncached(item, value, RichCmpOp.Py_EQ)) {
                    return true;
                }
                if (startState == self.getState()) continue;
                throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.RuntimeError, ErrorMessages.DEQUE_MUTATED_DURING_ITERATION);
            }
            return false;
        }
    }

    @Slot(value=Slot.SlotKind.sq_repeat, isComplex=true)
    @GenerateNodeFactory
    public static abstract class DequeMulNode
    extends TpSlotSizeArgFun.SqRepeatBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        PDeque doGeneric(PDeque self, int n) {
            PDeque newDeque = PFactory.createDeque(PythonLanguage.get(null));
            newDeque.setMaxLength(self.getMaxLength());
            newDeque.addAll(self);
            return DequeInplaceMulNode.doGeneric(this, newDeque, n);
        }
    }

    @Slot(value=Slot.SlotKind.sq_inplace_repeat, isComplex=true)
    @GenerateNodeFactory
    public static abstract class DequeInplaceMulNode
    extends TpSlotSizeArgFun.SqRepeatBuiltinNode {
        @Specialization
        PDeque doGeneric(PDeque self, int n) {
            return DequeInplaceMulNode.doGeneric(this, self, n);
        }

        @CompilerDirectives.TruffleBoundary
        static PDeque doGeneric(Node node, PDeque self, int n) {
            int size = self.getSize();
            if (size == 0 || n == 1) {
                return self;
            }
            if (n <= 1) {
                self.clear();
                return self;
            }
            if (size > Integer.MAX_VALUE / n) {
                throw PRaiseNode.raiseStatic(node, PythonBuiltinClassType.MemoryError);
            }
            int repetitions = n;
            if (self.getMaxLength() >= 0 && n * size > self.getMaxLength()) {
                repetitions = (self.getMaxLength() + size - 1) / size;
            }
            Object[] items = self.data.toArray();
            for (int i = 0; i < repetitions - 1; ++i) {
                self.addAll(items);
            }
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.sq_concat, isComplex=true)
    @GenerateNodeFactory
    public static abstract class DequeAddNode
    extends TpSlotBinaryFunc.SqConcatBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PDeque doDeque(PDeque self, PDeque other) {
            PDeque newDeque = PFactory.createDeque(PythonLanguage.get(null));
            newDeque.setMaxLength(self.getMaxLength());
            newDeque.addAll(self);
            newDeque.addAll(other);
            return newDeque;
        }

        @Specialization(replaces={"doDeque"})
        static PDeque doGeneric(PDeque self, Object other, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            if (!(other instanceof PDeque)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CAN_ONLY_CONCATENATE_DEQUE_NOT_P_TO_DEQUE, other);
            }
            return DequeAddNode.doDeque(self, (PDeque)other);
        }
    }

    @Slot(value=Slot.SlotKind.sq_inplace_concat, isComplex=true)
    @GenerateNodeFactory
    public static abstract class DequeInplaceAddNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PDeque doDeque(PDeque self, PDeque other) {
            if (self == other) {
                self.addAll(self.data.toArray());
            } else {
                self.addAll(other);
            }
            return self;
        }

        @Specialization
        static PDeque doOther(VirtualFrame frame, PDeque self, Object other, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode nextNode) {
            if (other instanceof PDeque) {
                return DequeInplaceAddNode.doDeque(self, (PDeque)other);
            }
            assert (self != other);
            Object iterator = getIter.execute((Frame)frame, inliningTarget, other);
            try {
                while (true) {
                    Object next = nextNode.execute((Frame)frame, inliningTarget, iterator);
                    self.append(next);
                }
            }
            catch (IteratorExhausted e) {
                return self;
            }
        }
    }

    @Slot(value=Slot.SlotKind.sq_length)
    @GenerateNodeFactory
    @GenerateUncached
    public static abstract class DequeLenNode
    extends TpSlotLen.LenBuiltinNode {
        @Specialization
        static int doGeneric(PDeque self) {
            return self.getSize();
        }
    }

    @Builtin(name="rotate", minNumOfPositionalArgs=1, parameterNames={"$self", "n"})
    @GenerateNodeFactory
    @ArgumentClinic(name="n", conversion=ArgumentClinic.ClinicConversion.Index, defaultValue="1")
    public static abstract class DequeRotateNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DequeBuiltinsClinicProviders.DequeRotateNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"self.getSize() <= 1"})
        @CompilerDirectives.TruffleBoundary
        static PNone doEmptyOrSingleElement(PDeque self, int n) {
            return PNone.NONE;
        }

        @Specialization(guards={"n >= 0"})
        @CompilerDirectives.TruffleBoundary
        static PNone doRight(PDeque self, int n) {
            if (self.getSize() > 1) {
                int effectiveRot = n % self.getSize();
                for (int i = 0; i < effectiveRot; ++i) {
                    self.appendLeft(self.pop());
                }
            }
            return PNone.NONE;
        }

        @Specialization(guards={"n < 0"})
        @CompilerDirectives.TruffleBoundary
        static PNone doLeft(PDeque self, int n) {
            if (self.getSize() > 1) {
                int effectiveRot = -n % self.getSize();
                for (int i = 0; i < effectiveRot; ++i) {
                    self.append(self.popLeft());
                }
            }
            return PNone.NONE;
        }

        static void rotate(PDeque self, int n) {
            if (n < 0) {
                DequeRotateNode.doLeft(self, n);
            } else {
                DequeRotateNode.doRight(self, n);
            }
        }
    }

    @Builtin(name="reverse", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeReverseNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        PNone doGeneric(PDeque self) {
            int i;
            Object[] items = new Object[self.getSize()];
            for (i = 0; i < items.length; ++i) {
                items[i] = self.data.pollLast();
            }
            for (i = 0; i < items.length; ++i) {
                self.data.addLast(items[i]);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="remove", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeRemoveNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object doGeneric(PDeque self, Object value) {
            int n = self.getSize();
            for (int i = 0; i < n; ++i) {
                try {
                    boolean result = PyObjectRichCompareBool.executeUncached(self.peekLeft(), value, RichCmpOp.Py_EQ);
                    if (n != self.getSize()) {
                        throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.IndexError, ErrorMessages.DEQUE_MUTATED_DURING_REMOVE);
                    }
                    if (result) {
                        Object removed = self.popLeft();
                        assert (removed != null);
                        DequeRotateNode.doRight(self, i);
                        return PNone.NONE;
                    }
                    self.append(self.popLeft());
                    continue;
                }
                catch (PException e) {
                    DequeRotateNode.doRight(self, i);
                    throw e;
                }
            }
            throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.ValueError, ErrorMessages.DEQUE_REMOVE_X_NOT_IN_DEQUE);
        }
    }

    @Builtin(name="popleft", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequePopLeftNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGeneric(PDeque self, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            Object value = self.popLeft();
            if (value == null) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.POP_FROM_EMPTY_DEQUE);
            }
            return value;
        }
    }

    @Builtin(name="pop", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequePopNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGeneric(PDeque self, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            Object value = self.pop();
            if (value == null) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.POP_FROM_EMPTY_DEQUE);
            }
            return value;
        }
    }

    @Builtin(name="insert", minNumOfPositionalArgs=3, parameterNames={"$self", "index", "object"})
    @GenerateNodeFactory
    @ArgumentClinic(name="index", conversion=ArgumentClinic.ClinicConversion.Index)
    public static abstract class DequeInsertNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DequeBuiltinsClinicProviders.DequeInsertNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PNone doGeneric(PDeque self, int index, Object value) {
            int n = self.getSize();
            if (self.getMaxLength() == n) {
                throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.IndexError, ErrorMessages.DEQUE_AT_MAX_SIZE);
            }
            if (index >= n) {
                self.append(value);
            } else if (index <= -n || index == 0) {
                self.appendLeft(value);
            } else {
                DequeRotateNode.rotate(self, -index);
                if (index < 0) {
                    self.append(value);
                } else {
                    self.appendLeft(value);
                }
                DequeRotateNode.rotate(self, index);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="index", minNumOfPositionalArgs=2, parameterNames={"$self", "v", "start", "stop"})
    @GenerateNodeFactory
    public static abstract class DequeIndexNode
    extends PythonQuaternaryBuiltinNode {
        @Specialization(guards={"isNoValue(start)", "isNoValue(stop)"})
        static int doWithoutSlice(VirtualFrame frame, PDeque self, Object value, PNone start, PNone stop, @Bind Node inliningTarget, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool eqNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return DequeIndexNode.doWithIntSlice(frame, self, value, 0, self.getSize(), inliningTarget, eqNode, raiseNode);
        }

        @Specialization
        static int doWithIntSlice(VirtualFrame frame, PDeque self, Object value, int start, int stop, @Bind Node inliningTarget, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool eqNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            int size = self.getSize();
            int normStart = DequeIndexNode.normalize(start, size);
            int normStop = DequeIndexNode.normalize(stop, size);
            int startState = self.getState();
            if (normStop > size) {
                normStop = size;
            }
            if (normStart > normStop) {
                normStart = normStop;
            }
            Iterator<Object> iterator = self.iterator();
            for (int idx = 0; idx < normStop; ++idx) {
                Object item = DequeIndexNode.next(iterator);
                if (normStart > idx) continue;
                if (eqNode.execute((Frame)frame, inliningTarget, item, value, RichCmpOp.Py_EQ)) {
                    return idx;
                }
                if (startState == self.getState()) continue;
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.DEQUE_MUTATED_DURING_ITERATION);
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.S_IS_NOT_DEQUE, value);
        }

        @Specialization
        static int doGeneric(VirtualFrame frame, PDeque self, Object value, Object start, Object stop, @Bind Node inliningTarget, @Cached.Exclusive @Cached PyObjectRichCompareBool eqNode, @Cached CastToJavaIntExactNode castToIntNode, @Cached PyNumberAsSizeNode startIndexNode, @Cached PyNumberAsSizeNode stopIndexNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            int istart = start != PNone.NO_VALUE ? castToIntNode.execute(inliningTarget, startIndexNode.executeLossy((Frame)frame, inliningTarget, start)) : 0;
            int istop = stop != PNone.NO_VALUE ? castToIntNode.execute(inliningTarget, stopIndexNode.executeLossy((Frame)frame, inliningTarget, stop)) : self.getSize();
            return DequeIndexNode.doWithIntSlice(frame, self, value, istart, istop, inliningTarget, eqNode, raiseNode);
        }

        private static int normalize(int i, int size) {
            int res = i;
            if (res < 0) {
                res += size;
            }
            return Math.max(res, 0);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object next(Iterator<?> it) {
            return it.next();
        }
    }

    @Builtin(name="extendleft", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeExtendLeftNode
    extends DequeExtendNode {
        @Override
        void appendOperation(PDeque self, Object item) {
            self.appendLeft(item);
        }
    }

    @Builtin(name="extend", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeExtendNode
    extends PythonBinaryBuiltinNode {
        void appendOperation(PDeque self, Object item) {
            self.append(item);
        }

        @Specialization(guards={"self == other"})
        @CompilerDirectives.TruffleBoundary
        PNone doSelf(PDeque self, PDeque other) {
            Object[] items;
            for (Object item : items = self.data.toArray()) {
                this.appendOperation(self, item);
            }
            return PNone.NONE;
        }

        @Specialization
        PNone doGeneric(VirtualFrame frame, PDeque self, Object other, @Bind Node inliningTarget, @Cached InlinedConditionProfile selfIsOtherProfile, @Cached InlinedConditionProfile maxLenZeroProfile, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode nextNode) {
            if (selfIsOtherProfile.profile(inliningTarget, self == other)) {
                return this.doSelf(self, self);
            }
            Object it = getIter.execute((Frame)frame, inliningTarget, other);
            if (maxLenZeroProfile.profile(inliningTarget, self.getMaxLength() == 0)) {
                DequeExtendNode.consumeIterator(frame, it, nextNode, inliningTarget);
                return PNone.NONE;
            }
            try {
                while (true) {
                    Object next = nextNode.execute((Frame)frame, inliningTarget, it);
                    this.appendOperation(self, next);
                }
            }
            catch (IteratorExhausted e) {
                DequeExtendNode.consumeIterator(frame, it, nextNode, inliningTarget);
                return PNone.NONE;
            }
        }

        private static void consumeIterator(VirtualFrame frame, Object it, PyIterNextNode getNextNode, Node inliningTarget) {
            try {
                while (true) {
                    getNextNode.execute((Frame)frame, inliningTarget, it);
                }
            }
            catch (IteratorExhausted e) {
                return;
            }
        }
    }

    @Builtin(name="count", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeCountNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        int doGeneric(PDeque self, Object value) {
            int n = 0;
            int startState = self.getState();
            for (Object item : self.data) {
                if (PyObjectRichCompareBool.executeUncached(item, value, RichCmpOp.Py_EQ)) {
                    ++n;
                }
                if (startState == self.getState()) continue;
                throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.RuntimeError, ErrorMessages.DEQUE_MUTATED_DURING_ITERATION);
            }
            return n;
        }
    }

    @Builtins(value={@Builtin(name="__copy__", minNumOfPositionalArgs=1), @Builtin(name="copy", minNumOfPositionalArgs=1)})
    @GenerateNodeFactory
    public static abstract class DequeCopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDeque doGeneric(PDeque self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached GetClassNode getClassNode, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            Object cls = getClassNode.execute(inliningTarget, self);
            PDeque copy = PFactory.createDeque(language, cls, getInstanceShape.execute(cls));
            copy.setMaxLength(self.getMaxLength());
            copy.addAll(self);
            return copy;
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeClearNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PNone doGeneric(PDeque self) {
            self.clear();
            return PNone.NONE;
        }
    }

    @Builtin(name="appendleft", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeAppendLeftNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static PNone doGeneric(PDeque self, Object arg) {
            self.appendLeft(arg);
            return PNone.NONE;
        }
    }

    @Builtin(name="append", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeAppendNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static PNone doGeneric(PDeque self, Object arg) {
            self.append(arg);
            return PNone.NONE;
        }
    }

    @Builtin(name="maxlen", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class DequeMaxLengthNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.getMaxLength() < 0"})
        static PNone doNone(PDeque self) {
            return PNone.NONE;
        }

        @Specialization(guards={"self.getMaxLength() >= 0"})
        static int doInt(PDeque self) {
            return self.getMaxLength();
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="deque", minNumOfPositionalArgs=1, parameterNames={"$self", "iterable", "maxlen"})
    @GenerateNodeFactory
    public static abstract class DequeInitNode
    extends PythonTernaryBuiltinNode {
        @Specialization(guards={"isNoValue(iterable)"})
        static PNone doNothing(PDeque self, PNone iterable, PNone maxlen) {
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(iterable)"})
        static PNone doIterable(VirtualFrame frame, PDeque self, Object iterable, PNone maxlen, @Bind Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile sizeZeroProfile, @Cached.Exclusive @Cached PyObjectGetIter getIter, @Cached.Exclusive @Cached PyIterNextNode nextNode) {
            if (sizeZeroProfile.profile(inliningTarget, self.getSize() != 0)) {
                self.clear();
            }
            Object iterator = getIter.execute((Frame)frame, inliningTarget, iterable);
            try {
                while (true) {
                    Object next = nextNode.execute((Frame)frame, inliningTarget, iterator);
                    self.append(next);
                }
            }
            catch (IteratorExhausted e) {
                return PNone.NONE;
            }
        }

        @Specialization(replaces={"doNothing", "doIterable"})
        static PNone doGeneric(VirtualFrame frame, PDeque self, Object iterable, Object maxlenObj, @Bind Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile sizeZeroProfile, @Cached CastToJavaIntExactNode castToIntNode, @Cached.Exclusive @Cached PyObjectGetIter getIter, @Cached.Exclusive @Cached PyIterNextNode nextNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isTypeErrorProfile, @Cached PRaiseNode raiseNode) {
            if (!PGuards.isPNone(maxlenObj)) {
                try {
                    int maxlen = castToIntNode.execute(inliningTarget, maxlenObj);
                    if (maxlen < 0) {
                        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.MAXLEN_MUST_BE_NONNEG);
                    }
                    self.setMaxLength(maxlen);
                }
                catch (PException e) {
                    e.expect(inliningTarget, PythonBuiltinClassType.TypeError, isTypeErrorProfile);
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO, "int");
                }
                catch (CannotCastException e) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
                }
            }
            if (iterable != PNone.NO_VALUE) {
                DequeInitNode.doIterable(frame, self, iterable, PNone.NO_VALUE, inliningTarget, sizeZeroProfile, getIter, nextNode);
            }
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="deque", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class DequeNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        PDeque doGeneric(Object cls, Object[] args, PKeyword[] kwargs, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createDeque(language, cls, getInstanceShape.execute(cls));
        }
    }
}

