/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.generator;

import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodesFactory;
import com.oracle.graal.python.builtins.objects.exception.PrepareExceptionNode;
import com.oracle.graal.python.builtins.objects.exception.PrepareExceptionNodeGen;
import com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.call.CallDispatchersFactory;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.BuiltinClassProfilesFactory;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;

@GeneratedBy(value=CommonGeneratorBuiltins.class)
public final class CommonGeneratorBuiltinsFactory {
    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(SendNodeFactory.getInstance(), ThrowNodeFactory.getInstance(), CloseNodeFactory.getInstance());
    }

    @GeneratedBy(value=CommonGeneratorBuiltins.SendNode.class)
    public static final class SendNodeFactory
    implements NodeFactory<CommonGeneratorBuiltins.SendNode> {
        private static final SendNodeFactory SEND_NODE_FACTORY_INSTANCE = new SendNodeFactory();

        private SendNodeFactory() {
        }

        public Class<CommonGeneratorBuiltins.SendNode> getNodeClass() {
            return CommonGeneratorBuiltins.SendNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public CommonGeneratorBuiltins.SendNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return SendNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CommonGeneratorBuiltins.SendNode> getInstance() {
            return SEND_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static CommonGeneratorBuiltins.SendNode create() {
            return new SendNodeGen();
        }

        @GeneratedBy(value=CommonGeneratorBuiltins.SendNode.class)
        public static final class SendNodeGen
        extends CommonGeneratorBuiltins.SendNode {
            private static final InlineSupport.StateField STATE_0_SendNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final CommonGeneratorBuiltins.ResumeGeneratorNode INLINED_RESUME_GENERATOR_NODE_ = ResumeGeneratorNodeGen.inline(InlineSupport.InlineTarget.create(CommonGeneratorBuiltins.ResumeGeneratorNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_SendNode_UPDATER.subUpdater(1, 4), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"resumeGeneratorNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"resumeGeneratorNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"resumeGeneratorNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"resumeGeneratorNode__field4_", Node.class)}));
            private static final PRaiseNode INLINED_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_SendNode_UPDATER.subUpdater(5, 1)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node resumeGeneratorNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node resumeGeneratorNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node resumeGeneratorNode__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node resumeGeneratorNode__field4_;

            private SendNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && arg0Value instanceof PGenerator) {
                    PGenerator arg0Value_ = (PGenerator)arg0Value;
                    SendNodeGen inliningTarget__ = this;
                    return CommonGeneratorBuiltins.SendNode.send(frameValue, arg0Value_, arg1Value, inliningTarget__, INLINED_RESUME_GENERATOR_NODE_, INLINED_RAISE_NODE_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                SendNodeGen inliningTarget__ = null;
                if (arg0Value instanceof PGenerator) {
                    PGenerator arg0Value_ = (PGenerator)arg0Value;
                    inliningTarget__ = this;
                    this.state_0_ = state_0 |= 1;
                    return CommonGeneratorBuiltins.SendNode.send(frameValue, arg0Value_, arg1Value, inliningTarget__, INLINED_RESUME_GENERATOR_NODE_, INLINED_RAISE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value});
            }
        }
    }

    @GeneratedBy(value=CommonGeneratorBuiltins.ThrowNode.class)
    public static final class ThrowNodeFactory
    implements NodeFactory<CommonGeneratorBuiltins.ThrowNode> {
        private static final ThrowNodeFactory THROW_NODE_FACTORY_INSTANCE = new ThrowNodeFactory();

        private ThrowNodeFactory() {
        }

        public Class<CommonGeneratorBuiltins.ThrowNode> getNodeClass() {
            return CommonGeneratorBuiltins.ThrowNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public CommonGeneratorBuiltins.ThrowNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ThrowNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CommonGeneratorBuiltins.ThrowNode> getInstance() {
            return THROW_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static CommonGeneratorBuiltins.ThrowNode create() {
            return new ThrowNodeGen();
        }

        @GeneratedBy(value=CommonGeneratorBuiltins.ThrowNode.class)
        public static final class ThrowNodeGen
        extends CommonGeneratorBuiltins.ThrowNode {
            private static final InlineSupport.StateField STATE_0_ThrowNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedConditionProfile INLINED_HAS_TB_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ThrowNode_UPDATER.subUpdater(1, 2)}));
            private static final InlinedConditionProfile INLINED_HAS_VAL_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ThrowNode_UPDATER.subUpdater(3, 2)}));
            private static final InlinedConditionProfile INLINED_STARTED_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ThrowNode_UPDATER.subUpdater(5, 2)}));
            private static final InlinedBranchProfile INLINED_INVALID_TB_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ThrowNode_UPDATER.subUpdater(7, 1)}));
            private static final InlinedBranchProfile INLINED_RUNNING_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ThrowNode_UPDATER.subUpdater(8, 1)}));
            private static final CommonGeneratorBuiltins.ResumeGeneratorNode INLINED_RESUME_GENERATOR_NODE_ = ResumeGeneratorNodeGen.inline(InlineSupport.InlineTarget.create(CommonGeneratorBuiltins.ResumeGeneratorNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ThrowNode_UPDATER.subUpdater(9, 4), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"resumeGeneratorNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"resumeGeneratorNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"resumeGeneratorNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"resumeGeneratorNode__field4_", Node.class)}));
            private static final ExceptionNodes.GetTracebackNode INLINED_GET_TRACEBACK_NODE_ = ExceptionNodesFactory.GetTracebackNodeGen.inline(InlineSupport.InlineTarget.create(ExceptionNodes.GetTracebackNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ThrowNode_UPDATER.subUpdater(13, 5), InlineSupport.LongField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getTracebackNode__field1_"), InlineSupport.IntField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getTracebackNode__field2_"), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getTracebackNode__field3_", Node.class)}));
            private static final ExceptionNodes.SetTracebackNode INLINED_SET_TRACEBACK_NODE_ = ExceptionNodesFactory.SetTracebackNodeGen.inline(InlineSupport.InlineTarget.create(ExceptionNodes.SetTracebackNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ThrowNode_UPDATER.subUpdater(18, 4), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"setTracebackNode__field1_", Node.class)}));
            private static final ExceptionNodes.SetContextNode INLINED_SET_CONTEXT_NODE_ = ExceptionNodesFactory.SetContextNodeGen.inline(InlineSupport.InlineTarget.create(ExceptionNodes.SetContextNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ThrowNode_UPDATER.subUpdater(22, 4), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"setContextNode__field1_", Node.class)}));
            private static final PRaiseNode INLINED_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ThrowNode_UPDATER.subUpdater(26, 1)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private PrepareExceptionNode prepareExceptionNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node resumeGeneratorNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node resumeGeneratorNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node resumeGeneratorNode__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node resumeGeneratorNode__field4_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private long getTracebackNode__field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int getTracebackNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getTracebackNode__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node setTracebackNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node setContextNode__field1_;
            @Node.Child
            private WarningsModuleBuiltins.WarnNode warnNode_;

            private ThrowNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && arg0Value instanceof PGenerator) {
                    WarningsModuleBuiltins.WarnNode warnNode__;
                    PGenerator arg0Value_ = (PGenerator)arg0Value;
                    PrepareExceptionNode prepareExceptionNode__ = this.prepareExceptionNode_;
                    if (prepareExceptionNode__ != null && (warnNode__ = this.warnNode_) != null) {
                        ThrowNodeGen inliningTarget__ = this;
                        return CommonGeneratorBuiltins.ThrowNode.sendThrow(frameValue, arg0Value_, arg1Value, arg2Value, arg3Value, inliningTarget__, INLINED_HAS_TB_PROFILE_, INLINED_HAS_VAL_PROFILE_, INLINED_STARTED_PROFILE_, INLINED_INVALID_TB_PROFILE_, INLINED_RUNNING_PROFILE_, prepareExceptionNode__, INLINED_RESUME_GENERATOR_NODE_, INLINED_GET_TRACEBACK_NODE_, INLINED_SET_TRACEBACK_NODE_, INLINED_SET_CONTEXT_NODE_, warnNode__, INLINED_RAISE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value) {
                int state_0 = this.state_0_;
                ThrowNodeGen inliningTarget__ = null;
                if (arg0Value instanceof PGenerator) {
                    PGenerator arg0Value_ = (PGenerator)arg0Value;
                    inliningTarget__ = this;
                    PrepareExceptionNode prepareExceptionNode__ = (PrepareExceptionNode)this.insert(PrepareExceptionNodeGen.create());
                    Objects.requireNonNull(prepareExceptionNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.prepareExceptionNode_ = prepareExceptionNode__;
                    WarningsModuleBuiltins.WarnNode warnNode__ = (WarningsModuleBuiltins.WarnNode)this.insert(WarningsModuleBuiltins.WarnNode.create());
                    Objects.requireNonNull(warnNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.warnNode_ = warnNode__;
                    this.state_0_ = state_0 |= 1;
                    return CommonGeneratorBuiltins.ThrowNode.sendThrow(frameValue, arg0Value_, arg1Value, arg2Value, arg3Value, inliningTarget__, INLINED_HAS_TB_PROFILE_, INLINED_HAS_VAL_PROFILE_, INLINED_STARTED_PROFILE_, INLINED_INVALID_TB_PROFILE_, INLINED_RUNNING_PROFILE_, prepareExceptionNode__, INLINED_RESUME_GENERATOR_NODE_, INLINED_GET_TRACEBACK_NODE_, INLINED_SET_TRACEBACK_NODE_, INLINED_SET_CONTEXT_NODE_, warnNode__, INLINED_RAISE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
            }
        }
    }

    @GeneratedBy(value=CommonGeneratorBuiltins.CloseNode.class)
    public static final class CloseNodeFactory
    implements NodeFactory<CommonGeneratorBuiltins.CloseNode> {
        private static final CloseNodeFactory CLOSE_NODE_FACTORY_INSTANCE = new CloseNodeFactory();

        private CloseNodeFactory() {
        }

        public Class<CommonGeneratorBuiltins.CloseNode> getNodeClass() {
            return CommonGeneratorBuiltins.CloseNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public CommonGeneratorBuiltins.CloseNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return CloseNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CommonGeneratorBuiltins.CloseNode> getInstance() {
            return CLOSE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static CommonGeneratorBuiltins.CloseNode create() {
            return new CloseNodeGen();
        }

        @GeneratedBy(value=CommonGeneratorBuiltins.CloseNode.class)
        public static final class CloseNodeGen
        extends CommonGeneratorBuiltins.CloseNode {
            private static final InlineSupport.StateField STATE_0_CloseNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final BuiltinClassProfiles.IsBuiltinObjectProfile INLINED_IS_GENERATOR_EXIT_ = BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.inline(InlineSupport.InlineTarget.create(BuiltinClassProfiles.IsBuiltinObjectProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CloseNode_UPDATER.subUpdater(1, 21), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"isGeneratorExit__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"isGeneratorExit__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"isGeneratorExit__field3_", Node.class)}));
            private static final InlineSupport.StateField STATE_1_CloseNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_1_");
            private static final BuiltinClassProfiles.IsBuiltinObjectProfile INLINED_IS_STOP_ITERATION_ = BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.inline(InlineSupport.InlineTarget.create(BuiltinClassProfiles.IsBuiltinObjectProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_CloseNode_UPDATER.subUpdater(0, 21), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"isStopIteration__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"isStopIteration__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"isStopIteration__field3_", Node.class)}));
            private static final CommonGeneratorBuiltins.ResumeGeneratorNode INLINED_RESUME_GENERATOR_NODE_ = ResumeGeneratorNodeGen.inline(InlineSupport.InlineTarget.create(CommonGeneratorBuiltins.ResumeGeneratorNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CloseNode_UPDATER.subUpdater(22, 4), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"resumeGeneratorNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"resumeGeneratorNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"resumeGeneratorNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"resumeGeneratorNode__field4_", Node.class)}));
            private static final InlinedConditionProfile INLINED_IS_STARTED_PORFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CloseNode_UPDATER.subUpdater(26, 2)}));
            private static final PRaiseNode INLINED_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CloseNode_UPDATER.subUpdater(28, 1)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node isGeneratorExit__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node isGeneratorExit__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node isGeneratorExit__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node isStopIteration__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node isStopIteration__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node isStopIteration__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node resumeGeneratorNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node resumeGeneratorNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node resumeGeneratorNode__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node resumeGeneratorNode__field4_;

            private CloseNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && arg0Value instanceof PGenerator) {
                    PGenerator arg0Value_ = (PGenerator)arg0Value;
                    CloseNodeGen inliningTarget__ = this;
                    return CommonGeneratorBuiltins.CloseNode.close(frameValue, arg0Value_, inliningTarget__, INLINED_IS_GENERATOR_EXIT_, INLINED_IS_STOP_ITERATION_, INLINED_RESUME_GENERATOR_NODE_, INLINED_IS_STARTED_PORFILE_, INLINED_RAISE_NODE_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                CloseNodeGen inliningTarget__ = null;
                if (arg0Value instanceof PGenerator) {
                    PGenerator arg0Value_ = (PGenerator)arg0Value;
                    inliningTarget__ = this;
                    this.state_0_ = state_0 |= 1;
                    return CommonGeneratorBuiltins.CloseNode.close(frameValue, arg0Value_, inliningTarget__, INLINED_IS_GENERATOR_EXIT_, INLINED_IS_STOP_ITERATION_, INLINED_RESUME_GENERATOR_NODE_, INLINED_IS_STARTED_PORFILE_, INLINED_RAISE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=CommonGeneratorBuiltins.ResumeGeneratorNode.class)
    static final class ResumeGeneratorNodeGen {
        private static final InlineSupport.StateField CACHED_RESUME_GENERATOR_NODE_CACHED_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"cached_state_0_");
        private static final CallDispatchers.SimpleDirectInvokeNode INLINED_CACHED_INVOKE_ = CallDispatchersFactory.SimpleDirectInvokeNodeGen.inline(InlineSupport.InlineTarget.create(CallDispatchers.SimpleDirectInvokeNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CACHED_RESUME_GENERATOR_NODE_CACHED_STATE_0_UPDATER.subUpdater(0, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"cached_invoke__field1_", Node.class)}));
        private static final InlinedBranchProfile INLINED_CACHED_RETURN_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CACHED_RESUME_GENERATOR_NODE_CACHED_STATE_0_UPDATER.subUpdater(3, 1)}));
        private static final BuiltinClassProfiles.IsBuiltinObjectProfile INLINED_CACHED_ERROR_PROFILE_ = BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.inline(InlineSupport.InlineTarget.create(BuiltinClassProfiles.IsBuiltinObjectProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CACHED_RESUME_GENERATOR_NODE_CACHED_STATE_0_UPDATER.subUpdater(4, 21), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"cached_errorProfile__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"cached_errorProfile__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"cached_errorProfile__field3_", Node.class)}));
        private static final PRaiseNode INLINED_CACHED_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CACHED_RESUME_GENERATOR_NODE_CACHED_STATE_0_UPDATER.subUpdater(25, 1)}));
        private static final InlineSupport.StateField CACHED_BYTECODE_DS_L_RESUME_GENERATOR_NODE_CACHED_BYTECODE_DS_L_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)CachedBytecodeDSLData.lookup_(), (String)"cachedBytecodeDSL_state_0_");
        private static final CallDispatchers.SimpleDirectInvokeNode INLINED_CACHED_BYTECODE_DS_L_INVOKE_ = CallDispatchersFactory.SimpleDirectInvokeNodeGen.inline(InlineSupport.InlineTarget.create(CallDispatchers.SimpleDirectInvokeNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CACHED_BYTECODE_DS_L_RESUME_GENERATOR_NODE_CACHED_BYTECODE_DS_L_STATE_0_UPDATER.subUpdater(0, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedBytecodeDSLData.lookup_(), (String)"cachedBytecodeDSL_invoke__field1_", Node.class)}));
        private static final InlinedBranchProfile INLINED_CACHED_BYTECODE_DS_L_RETURN_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CACHED_BYTECODE_DS_L_RESUME_GENERATOR_NODE_CACHED_BYTECODE_DS_L_STATE_0_UPDATER.subUpdater(3, 1)}));
        private static final BuiltinClassProfiles.IsBuiltinObjectProfile INLINED_CACHED_BYTECODE_DS_L_ERROR_PROFILE_ = BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.inline(InlineSupport.InlineTarget.create(BuiltinClassProfiles.IsBuiltinObjectProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CACHED_BYTECODE_DS_L_RESUME_GENERATOR_NODE_CACHED_BYTECODE_DS_L_STATE_0_UPDATER.subUpdater(4, 21), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedBytecodeDSLData.lookup_(), (String)"cachedBytecodeDSL_errorProfile__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedBytecodeDSLData.lookup_(), (String)"cachedBytecodeDSL_errorProfile__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedBytecodeDSLData.lookup_(), (String)"cachedBytecodeDSL_errorProfile__field3_", Node.class)}));
        private static final PRaiseNode INLINED_CACHED_BYTECODE_DS_L_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CACHED_BYTECODE_DS_L_RESUME_GENERATOR_NODE_CACHED_BYTECODE_DS_L_STATE_0_UPDATER.subUpdater(25, 1)}));
        private static final InlineSupport.StateField GENERIC_RESUME_GENERATOR_NODE_GENERIC_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GenericData.lookup_(), (String)"generic_state_0_");
        private static final CallDispatchers.SimpleIndirectInvokeNode INLINED_GENERIC_INVOKE_ = CallDispatchersFactory.SimpleIndirectInvokeNodeGen.inline(InlineSupport.InlineTarget.create(CallDispatchers.SimpleIndirectInvokeNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERIC_RESUME_GENERATOR_NODE_GENERIC_STATE_0_UPDATER.subUpdater(0, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GenericData.lookup_(), (String)"generic_invoke__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GenericData.lookup_(), (String)"generic_invoke__field2_", Node.class)}));
        private static final InlinedBranchProfile INLINED_GENERIC_RETURN_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERIC_RESUME_GENERATOR_NODE_GENERIC_STATE_0_UPDATER.subUpdater(3, 1)}));
        private static final BuiltinClassProfiles.IsBuiltinObjectProfile INLINED_GENERIC_ERROR_PROFILE_ = BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.inline(InlineSupport.InlineTarget.create(BuiltinClassProfiles.IsBuiltinObjectProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERIC_RESUME_GENERATOR_NODE_GENERIC_STATE_0_UPDATER.subUpdater(4, 21), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GenericData.lookup_(), (String)"generic_errorProfile__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GenericData.lookup_(), (String)"generic_errorProfile__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GenericData.lookup_(), (String)"generic_errorProfile__field3_", Node.class)}));
        private static final PRaiseNode INLINED_GENERIC_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERIC_RESUME_GENERATOR_NODE_GENERIC_STATE_0_UPDATER.subUpdater(25, 1)}));
        private static final InlineSupport.StateField GENERIC_BYTECODE_DS_L_RESUME_GENERATOR_NODE_GENERIC_BYTECODE_DS_L_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GenericBytecodeDSLData.lookup_(), (String)"genericBytecodeDSL_state_0_");
        private static final CallDispatchers.SimpleIndirectInvokeNode INLINED_GENERIC_BYTECODE_DS_L_INVOKE_ = CallDispatchersFactory.SimpleIndirectInvokeNodeGen.inline(InlineSupport.InlineTarget.create(CallDispatchers.SimpleIndirectInvokeNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERIC_BYTECODE_DS_L_RESUME_GENERATOR_NODE_GENERIC_BYTECODE_DS_L_STATE_0_UPDATER.subUpdater(0, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GenericBytecodeDSLData.lookup_(), (String)"genericBytecodeDSL_invoke__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GenericBytecodeDSLData.lookup_(), (String)"genericBytecodeDSL_invoke__field2_", Node.class)}));
        private static final InlinedConditionProfile INLINED_GENERIC_BYTECODE_DS_L_FIRST_INVOCATION_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERIC_BYTECODE_DS_L_RESUME_GENERATOR_NODE_GENERIC_BYTECODE_DS_L_STATE_0_UPDATER.subUpdater(3, 2)}));
        private static final InlinedBranchProfile INLINED_GENERIC_BYTECODE_DS_L_RETURN_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERIC_BYTECODE_DS_L_RESUME_GENERATOR_NODE_GENERIC_BYTECODE_DS_L_STATE_0_UPDATER.subUpdater(5, 1)}));
        private static final BuiltinClassProfiles.IsBuiltinObjectProfile INLINED_GENERIC_BYTECODE_DS_L_ERROR_PROFILE_ = BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.inline(InlineSupport.InlineTarget.create(BuiltinClassProfiles.IsBuiltinObjectProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERIC_BYTECODE_DS_L_RESUME_GENERATOR_NODE_GENERIC_BYTECODE_DS_L_STATE_0_UPDATER.subUpdater(6, 21), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GenericBytecodeDSLData.lookup_(), (String)"genericBytecodeDSL_errorProfile__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GenericBytecodeDSLData.lookup_(), (String)"genericBytecodeDSL_errorProfile__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GenericBytecodeDSLData.lookup_(), (String)"genericBytecodeDSL_errorProfile__field3_", Node.class)}));
        private static final PRaiseNode INLINED_GENERIC_BYTECODE_DS_L_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERIC_BYTECODE_DS_L_RESUME_GENERATOR_NODE_GENERIC_BYTECODE_DS_L_STATE_0_UPDATER.subUpdater(27, 1)}));

        ResumeGeneratorNodeGen() {
        }

        @NeverDefault
        public static CommonGeneratorBuiltins.ResumeGeneratorNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=4, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=CommonGeneratorBuiltins.ResumeGeneratorNode.class)
        @DenyReplace
        private static final class Inlined
        extends CommonGeneratorBuiltins.ResumeGeneratorNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<CachedData> cached_cache;
            private final InlineSupport.ReferenceField<CachedBytecodeDSLData> cachedBytecodeDSL_cache;
            private final InlineSupport.ReferenceField<GenericData> generic_cache;
            private final InlineSupport.ReferenceField<GenericBytecodeDSLData> genericBytecodeDSL_cache;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(CommonGeneratorBuiltins.ResumeGeneratorNode.class));
                this.state_0_ = target.getState(0, 4);
                this.cached_cache = target.getReference(1, CachedData.class);
                this.cachedBytecodeDSL_cache = target.getReference(2, CachedBytecodeDSLData.class);
                this.generic_cache = target.getReference(3, GenericData.class);
                this.genericBytecodeDSL_cache = target.getReference(4, GenericBytecodeDSLData.class);
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue, Node arg0Value, PGenerator arg1Value, Object arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    GenericBytecodeDSLData s3_;
                    GenericData s2_;
                    if ((state_0 & 1) != 0) {
                        assert (DSLSupport.assertIdempotence((!PGuards.isBytecodeDSLInterpreter() ? 1 : 0) != 0));
                        CachedData s0_ = (CachedData)((Object)this.cached_cache.get(arg0Value));
                        while (s0_ != null) {
                            if (CallDispatchers.sameCallTarget(arg1Value.getCurrentCallTarget(), s0_.callNode_)) {
                                return CommonGeneratorBuiltins.ResumeGeneratorNode.cached(frameValue, s0_, arg1Value, arg2Value, s0_.callNode_, INLINED_CACHED_INVOKE_, INLINED_CACHED_RETURN_PROFILE_, INLINED_CACHED_ERROR_PROFILE_, INLINED_CACHED_RAISE_NODE_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0) {
                        assert (DSLSupport.assertIdempotence((boolean)PGuards.isBytecodeDSLInterpreter()));
                        CachedBytecodeDSLData s1_ = (CachedBytecodeDSLData)((Object)this.cachedBytecodeDSL_cache.get(arg0Value));
                        while (s1_ != null) {
                            if (CallDispatchers.sameCallTarget(arg1Value.getCurrentCallTarget(), s1_.callNode_)) {
                                return CommonGeneratorBuiltins.ResumeGeneratorNode.cachedBytecodeDSL(frameValue, s1_, arg1Value, arg2Value, s1_.callNode_, INLINED_CACHED_BYTECODE_DS_L_INVOKE_, s1_.firstCall_, INLINED_CACHED_BYTECODE_DS_L_RETURN_PROFILE_, INLINED_CACHED_BYTECODE_DS_L_ERROR_PROFILE_, INLINED_CACHED_BYTECODE_DS_L_RAISE_NODE_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0 && (s2_ = (GenericData)((Object)this.generic_cache.get(arg0Value))) != null) {
                        assert (DSLSupport.assertIdempotence((!PGuards.isBytecodeDSLInterpreter() ? 1 : 0) != 0));
                        return CommonGeneratorBuiltins.ResumeGeneratorNode.generic(frameValue, s2_, arg1Value, arg2Value, INLINED_GENERIC_INVOKE_, INLINED_GENERIC_RETURN_PROFILE_, INLINED_GENERIC_ERROR_PROFILE_, INLINED_GENERIC_RAISE_NODE_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = (GenericBytecodeDSLData)((Object)this.genericBytecodeDSL_cache.get(arg0Value))) != null) {
                        assert (DSLSupport.assertIdempotence((boolean)PGuards.isBytecodeDSLInterpreter()));
                        return CommonGeneratorBuiltins.ResumeGeneratorNode.genericBytecodeDSL(frameValue, s3_, arg1Value, arg2Value, INLINED_GENERIC_BYTECODE_DS_L_INVOKE_, INLINED_GENERIC_BYTECODE_DS_L_FIRST_INVOCATION_PROFILE_, INLINED_GENERIC_BYTECODE_DS_L_RETURN_PROFILE_, INLINED_GENERIC_BYTECODE_DS_L_ERROR_PROFILE_, INLINED_GENERIC_BYTECODE_DS_L_RAISE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Node arg0Value, PGenerator arg1Value, Object arg2Value) {
                int state_0;
                int oldState_0 = state_0 = this.state_0_.get(arg0Value);
                try {
                    Object object;
                    if ((state_0 & 2) == 0 && !PGuards.isBytecodeDSLInterpreter()) {
                        Object callNode__;
                        CachedData s0_;
                        block18: {
                            CachedData s0_original;
                            do {
                                int count0_ = 0;
                                s0_original = s0_ = (CachedData)((Object)this.cached_cache.getVolatile(arg0Value));
                                while (s0_ != null && !CallDispatchers.sameCallTarget(arg1Value.getCurrentCallTarget(), s0_.callNode_)) {
                                    ++count0_;
                                    s0_ = s0_.next_;
                                }
                                if (s0_ != null) break block18;
                                callNode__ = (DirectCallNode)arg0Value.insert((Node)DirectCallNode.create((CallTarget)arg1Value.getCurrentCallTarget()));
                                if (!CallDispatchers.sameCallTarget(arg1Value.getCurrentCallTarget(), callNode__) || count0_ >= PythonOptions.getCallSiteInlineCacheMaxDepth()) break block18;
                                s0_ = (CachedData)arg0Value.insert((Node)new CachedData(s0_original));
                                s0_.callNode_ = (DirectCallNode)s0_.insert((Node)callNode__);
                            } while (!this.cached_cache.compareAndSet(arg0Value, (Object)s0_original, (Object)s0_));
                            this.state_0_.set(arg0Value, state_0 |= 1);
                        }
                        if (s0_ != null) {
                            callNode__ = CommonGeneratorBuiltins.ResumeGeneratorNode.cached(frameValue, s0_, arg1Value, arg2Value, s0_.callNode_, INLINED_CACHED_INVOKE_, INLINED_CACHED_RETURN_PROFILE_, INLINED_CACHED_ERROR_PROFILE_, INLINED_CACHED_RAISE_NODE_);
                            return callNode__;
                        }
                    }
                    if ((state_0 & 8) == 0 && PGuards.isBytecodeDSLInterpreter()) {
                        CachedBytecodeDSLData s1_;
                        block19: {
                            CachedBytecodeDSLData s1_original;
                            do {
                                int count1_ = 0;
                                s1_original = s1_ = (CachedBytecodeDSLData)((Object)this.cachedBytecodeDSL_cache.getVolatile(arg0Value));
                                while (s1_ != null && !CallDispatchers.sameCallTarget(arg1Value.getCurrentCallTarget(), s1_.callNode_)) {
                                    ++count1_;
                                    s1_ = s1_.next_;
                                }
                                if (s1_ != null) break block19;
                                DirectCallNode callNode__1 = (DirectCallNode)arg0Value.insert((Node)DirectCallNode.create((CallTarget)arg1Value.getCurrentCallTarget()));
                                if (!CallDispatchers.sameCallTarget(arg1Value.getCurrentCallTarget(), callNode__1) || count1_ >= PythonOptions.getCallSiteInlineCacheMaxDepth()) break block19;
                                s1_ = (CachedBytecodeDSLData)arg0Value.insert((Node)new CachedBytecodeDSLData(s1_original));
                                s1_.callNode_ = (DirectCallNode)s1_.insert((Node)callNode__1);
                                boolean bl = s1_.firstCall_ = arg1Value.getContinuation() == null;
                            } while (!this.cachedBytecodeDSL_cache.compareAndSet(arg0Value, (Object)s1_original, (Object)s1_));
                            this.state_0_.set(arg0Value, state_0 |= 4);
                        }
                        if (s1_ != null) {
                            Object object2 = CommonGeneratorBuiltins.ResumeGeneratorNode.cachedBytecodeDSL(frameValue, s1_, arg1Value, arg2Value, s1_.callNode_, INLINED_CACHED_BYTECODE_DS_L_INVOKE_, s1_.firstCall_, INLINED_CACHED_BYTECODE_DS_L_RETURN_PROFILE_, INLINED_CACHED_BYTECODE_DS_L_ERROR_PROFILE_, INLINED_CACHED_BYTECODE_DS_L_RAISE_NODE_);
                            return object2;
                        }
                    }
                    if (!PGuards.isBytecodeDSLInterpreter()) {
                        GenericData s2_ = (GenericData)arg0Value.insert((Node)new GenericData());
                        VarHandle.storeStoreFence();
                        this.generic_cache.set(arg0Value, (Object)s2_);
                        this.cached_cache.set(arg0Value, null);
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_.set(arg0Value, state_0 |= 2);
                        object = CommonGeneratorBuiltins.ResumeGeneratorNode.generic(frameValue, s2_, arg1Value, arg2Value, INLINED_GENERIC_INVOKE_, INLINED_GENERIC_RETURN_PROFILE_, INLINED_GENERIC_ERROR_PROFILE_, INLINED_GENERIC_RAISE_NODE_);
                        return object;
                    }
                    if (PGuards.isBytecodeDSLInterpreter()) {
                        GenericBytecodeDSLData s3_ = (GenericBytecodeDSLData)arg0Value.insert((Node)new GenericBytecodeDSLData());
                        VarHandle.storeStoreFence();
                        this.genericBytecodeDSL_cache.set(arg0Value, (Object)s3_);
                        this.cachedBytecodeDSL_cache.set(arg0Value, null);
                        state_0 &= 0xFFFFFFFB;
                        this.state_0_.set(arg0Value, state_0 |= 8);
                        object = CommonGeneratorBuiltins.ResumeGeneratorNode.genericBytecodeDSL(frameValue, s3_, arg1Value, arg2Value, INLINED_GENERIC_BYTECODE_DS_L_INVOKE_, INLINED_GENERIC_BYTECODE_DS_L_FIRST_INVOCATION_PROFILE_, INLINED_GENERIC_BYTECODE_DS_L_RETURN_PROFILE_, INLINED_GENERIC_BYTECODE_DS_L_ERROR_PROFILE_, INLINED_GENERIC_BYTECODE_DS_L_RAISE_NODE_);
                        return object;
                    }
                    throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value});
                }
                finally {
                    if (oldState_0 != 0) {
                        this.checkForPolymorphicSpecialize(arg0Value, oldState_0);
                    }
                }
            }

            private void checkForPolymorphicSpecialize(Node arg0Value, int oldState_0) {
                if ((oldState_0 & 0xA) == 0 && (this.state_0_.get(arg0Value) & 0xA) != 0) {
                    arg0Value.reportPolymorphicSpecialize();
                }
            }
        }

        @GeneratedBy(value=CommonGeneratorBuiltins.ResumeGeneratorNode.class)
        @DenyReplace
        private static final class CachedData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int cached_state_0_;
            @Node.Child
            DirectCallNode callNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node cached_invoke__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node cached_errorProfile__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node cached_errorProfile__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node cached_errorProfile__field3_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @GeneratedBy(value=CommonGeneratorBuiltins.ResumeGeneratorNode.class)
        @DenyReplace
        private static final class CachedBytecodeDSLData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            CachedBytecodeDSLData next_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int cachedBytecodeDSL_state_0_;
            @Node.Child
            DirectCallNode callNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node cachedBytecodeDSL_invoke__field1_;
            @CompilerDirectives.CompilationFinal
            boolean firstCall_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node cachedBytecodeDSL_errorProfile__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node cachedBytecodeDSL_errorProfile__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node cachedBytecodeDSL_errorProfile__field3_;

            CachedBytecodeDSLData(CachedBytecodeDSLData next_) {
                this.next_ = next_;
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @GeneratedBy(value=CommonGeneratorBuiltins.ResumeGeneratorNode.class)
        @DenyReplace
        private static final class GenericData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int generic_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node generic_invoke__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node generic_invoke__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node generic_errorProfile__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node generic_errorProfile__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node generic_errorProfile__field3_;

            GenericData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @GeneratedBy(value=CommonGeneratorBuiltins.ResumeGeneratorNode.class)
        @DenyReplace
        private static final class GenericBytecodeDSLData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int genericBytecodeDSL_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node genericBytecodeDSL_invoke__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node genericBytecodeDSL_invoke__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node genericBytecodeDSL_errorProfile__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node genericBytecodeDSL_errorProfile__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node genericBytecodeDSL_errorProfile__field3_;

            GenericBytecodeDSLData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }
}

