/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.native_memory;

import com.oracle.graal.python.util.PythonUtils;
import sun.misc.Unsafe;

public class NativeBuffer {
    private static final Unsafe unsafe = PythonUtils.initUnsafe();
    private long memoryAddress;
    private long capacityInBytes;

    private NativeBuffer(long memoryAddress, long capacityInBytes) {
        this.memoryAddress = memoryAddress;
        this.capacityInBytes = capacityInBytes;
    }

    public void reallocate(long newCapacityInBytes) {
        assert (newCapacityInBytes >= 0L);
        long newMemoryAddr = unsafe.allocateMemory(newCapacityInBytes);
        unsafe.copyMemory(this.memoryAddress, newMemoryAddr, newCapacityInBytes);
        unsafe.freeMemory(this.memoryAddress);
        this.memoryAddress = newMemoryAddr;
        this.capacityInBytes = newCapacityInBytes;
    }

    public NativeBuffer copy() {
        long newAddr = unsafe.allocateMemory(this.capacityInBytes);
        unsafe.copyMemory(this.memoryAddress, newAddr, this.capacityInBytes);
        return new NativeBuffer(newAddr, this.capacityInBytes);
    }

    public NativeBuffer copy(long newCapacityInBytes) {
        assert (newCapacityInBytes >= 0L);
        long newAddr = unsafe.allocateMemory(newCapacityInBytes);
        unsafe.copyMemory(this.memoryAddress, newAddr, this.capacityInBytes);
        return new NativeBuffer(newAddr, newCapacityInBytes);
    }

    public void release() {
        unsafe.freeMemory(this.memoryAddress);
    }

    public static NativeBuffer allocateNew(long capacityInBytes) {
        assert (capacityInBytes >= 0L);
        long adr = unsafe.allocateMemory(capacityInBytes);
        return new NativeBuffer(adr, capacityInBytes);
    }

    public long getMemoryAddress() {
        return this.memoryAddress;
    }

    public long getCapacityInBytes() {
        return this.capacityInBytes;
    }
}

