/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BufferHandle;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BufferedReadableByteChannelSession;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Buffers;
import net.snowflake.client.jdbc.internal.google.cloud.storage.UnbufferedReadableByteChannelSession;

final class DefaultBufferedReadableByteChannel
implements BufferedReadableByteChannelSession.BufferedReadableByteChannel {
    private final BufferHandle handle;
    private final UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel channel;
    private boolean flipped = false;
    private boolean retEOF = false;

    DefaultBufferedReadableByteChannel(BufferHandle handle, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel channel) {
        this.handle = handle;
        this.channel = channel;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.retEOF) {
            this.retEOF = false;
            return -1;
        }
        if (!this.enqueuedBytes() && !this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
        int bytesConsumed = 0;
        while (dst.hasRemaining()) {
            int tmpBytesCopied;
            ByteBuffer buffer;
            int bufferRemaining = this.handle.remaining();
            int dstRemaining = dst.remaining();
            int dstPosition = dst.position();
            if (this.enqueuedBytes()) {
                buffer = (ByteBuffer)this.handle.get();
                if (!this.flipped) {
                    buffer.flip();
                    this.flipped = true;
                }
                long copy = Buffers.copy(buffer, new ByteBuffer[]{dst});
                if (buffer.remaining() == 0) {
                    Buffers.clear(buffer);
                }
                tmpBytesCopied = Math.toIntExact(copy);
            } else if (bufferRemaining <= dstRemaining) {
                ByteBuffer buf;
                if (bufferRemaining == dstRemaining) {
                    buf = dst;
                } else {
                    buf = dst.slice();
                    Buffers.limit(buf, bufferRemaining);
                }
                int read = this.channel.read(buf);
                if (read == -1) {
                    if (bytesConsumed == 0) {
                        this.close();
                        return -1;
                    }
                    this.retEOF = true;
                    this.close();
                    break;
                }
                Buffers.position(dst, dstPosition + read);
                tmpBytesCopied = read;
            } else {
                buffer = (ByteBuffer)this.handle.get();
                ByteBuffer slice = buffer.slice();
                int sliceCapacity = buffer.capacity() - dstRemaining;
                Buffers.limit(slice, sliceCapacity);
                ByteBuffer[] dsts = new ByteBuffer[]{dst, slice};
                long read = this.channel.read(dsts);
                if (read == -1L) {
                    if (bytesConsumed == 0) {
                        this.close();
                        return -1;
                    }
                    this.retEOF = true;
                    this.close();
                    break;
                }
                if (read < (long)dstRemaining) {
                    tmpBytesCopied = Math.toIntExact(read);
                } else {
                    long bytesReadIntoBuffer = read - (long)dstRemaining;
                    Buffers.position(buffer, Math.toIntExact(bytesReadIntoBuffer));
                    this.flipped = false;
                    tmpBytesCopied = dstRemaining;
                }
            }
            bytesConsumed += tmpBytesCopied;
        }
        return bytesConsumed;
    }

    @Override
    public boolean isOpen() {
        return this.enqueuedBytes() || !this.retEOF && this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    private boolean enqueuedBytes() {
        return this.handle.position() > 0;
    }
}

