/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.CredentialsHolder;
import com.amazon.redshift.IPlugin;
import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.core.IdpAuthHelper;
import com.amazon.redshift.core.PluginProfilesCredentialsProvider;
import com.amazon.redshift.core.RedshiftJDBCSettings;
import com.amazon.redshift.core.ServerlessIamHelper;
import com.amazon.redshift.core.Utils;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.utils.RequestUtils;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftProperties;
import com.amazon.redshift.util.RedshiftState;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.RedshiftClientBuilder;
import software.amazon.awssdk.services.redshift.model.Association;
import software.amazon.awssdk.services.redshift.model.CertificateAssociation;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse;
import software.amazon.awssdk.services.redshift.model.Endpoint;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamRequest;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamResponse;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClientBuilder;

public final class IamHelper
extends IdpAuthHelper {
    static final int MAX_AMAZONCLIENT_RETRY = 5;
    static final int MAX_AMAZONCLIENT_RETRY_DELAY_MS = 1000;
    private static final String KEY_PREFERRED_ROLE = "preferred_role";
    private static final String KEY_ROLE_SESSION_NAME = "roleSessionName";
    private static final String KEY_ROLE_ARN = "roleArn";
    public static final int GET_CLUSTER_CREDENTIALS_V1_API = 1;
    public static final int GET_CLUSTER_CREDENTIALS_IAM_V2_API = 2;
    public static final int GET_CLUSTER_CREDENTIALS_SAML_V2_API = 3;
    public static final int GET_CLUSTER_CREDENTIALS_JWT_V2_API = 4;
    public static final int GET_SERVERLESS_CREDENTIALS_V1_API = 5;
    private static final Pattern HOST_PATTERN = Pattern.compile("(.+)\\.(.+)\\.(.+).redshift(-dev)?\\.amazonaws\\.com(.)*");
    private static final Pattern SERVERLESS_WORKGROUP_HOST_PATTERN = Pattern.compile("(.+)\\.(.+)\\.(.+).redshift-serverless(-dev)?\\.amazonaws\\.com(.)*");
    private static Map<String, GetClusterCredentialsResponse> credentialsCache = new HashMap<String, GetClusterCredentialsResponse>();
    private static Map<String, GetClusterCredentialsWithIamResponse> credentialsV2Cache = new HashMap<String, GetClusterCredentialsWithIamResponse>();

    private IamHelper() {
    }

    public static RedshiftProperties setIAMProperties(RedshiftProperties info, RedshiftJDBCSettings settings, RedshiftLogger log) throws RedshiftException {
        try {
            info = IamHelper.setAuthProperties(info, settings, log);
            String iamAccessKey = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_ACCESS_KEY_ID.getName(), info);
            String iamSecretKey = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_SECRET_ACCESS_KEY.getName(), info);
            String iamSessionToken = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_SESSION_TOKEN.getName(), info);
            String authProfile = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AUTH_PROFILE.getName(), info);
            String host = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.HOST.getName(), info);
            String userSetServerless = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IS_SERVERLESS.getName(), info);
            Boolean hasUserSetServerless = false;
            if (null != userSetServerless) {
                hasUserSetServerless = "true".equalsIgnoreCase(userSetServerless);
            }
            String acctId = null;
            String workGroup = null;
            Matcher mProvisioned = null;
            Matcher mServerless = null;
            if (null != host) {
                mProvisioned = HOST_PATTERN.matcher(host);
                mServerless = SERVERLESS_WORKGROUP_HOST_PATTERN.matcher(host);
            }
            String clusterId = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.CLUSTER_IDENTIFIER.getName(), info);
            if (null != mProvisioned && mProvisioned.matches() || null != clusterId && clusterId.startsWith("redshift-serverless-")) {
                if (RedshiftLogger.isEnable()) {
                    log.logInfo("Code flow for regular provisioned cluster", new Object[0]);
                }
                clusterId = RedshiftConnectionImpl.getRequiredConnSetting(RedshiftProperty.CLUSTER_IDENTIFIER.getName(), info);
            } else if (null != mServerless && mServerless.matches()) {
                if (RedshiftLogger.isEnable()) {
                    log.logInfo("Code flow for regular serverless cluster", new Object[0]);
                }
                settings.m_isServerless = true;
                acctId = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.SERVERLESS_ACCT_ID.getName(), info);
                workGroup = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.SERVERLESS_WORK_GROUP.getName(), info);
            } else if (hasUserSetServerless.booleanValue()) {
                settings.m_isServerless = true;
                workGroup = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.SERVERLESS_WORK_GROUP.getName(), info);
                acctId = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.SERVERLESS_ACCT_ID.getName(), info);
                if (workGroup != null) {
                    if (RedshiftLogger.isEnable()) {
                        log.logInfo("Code flow for nlb serverless cluster", new Object[0]);
                    }
                } else {
                    if (RedshiftLogger.isEnable()) {
                        log.logInfo("Code flow for cname serverless cluster", new Object[0]);
                    }
                    settings.m_isCname = true;
                }
            } else {
                if (RedshiftLogger.isEnable()) {
                    log.logInfo("Code flow for nlb/cname in provisioned clusters", new Object[0]);
                }
                settings.m_isCname = true;
            }
            String awsRegion = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AWS_REGION.getName(), info);
            String endpointUrl = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.ENDPOINT_URL.getName(), info);
            String stsEndpointUrl = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.STS_ENDPOINT_URL.getName(), info);
            String profile = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AWS_PROFILE.getName(), info);
            if (profile == null) {
                profile = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AWS_PROFILE.getName().toLowerCase(), info);
            }
            String iamDuration = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_DURATION.getName(), info);
            String iamAutoCreate = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.USER_AUTOCREATE.getName(), info);
            String iamDbUser = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.DB_USER.getName(), info);
            String iamDbGroups = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.DB_GROUPS.getName(), info);
            String iamForceLowercase = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.FORCE_LOWERCASE.getName(), info);
            String iamGroupFederation = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.GROUP_FEDERATION.getName(), info);
            String dbName = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.DBNAME.getName(), info);
            String hosts = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.HOST.getName(), info);
            String ports = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.PORT.getName(), info);
            settings.m_clusterIdentifier = clusterId;
            if (!(settings.m_isServerless || settings.m_isCname || null != settings.m_clusterIdentifier && !settings.m_clusterIdentifier.isEmpty())) {
                RedshiftException err = new RedshiftException(GT.tr("Missing connection property {0}", RedshiftProperty.CLUSTER_IDENTIFIER.getName()), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            if (settings.m_isServerless) {
                settings.m_acctId = acctId;
                settings.m_workGroup = workGroup;
            }
            if (null != awsRegion) {
                settings.m_awsRegion = awsRegion.trim().toLowerCase();
            }
            settings.m_endpoint = null != endpointUrl ? endpointUrl : System.getProperty("redshift.endpoint-url");
            settings.m_stsEndpoint = null != stsEndpointUrl ? stsEndpointUrl : System.getProperty("sts.endpoint-url");
            if (null != profile) {
                settings.m_profile = profile;
            }
            if (null != iamDuration) {
                try {
                    settings.m_iamDuration = Integer.parseInt(iamDuration);
                    if (settings.m_iamDuration < 900 || settings.m_iamDuration > 3600) {
                        RedshiftException err = new RedshiftException(GT.tr("Invalid connection property value or type range(900-3600) {0}", RedshiftProperty.IAM_DURATION.getName()), RedshiftState.UNEXPECTED_ERROR);
                        if (RedshiftLogger.isEnable()) {
                            log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                        }
                        throw err;
                    }
                }
                catch (NumberFormatException e) {
                    RedshiftException err = new RedshiftException(GT.tr("Invalid connection property value {0} : {1}", RedshiftProperty.IAM_DURATION.getName(), iamDuration), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.DEBUG, err.toString(), new Object[0]);
                    }
                    throw err;
                }
            }
            if (null != iamAccessKey) {
                settings.m_iamAccessKeyID = iamAccessKey;
            }
            if (null != iamSecretKey) {
                if (Utils.isNullOrEmpty(settings.m_iamAccessKeyID)) {
                    RedshiftException err = new RedshiftException(GT.tr("Missing connection property {0}", RedshiftProperty.IAM_ACCESS_KEY_ID.getName()), RedshiftState.UNEXPECTED_ERROR);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                    }
                    throw err;
                }
                settings.m_iamSecretKey = iamSecretKey;
                if (settings.m_iamSecretKey.isEmpty()) {
                    settings.m_iamSecretKey = settings.m_password;
                }
            } else {
                settings.m_iamSecretKey = settings.m_password;
            }
            if (null != iamSessionToken) {
                if (Utils.isNullOrEmpty(settings.m_iamAccessKeyID)) {
                    RedshiftException err = new RedshiftException(GT.tr("Missing connection property {0}", RedshiftProperty.IAM_ACCESS_KEY_ID.getName()), RedshiftState.UNEXPECTED_ERROR);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                    }
                    throw err;
                }
                settings.m_iamSessionToken = iamSessionToken;
            }
            settings.m_autocreate = iamAutoCreate == null ? null : Boolean.valueOf(iamAutoCreate);
            settings.m_forceLowercase = iamForceLowercase == null ? null : Boolean.valueOf(iamForceLowercase);
            settings.m_groupFederation = iamGroupFederation == null ? false : Boolean.valueOf(iamGroupFederation);
            if (null != iamDbUser) {
                settings.m_dbUser = iamDbUser;
            }
            settings.m_dbGroups = iamDbGroups != null ? Arrays.asList((settings.m_forceLowercase != null && settings.m_forceLowercase != false ? iamDbGroups.toLowerCase(Locale.getDefault()) : iamDbGroups).split(",")) : Collections.emptyList();
            settings.m_Schema = dbName;
            if (hosts != null) {
                settings.m_host = hosts;
            }
            if (ports != null) {
                settings.m_port = Integer.parseInt(ports);
            }
            IamHelper.setIAMCredentials(settings, log, authProfile);
            return info;
        }
        catch (RedshiftException re) {
            if (RedshiftLogger.isEnable()) {
                log.logError(re);
            }
            throw re;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void setIAMCredentials(RedshiftJDBCSettings settings, RedshiftLogger log, String authProfile) throws RedshiftException {
        providerType = CredentialProviderType.NONE;
        idpCredentialsRefresh = false;
        idpToken = null;
        if (!Utils.isNullOrEmpty(settings.m_credentialsProvider)) {
            if (!Utils.isNullOrEmpty(settings.m_profile)) {
                err = new RedshiftException(GT.tr("Conflict in connection property setting {0} and {1}", new Object[]{RedshiftProperty.CREDENTIALS_PROVIDER.getName(), RedshiftProperty.AWS_PROFILE.getName()}), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            if (Utils.isNullOrEmpty(authProfile) && !Utils.isNullOrEmpty(settings.m_iamAccessKeyID)) {
                err = new RedshiftException(GT.tr("Conflict in connection property setting {0} and {1}", new Object[]{RedshiftProperty.CREDENTIALS_PROVIDER.getName(), RedshiftProperty.IAM_ACCESS_KEY_ID.getName()}), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            try {
                clazz = Class.forName(settings.m_credentialsProvider).asSubclass(AwsCredentialsProvider.class);
                provider /* !! */  = clazz.newInstance();
                if (!(provider /* !! */  instanceof IPlugin)) ** GOTO lbl68
                plugin = (IPlugin)provider /* !! */ ;
                providerType = CredentialProviderType.PLUGIN;
                plugin.setLogger(log);
                plugin.setGroupFederation(settings.m_groupFederation);
                for (Map.Entry<String, String> entry : settings.m_pluginArgs.entrySet()) {
                    pluginArgKey = entry.getKey();
                    plugin.addParameter(pluginArgKey, entry.getValue());
                    if ("preferred_role".equalsIgnoreCase(pluginArgKey)) {
                        settings.m_preferredRole = entry.getValue();
                        continue;
                    }
                    if ("roleArn".equalsIgnoreCase(pluginArgKey)) {
                        settings.m_roleArn = entry.getValue();
                        continue;
                    }
                    if ("roleSessionName".equalsIgnoreCase(pluginArgKey)) {
                        settings.m_roleSessionName = entry.getValue();
                        continue;
                    }
                    if (!RedshiftProperty.DB_GROUPS_FILTER.getName().equalsIgnoreCase(pluginArgKey)) continue;
                    settings.m_dbGroupsFilter = entry.getValue();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                err = new RedshiftException(GT.tr("Invalid credentials provider class {0}", new Object[]{settings.m_credentialsProvider}), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            catch (NumberFormatException e) {
                err = new RedshiftException(GT.tr("{0} : {1}", new Object[]{e.getMessage(), settings.m_credentialsProvider}), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
        } else if (!Utils.isNullOrEmpty(settings.m_profile)) {
            if (Utils.isNullOrEmpty(authProfile) && !Utils.isNullOrEmpty(settings.m_iamAccessKeyID)) {
                err = new RedshiftException(GT.tr("Conflict in connection property setting {0} and {1}", new Object[]{RedshiftProperty.AWS_PROFILE.getName(), RedshiftProperty.IAM_ACCESS_KEY_ID.getName()}), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            provider /* !! */  = new PluginProfilesCredentialsProvider(settings, log);
            providerType = CredentialProviderType.PROFILE;
        } else if (!Utils.isNullOrEmpty(settings.m_iamAccessKeyID)) {
            if (!Utils.isNullOrEmpty(settings.m_iamSessionToken)) {
                credentials = AwsSessionCredentials.create((String)settings.m_iamAccessKeyID, (String)settings.m_iamSecretKey, (String)settings.m_iamSessionToken);
                providerType = CredentialProviderType.IAM_KEYS_WITH_SESSION;
            } else {
                credentials = AwsBasicCredentials.create((String)settings.m_iamAccessKeyID, (String)settings.m_iamSecretKey);
                providerType = CredentialProviderType.IAM_KEYS;
            }
            provider /* !! */  = StaticCredentialsProvider.create((AwsCredentials)credentials);
        } else {
            provider /* !! */  = DefaultCredentialsProvider.builder().build();
        }
lbl68:
        // 5 sources

        if (RedshiftLogger.isEnable()) {
            log.log(LogLevel.DEBUG, "IDP Credential Provider {0}:{1}", new Object[]{provider /* !! */ , settings.m_credentialsProvider});
        }
        if ((getClusterCredentialApiType = IamHelper.findTypeOfGetClusterCredentialsAPI(settings)) == 1 || getClusterCredentialApiType == 2 || getClusterCredentialApiType == 5) {
            if (RedshiftLogger.isEnable()) {
                log.log(LogLevel.DEBUG, "Calling provider.getCredentials()", new Object[0]);
            }
            if ((credentials = provider /* !! */ .resolveCredentials()) instanceof CredentialsHolder) {
                idpCredentialsRefresh = ((CredentialsHolder)credentials).isRefresh();
                im = ((CredentialsHolder)credentials).getMetadata();
                if (null != im) {
                    autoCreate = im.getAutoCreate();
                    dbUser = im.getDbUser();
                    samlDbUser = im.getSamlDbUser();
                    profileDbUser = im.getProfileDbUser();
                    dbGroups = im.getDbGroups();
                    forceLowercase = im.getForceLowercase();
                    allowDbUserOverride = im.getAllowDbUserOverride();
                    if (null == settings.m_autocreate) {
                        settings.m_autocreate = autoCreate;
                    }
                    if (null == settings.m_forceLowercase) {
                        settings.m_forceLowercase = forceLowercase;
                    }
                    if (allowDbUserOverride) {
                        if (null != samlDbUser) {
                            settings.m_dbUser = samlDbUser;
                        } else if (null != dbUser) {
                            settings.m_dbUser = dbUser;
                        } else if (null != profileDbUser) {
                            settings.m_dbUser = profileDbUser;
                        }
                    } else if (null != dbUser) {
                        settings.m_dbUser = dbUser;
                    } else if (null != profileDbUser) {
                        settings.m_dbUser = profileDbUser;
                    } else if (null != samlDbUser) {
                        settings.m_dbUser = samlDbUser;
                    }
                    if (settings.m_dbGroups.isEmpty() && null != dbGroups) {
                        settings.m_dbGroups = Arrays.asList((settings.m_forceLowercase != false ? dbGroups.toLowerCase(Locale.getDefault()) : dbGroups).split(","));
                    }
                }
            }
            if ("*".equals(settings.m_username) && null == settings.m_dbUser) {
                err = new RedshiftException(GT.tr("Missing connection property {0}", new Object[]{RedshiftProperty.DB_USER.getName()}), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
        } else {
            if (RedshiftLogger.isEnable()) {
                log.log(LogLevel.DEBUG, "groupFederation=" + settings.m_groupFederation, new Object[0]);
            }
            key = null;
            credentials = null;
            if (!settings.m_iamDisableCache) {
                key = IamHelper.getCredentialsV2CacheKey(settings, providerType, (AwsCredentialsProvider)provider /* !! */ , getClusterCredentialApiType, false);
                credentials = IamHelper.credentialsV2Cache.get(key);
            }
            if (credentials == null || RequestUtils.isCredentialExpired(credentials.expiration())) {
                if (providerType == CredentialProviderType.PLUGIN) {
                    plugin = (IPlugin)provider /* !! */ ;
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.DEBUG, "Calling plugin.getIdpToken()", new Object[0]);
                    }
                    idpToken = plugin.getIdpToken();
                }
                settings.m_idpToken = idpToken;
            }
        }
        IamHelper.setClusterCredentials((AwsCredentialsProvider)provider /* !! */ , settings, log, providerType, idpCredentialsRefresh, getClusterCredentialApiType);
    }

    private static void setClusterCredentials(AwsCredentialsProvider credProvider, RedshiftJDBCSettings settings, RedshiftLogger log, CredentialProviderType providerType, boolean idpCredentialsRefresh, int getClusterCredentialApiType) throws RedshiftException {
        try {
            RedshiftClientBuilder builder = RedshiftClient.builder();
            builder = (RedshiftClientBuilder)IamHelper.setBuilderConfiguration(settings, log, builder);
            switch (getClusterCredentialApiType) {
                case 1: {
                    RedshiftClient client = (RedshiftClient)((RedshiftClientBuilder)builder.credentialsProvider(credProvider)).build();
                    IamHelper.callDescribeCustomDomainNameAssociationsAPIForV1(settings, client, log);
                    IamHelper.callDescribeClustersAPIForV1(settings, client, log);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.DEBUG, "Call V1 API of GetClusterCredentials", new Object[0]);
                    }
                    GetClusterCredentialsResponse result = IamHelper.getClusterCredentialsResult(settings, client, log, providerType, idpCredentialsRefresh);
                    settings.m_username = result.dbUser();
                    settings.m_password = result.dbPassword();
                    if (!RedshiftLogger.isEnable()) break;
                    Date now = new Date();
                    log.logInfo(now + ": Using GetClusterCredentialsResult with expiration " + result.expiration(), new Object[0]);
                    break;
                }
                case 5: {
                    ServerlessIamHelper serverlessIamHelper = new ServerlessIamHelper(settings, log, credProvider);
                    if (null == settings.m_host || settings.m_port == 0) {
                        serverlessIamHelper.describeConfiguration(settings);
                    }
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.DEBUG, "Call Serverless V1 API of GetCredentials", new Object[0]);
                    }
                    serverlessIamHelper.getCredentialsResult(settings, providerType, idpCredentialsRefresh);
                    break;
                }
                case 2: {
                    RedshiftClient iamClient = (RedshiftClient)((RedshiftClientBuilder)builder.credentialsProvider(credProvider)).build();
                    IamHelper.callDescribeCustomDomainNameAssociationsAPIForV2(settings, iamClient, log);
                    IamHelper.callDescribeClustersAPIForV2(settings, iamClient, log);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.DEBUG, "Call V2 API of GetClusterCredentials", new Object[0]);
                    }
                    GetClusterCredentialsWithIamResponse iamResult = IamHelper.getClusterCredentialsResultV2(settings, iamClient, log, providerType, credProvider, getClusterCredentialApiType);
                    settings.m_username = iamResult.dbUser();
                    settings.m_password = iamResult.dbPassword();
                    if (!RedshiftLogger.isEnable()) break;
                    Date now = new Date();
                    log.logInfo(now + ": Using GetClusterCredentialsResultV2 with expiration " + iamResult.expiration(), new Object[0]);
                    log.logInfo(now + ": Using GetClusterCredentialsResultV2 with TimeToRefresh " + iamResult.nextRefreshTime(), new Object[0]);
                }
            }
        }
        catch (SdkClientException e) {
            RedshiftException err = new RedshiftException(GT.tr("IAM error retrieving temp credentials: {0}", e.getMessage()), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
            if (RedshiftLogger.isEnable()) {
                log.log(LogLevel.ERROR, err.toString(), new Object[0]);
            }
            throw err;
        }
    }

    static void callDescribeClustersAPIForV2(RedshiftJDBCSettings settings, RedshiftClient iamClient, RedshiftLogger log) {
        if (null == settings.m_host || settings.m_port == 0) {
            DescribeClustersRequest req;
            DescribeClustersResponse resp;
            List clusters;
            if (RedshiftLogger.isEnable()) {
                log.logInfo("calling describe clusters API with clusterID : " + settings.m_clusterIdentifier, new Object[0]);
            }
            if ((clusters = (resp = iamClient.describeClusters(req = (DescribeClustersRequest)DescribeClustersRequest.builder().clusterIdentifier(settings.m_clusterIdentifier).build())).clusters()).isEmpty()) {
                throw SdkClientException.create((String)"Failed to describeClusters.");
            }
            Cluster cluster = (Cluster)clusters.get(0);
            Endpoint endpoint = cluster.endpoint();
            if (null == endpoint) {
                throw SdkClientException.create((String)"Cluster is not fully created yet.");
            }
            settings.m_host = endpoint.address();
            settings.m_port = endpoint.port();
        }
    }

    static void callDescribeClustersAPIForV1(RedshiftJDBCSettings settings, RedshiftClient client, RedshiftLogger log) {
        if (null == settings.m_host || settings.m_port == 0) {
            DescribeClustersRequest req;
            DescribeClustersResponse resp;
            List clusters;
            if (RedshiftLogger.isEnable()) {
                log.logInfo("calling describe clusters API with clusterID : " + settings.m_clusterIdentifier, new Object[0]);
            }
            if ((clusters = (resp = client.describeClusters(req = (DescribeClustersRequest)DescribeClustersRequest.builder().clusterIdentifier(settings.m_clusterIdentifier).build())).clusters()).isEmpty()) {
                throw SdkClientException.create((String)"Failed to describeClusters.");
            }
            Cluster cluster = (Cluster)clusters.get(0);
            Endpoint endpoint = cluster.endpoint();
            if (null == endpoint) {
                throw SdkClientException.create((String)"Cluster is not fully created yet.");
            }
            settings.m_host = endpoint.address();
            settings.m_port = endpoint.port();
        }
    }

    static void callDescribeCustomDomainNameAssociationsAPIForV2(RedshiftJDBCSettings settings, RedshiftClient iamClient, RedshiftLogger log) throws RedshiftException {
        if (settings.m_isCname) {
            DescribeCustomDomainAssociationsRequest.Builder describeRequestBuilder = DescribeCustomDomainAssociationsRequest.builder();
            if (null != settings.m_host) {
                if (RedshiftLogger.isEnable()) {
                    log.logInfo("calling describe cname associations API with hostname : " + settings.m_host, new Object[0]);
                }
            } else {
                if (RedshiftLogger.isEnable()) {
                    log.logInfo("No CNAME provided. No-op.", new Object[0]);
                }
                return;
            }
            describeRequestBuilder.customDomainName(settings.m_host);
            try {
                DescribeCustomDomainAssociationsRequest describeRequest = (DescribeCustomDomainAssociationsRequest)describeRequestBuilder.build();
                DescribeCustomDomainAssociationsResponse describeResponse = iamClient.describeCustomDomainAssociations(describeRequest);
                List associations = describeResponse.associations();
                if (associations.stream().count() > 1L) {
                    if (RedshiftLogger.isEnable()) {
                        log.logInfo("Multiple associations received for provided custom domain name : " + describeRequest.customDomainName() + ". Only one expected.", new Object[0]);
                    }
                    return;
                }
                String clusterID = ((CertificateAssociation)((Association)describeResponse.associations().get(0)).certificateAssociations().get(0)).clusterIdentifier();
                if (null != clusterID && !clusterID.isEmpty()) {
                    settings.m_clusterIdentifier = clusterID;
                    if (RedshiftLogger.isEnable()) {
                        log.logDebug("setting cluster ID to : " + settings.m_clusterIdentifier, new Object[0]);
                    }
                }
            }
            catch (Exception ex) {
                if (RedshiftLogger.isEnable()) {
                    log.logInfo("No cluster identifier received from Redshift CNAME lookup. Setting CNAME to false.", new Object[0]);
                }
                settings.m_isCname = false;
            }
        }
    }

    static void callDescribeCustomDomainNameAssociationsAPIForV1(RedshiftJDBCSettings settings, RedshiftClient client, RedshiftLogger log) throws RedshiftException {
        if (settings.m_isCname) {
            DescribeCustomDomainAssociationsRequest.Builder describeRequestBuilder = DescribeCustomDomainAssociationsRequest.builder();
            if (null != settings.m_host) {
                if (RedshiftLogger.isEnable()) {
                    log.logInfo("calling describe cname associations API with hostname : " + settings.m_host, new Object[0]);
                }
            } else {
                if (RedshiftLogger.isEnable()) {
                    log.logInfo("No CNAME provided. No-op.", new Object[0]);
                }
                return;
            }
            describeRequestBuilder.customDomainName(settings.m_host);
            try {
                DescribeCustomDomainAssociationsRequest describeRequest = (DescribeCustomDomainAssociationsRequest)describeRequestBuilder.build();
                DescribeCustomDomainAssociationsResponse describeResponse = client.describeCustomDomainAssociations(describeRequest);
                List associations = describeResponse.associations();
                if (associations.stream().count() > 1L) {
                    if (RedshiftLogger.isEnable()) {
                        log.logInfo("Multiple associations received for provided custom domain name : " + describeRequest.customDomainName() + ". Only one expected.", new Object[0]);
                    }
                    return;
                }
                String clusterID = ((CertificateAssociation)((Association)describeResponse.associations().get(0)).certificateAssociations().get(0)).clusterIdentifier();
                if (null != clusterID && !clusterID.isEmpty()) {
                    settings.m_clusterIdentifier = clusterID;
                    if (RedshiftLogger.isEnable()) {
                        log.logDebug("setting cluster ID to : " + settings.m_clusterIdentifier, new Object[0]);
                    }
                }
            }
            catch (Exception ex) {
                if (RedshiftLogger.isEnable()) {
                    log.logInfo("No cluster identifier received from Redshift CNAME lookup. Setting CNAME to false.", new Object[0]);
                }
                settings.m_isCname = false;
            }
        }
    }

    private static synchronized GetClusterCredentialsResponse getClusterCredentialsResult(RedshiftJDBCSettings settings, RedshiftClient client, RedshiftLogger log, CredentialProviderType providerType, boolean idpCredentialsRefresh) throws SdkClientException {
        String key = null;
        GetClusterCredentialsResponse credentials = null;
        if (!settings.m_iamDisableCache) {
            key = IamHelper.getCredentialsCacheKey(settings, providerType, false);
            credentials = credentialsCache.get(key);
        }
        if (credentials == null || providerType == CredentialProviderType.PLUGIN && idpCredentialsRefresh || RequestUtils.isCredentialExpired(credentials.expiration())) {
            if (RedshiftLogger.isEnable()) {
                log.logInfo("GetClusterCredentials NOT from cache", new Object[0]);
            }
            if (!settings.m_iamDisableCache) {
                credentialsCache.remove(key);
            }
            if (settings.m_isCname) {
                GetClusterCredentialsRequest request = IamHelper.constructRequestForGetClusterCredentials(settings, true, log);
                try {
                    credentials = IamHelper.makeGetClusterCredentialsAPICall(request, credentials, client, log);
                }
                catch (SdkClientException sdkClientException) {
                    if (RedshiftLogger.isEnable()) {
                        log.logInfo("GetClusterCredentials API call failed with CNAME request. Retrying with ClusterID.", new Object[0]);
                    }
                    request = IamHelper.constructRequestForGetClusterCredentials(settings, false, log);
                    credentials = IamHelper.makeGetClusterCredentialsAPICall(request, credentials, client, log);
                }
            } else {
                GetClusterCredentialsRequest request = IamHelper.constructRequestForGetClusterCredentials(settings, false, log);
                credentials = IamHelper.makeGetClusterCredentialsAPICall(request, credentials, client, log);
            }
            if (!settings.m_iamDisableCache) {
                credentialsCache.put(key, credentials);
            }
        } else if (RedshiftLogger.isEnable()) {
            log.logInfo("GetClusterCredentials from cache", new Object[0]);
        }
        return credentials;
    }

    static GetClusterCredentialsRequest constructRequestForGetClusterCredentials(RedshiftJDBCSettings settings, boolean constructWithCname, RedshiftLogger log) {
        GetClusterCredentialsRequest.Builder requestBuilder = GetClusterCredentialsRequest.builder();
        if (settings.m_iamDuration > 0) {
            requestBuilder.durationSeconds(Integer.valueOf(settings.m_iamDuration));
        }
        requestBuilder.dbName(settings.m_Schema);
        requestBuilder.dbUser(settings.m_dbUser == null ? settings.m_username : settings.m_dbUser);
        requestBuilder.autoCreate(settings.m_autocreate);
        requestBuilder.dbGroups(settings.m_dbGroups);
        if (constructWithCname) {
            requestBuilder.customDomainName(settings.m_host);
        } else {
            requestBuilder.clusterIdentifier(settings.m_clusterIdentifier);
        }
        if (RedshiftLogger.isEnable()) {
            log.logInfo(requestBuilder.toString(), new Object[0]);
        }
        return (GetClusterCredentialsRequest)requestBuilder.build();
    }

    static GetClusterCredentialsResponse makeGetClusterCredentialsAPICall(GetClusterCredentialsRequest request, GetClusterCredentialsResponse credentials, RedshiftClient client, RedshiftLogger log) {
        for (int i = 0; i < 5; ++i) {
            try {
                credentials = client.getClusterCredentials(request);
                break;
            }
            catch (SdkClientException sdkClientException) {
                if (RedshiftLogger.isEnable()) {
                    log.logDebug("Call to getClusterCredentials failed with error: " + sdkClientException.getMessage(), new Object[0]);
                }
                IamHelper.checkForApiCallRateExceedError(sdkClientException, i, "getClusterCredentialsResult", log);
                continue;
            }
        }
        return credentials;
    }

    static void checkForApiCallRateExceedError(SdkClientException sdkClientException, int i, String callerMethod, RedshiftLogger log) throws SdkClientException {
        if (sdkClientException.getMessage().contains("Rate exceeded") && i < 4) {
            if (RedshiftLogger.isEnable()) {
                log.logInfo(callerMethod + " caught 'Rate exceeded' error...", new Object[0]);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        } else {
            throw sdkClientException;
        }
    }

    private static synchronized GetClusterCredentialsWithIamResponse getClusterCredentialsResultV2(RedshiftJDBCSettings settings, RedshiftClient client, RedshiftLogger log, CredentialProviderType providerType, AwsCredentialsProvider provider, int getClusterCredentialApiType) throws SdkClientException {
        String key = null;
        GetClusterCredentialsWithIamResponse credentials = null;
        if (!settings.m_iamDisableCache) {
            key = IamHelper.getCredentialsV2CacheKey(settings, providerType, provider, getClusterCredentialApiType, false);
            credentials = credentialsV2Cache.get(key);
        }
        if (credentials == null || providerType == CredentialProviderType.PLUGIN && settings.m_idpToken != null || RequestUtils.isCredentialExpired(credentials.expiration())) {
            if (RedshiftLogger.isEnable()) {
                log.logInfo("GetClusterCredentialsV2 NOT from cache", new Object[0]);
            }
            if (!settings.m_iamDisableCache) {
                credentialsV2Cache.remove(key);
            }
            if (settings.m_isCname) {
                GetClusterCredentialsWithIamRequest request = IamHelper.constructRequestForGetClusterCredentialsWithIAM(settings, true, log);
                try {
                    credentials = IamHelper.makeGetClusterCredentialsWithIAMAPICall(request, credentials, client, log);
                }
                catch (SdkClientException sdkClientException) {
                    if (RedshiftLogger.isEnable()) {
                        log.logInfo("GetClusterCredentials API call failed with CNAME request. Retrying with ClusterID.", new Object[0]);
                    }
                    request = IamHelper.constructRequestForGetClusterCredentialsWithIAM(settings, false, log);
                    credentials = IamHelper.makeGetClusterCredentialsWithIAMAPICall(request, credentials, client, log);
                }
            } else {
                GetClusterCredentialsWithIamRequest request = IamHelper.constructRequestForGetClusterCredentialsWithIAM(settings, false, log);
                credentials = IamHelper.makeGetClusterCredentialsWithIAMAPICall(request, credentials, client, log);
            }
            if (!settings.m_iamDisableCache) {
                credentialsV2Cache.put(key, credentials);
            }
        } else if (RedshiftLogger.isEnable()) {
            log.logInfo("GetClusterCredentialsV2 from cache", new Object[0]);
        }
        return credentials;
    }

    static GetClusterCredentialsWithIamRequest constructRequestForGetClusterCredentialsWithIAM(RedshiftJDBCSettings settings, boolean constructWithCname, RedshiftLogger log) {
        GetClusterCredentialsWithIamRequest.Builder requestBuilder = GetClusterCredentialsWithIamRequest.builder();
        if (settings.m_iamDuration > 0) {
            requestBuilder.durationSeconds(Integer.valueOf(settings.m_iamDuration));
        }
        requestBuilder.dbName(settings.m_Schema);
        if (constructWithCname) {
            requestBuilder.customDomainName(settings.m_host);
        } else {
            requestBuilder.clusterIdentifier(settings.m_clusterIdentifier);
        }
        if (RedshiftLogger.isEnable()) {
            log.logInfo(requestBuilder.toString(), new Object[0]);
        }
        return (GetClusterCredentialsWithIamRequest)requestBuilder.build();
    }

    static GetClusterCredentialsWithIamResponse makeGetClusterCredentialsWithIAMAPICall(GetClusterCredentialsWithIamRequest request, GetClusterCredentialsWithIamResponse credentials, RedshiftClient client, RedshiftLogger log) {
        for (int i = 0; i < 5; ++i) {
            try {
                credentials = client.getClusterCredentialsWithIAM(request);
                break;
            }
            catch (SdkClientException sdkClientException) {
                IamHelper.checkForApiCallRateExceedError(sdkClientException, i, "getClusterCredentialsResultV2", log);
                continue;
            }
        }
        return credentials;
    }

    static String getCredentialsCacheKey(RedshiftJDBCSettings settings, CredentialProviderType providerType, boolean serverless) {
        String dbGroups = "";
        if (settings.m_dbGroups != null && !settings.m_dbGroups.isEmpty()) {
            Collections.sort(settings.m_dbGroups);
            dbGroups = String.join((CharSequence)",", settings.m_dbGroups);
        }
        String key = (!serverless ? settings.m_clusterIdentifier : settings.m_acctId) + ";" + (serverless && settings.m_workGroup != null ? settings.m_workGroup : "") + ";" + (settings.m_dbUser == null ? settings.m_username : settings.m_dbUser) + ";" + (settings.m_Schema == null ? "" : settings.m_Schema) + ";" + dbGroups + ";" + settings.m_autocreate + ";" + settings.m_iamDuration;
        switch (providerType) {
            case PROFILE: {
                key = key + ";" + settings.m_profile;
                break;
            }
            case IAM_KEYS_WITH_SESSION: {
                key = key + ";" + settings.m_iamAccessKeyID + ";" + settings.m_iamSecretKey + ";" + settings.m_iamSessionToken;
                break;
            }
            case IAM_KEYS: {
                key = key + ";" + settings.m_iamAccessKeyID + ";" + settings.m_iamSecretKey;
                break;
            }
        }
        return key;
    }

    static String getCredentialsV2CacheKey(RedshiftJDBCSettings settings, CredentialProviderType providerType, AwsCredentialsProvider provider, int getClusterCredentialApiType, boolean serverless) {
        String key = "";
        if (providerType == CredentialProviderType.PLUGIN) {
            IPlugin plugin = (IPlugin)provider;
            key = plugin.getCacheKey();
        }
        key = key + (!serverless ? settings.m_clusterIdentifier : settings.m_acctId) + ";" + (serverless && settings.m_workGroup != null ? settings.m_workGroup : "") + ";" + (settings.m_Schema == null ? "" : settings.m_Schema) + ";" + settings.m_iamDuration;
        if (getClusterCredentialApiType == 3) {
            if (settings.m_preferredRole != null) {
                key = key + settings.m_preferredRole + ";";
            }
            if (settings.m_dbGroupsFilter != null) {
                key = key + settings.m_dbGroupsFilter + ";";
            }
        } else if (getClusterCredentialApiType == 4) {
            if (settings.m_idpToken != null) {
                key = key + settings.m_idpToken + ";";
            }
            if (settings.m_roleArn != null) {
                key = key + settings.m_roleArn + ";";
            }
            if (settings.m_roleSessionName != null) {
                key = key + settings.m_roleSessionName + ";";
            }
        }
        switch (providerType) {
            case PROFILE: {
                key = key + ";" + settings.m_profile;
                break;
            }
            case IAM_KEYS_WITH_SESSION: {
                key = key + ";" + settings.m_iamAccessKeyID + ";" + settings.m_iamSecretKey + ";" + settings.m_iamSessionToken;
                break;
            }
            case IAM_KEYS: {
                key = key + ";" + settings.m_iamAccessKeyID + ";" + settings.m_iamSecretKey;
                break;
            }
        }
        return key;
    }

    private static int findTypeOfGetClusterCredentialsAPI(RedshiftJDBCSettings settings) {
        if (!settings.m_isServerless) {
            if (!settings.m_groupFederation.booleanValue()) {
                return 1;
            }
            return 2;
        }
        return 5;
    }

    static AwsClientBuilder setBuilderConfiguration(RedshiftJDBCSettings settings, RedshiftLogger log, AwsClientBuilder<?, ?> builder) {
        ProxyConfiguration proxyConfig = RequestUtils.getProxyConfiguration(log);
        if (proxyConfig != null) {
            ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
            httpClientBuilder.proxyConfiguration(proxyConfig);
            if (builder instanceof RedshiftClientBuilder) {
                ((RedshiftClientBuilder)builder).httpClient(httpClientBuilder.build());
            } else if (builder instanceof RedshiftServerlessClientBuilder) {
                ((RedshiftServerlessClientBuilder)builder).httpClient(httpClientBuilder.build());
            }
        }
        if (RedshiftLogger.isEnable()) {
            log.logInfo("setBuilderConfiguration: settings.m_endpoint= " + settings.m_endpoint + " settings.m_awsRegion = " + settings.m_awsRegion, new Object[0]);
        }
        if (settings.m_endpoint != null) {
            builder.endpointOverride(URI.create(settings.m_endpoint));
        }
        if (settings.m_awsRegion != null && !settings.m_awsRegion.isEmpty()) {
            builder.region(Region.of((String)settings.m_awsRegion));
        }
        return builder;
    }

    static enum CredentialProviderType {
        NONE,
        PROFILE,
        IAM_KEYS_WITH_SESSION,
        IAM_KEYS,
        PLUGIN;

    }
}

