/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress.methods;

import tim.prune.data.DataPoint;
import tim.prune.data.MarkingData;
import tim.prune.data.NumberUtils;
import tim.prune.data.Track;
import tim.prune.function.compress.CompressionMethodType;
import tim.prune.function.compress.TrackDetails;
import tim.prune.function.compress.methods.CompressionMethod;

public class SingletonsMethod
extends CompressionMethod {
    private final double _factor;

    public SingletonsMethod(double d) {
        this._factor = d;
    }

    public SingletonsMethod(String string) {
        this._factor = NumberUtils.getDoubleOrZero(SingletonsMethod.recogniseString(string) ? string.substring(4) : string);
    }

    @Override
    public CompressionMethodType getType() {
        return CompressionMethodType.SINGLETONS;
    }

    @Override
    public String getParam() {
        return "" + Math.abs(this._factor);
    }

    @Override
    public int compress(Track track, TrackDetails trackDetails, MarkingData markingData) {
        int n = track.getNumPoints();
        int n2 = 0;
        double d = this.tweakFactor(this._factor) * trackDetails.getMeanRadians();
        DataPoint dataPoint = null;
        DataPoint dataPoint2 = null;
        TrackDetails trackDetails2 = trackDetails.modifyUsingMarkings(markingData);
        int n3 = 0;
        while (n3 < n) {
            if (!markingData.isPointMarkedForDeletion(n3)) {
                DataPoint dataPoint3;
                dataPoint = track.getPoint(n3);
                if (!dataPoint.isWaypoint() && !dataPoint.hasMedia() && trackDetails2.isSegmentStart(n3) && trackDetails2.isSegmentEnd(n3) && DataPoint.calculateRadiansBetween(dataPoint2, dataPoint) > d && ((dataPoint3 = SingletonsMethod.getNextTrackPoint(track, n3 + 1, markingData)) == null || DataPoint.calculateRadiansBetween(dataPoint, dataPoint3) > d)) {
                    markingData.markPointForDeletion(n3);
                    ++n2;
                }
                if (!dataPoint.isWaypoint() && !markingData.isPointMarkedForDeletion(n3)) {
                    dataPoint2 = dataPoint;
                }
            }
            ++n3;
        }
        return n2;
    }

    private double tweakFactor(double d) {
        if (d <= 0.0) {
            return 1.0;
        }
        return d <= 1.0 ? d : 1.0 / d;
    }

    @Override
    public String getSettingsString() {
        return String.valueOf(this.getType().getKey()) + this._factor;
    }

    static boolean recogniseString(String string) {
        return SingletonsMethod.recogniseString(string, CompressionMethodType.SINGLETONS);
    }
}

