/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.resolver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.kotlin.dsl.resolver.SourcePathProviderKt;
import org.gradle.kotlin.dsl.support.ZipKt;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Not worth caching")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\b!\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000b*\u00020\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/gradle/kotlin/dsl/resolver/FindGradleSources;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lorg/gradle/api/artifacts/transform/TransformParameters$None;", "<init>", "()V", "input", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInput", "()Lorg/gradle/api/provider/Provider;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "withTemporaryDir", "block", "Lkotlin/Function1;", "Ljava/io/File;", "distroDirFrom", "unzippedDistroDir", "projectDirectoriesOf", "", "distroDir", "subprojectsDirectoriesOf", "platformProjectsDirectoriesOf", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nFindGradleSources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindGradleSources.kt\norg/gradle/kotlin/dsl/resolver/FindGradleSources\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,101:1\n1374#2:102\n1460#2,5:103\n1869#2:108\n1869#2:109\n1870#2:112\n1870#2:113\n13805#3,2:110\n*S KotlinDebug\n*F\n+ 1 FindGradleSources.kt\norg/gradle/kotlin/dsl/resolver/FindGradleSources\n*L\n99#1:102\n99#1:103,5\n53#1:108\n56#1:109\n56#1:112\n53#1:113\n57#1:110,2\n*E\n"})
public abstract class FindGradleSources
implements TransformAction<TransformParameters.None> {
    @PathSensitive(value=PathSensitivity.NONE)
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInput();

    public void transform(@NotNull TransformOutputs outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        this.withTemporaryDir(outputs, (Function1<? super File, Unit>)((Function1)arg_0 -> FindGradleSources.transform$lambda$0(this, outputs, arg_0)));
    }

    private final void withTemporaryDir(TransformOutputs $this$withTemporaryDir, Function1<? super File, Unit> block) {
        File file = $this$withTemporaryDir.dir((Object)"empty");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dir(...)");
        File dir = file;
        block.invoke((Object)dir);
        if (!FilesKt.deleteRecursively((File)dir) || !dir.mkdirs()) {
            throw new IOException("Unable to clear artifact transform temporary directory " + dir);
        }
    }

    private final File distroDirFrom(File unzippedDistroDir) {
        Object[] objectArray = unzippedDistroDir.listFiles();
        return objectArray != null ? (File)ArraysKt.singleOrNull((Object[])objectArray) : null;
    }

    private final Collection<File> projectDirectoriesOf(File distroDir) {
        return CollectionsKt.plus(this.subprojectsDirectoriesOf(distroDir), (Iterable)this.platformProjectsDirectoriesOf(distroDir));
    }

    private final Collection<File> subprojectsDirectoriesOf(File distroDir) {
        return SourcePathProviderKt.subDirsOf(FilesKt.resolve((File)distroDir, (String)"subprojects"));
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<File> platformProjectsDirectoriesOf(File distroDir) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = SourcePathProviderKt.subDirsOf(FilesKt.resolve((File)distroDir, (String)"platforms"));
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File platform = (File)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = SourcePathProviderKt.subDirsOf(platform);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit transform$lambda$0(FindGradleSources this$0, TransformOutputs $outputs, File unzippedDistroDir) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)unzippedDistroDir, (String)"unzippedDistroDir");
            File file = ((FileSystemLocation)this$0.getInput().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            ZipKt.unzipTo(unzippedDistroDir, file);
            File file2 = this$0.distroDirFrom(unzippedDistroDir);
            if (file2 == null) break block3;
            File distroRootDir = file2;
            boolean bl = false;
            Iterable $this$forEach$iv = this$0.projectDirectoriesOf(distroRootDir);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File projectDir = (File)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$outputs.dir((Object)projectDir.getName()), (String)"dir(...)");
                Iterable $this$forEach$iv2 = SourcePathProviderKt.subDirsOf(FilesKt.resolve((File)projectDir, (String)"src/main"));
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File[] $this$forEach$iv3;
                    File srcDir = (File)element$iv2;
                    boolean bl3 = false;
                    if (srcDir.listFiles() == null) continue;
                    boolean $i$f$forEach3 = false;
                    int n = $this$forEach$iv3.length;
                    for (int j = 0; j < n; ++j) {
                        File outputSrcDir;
                        File element$iv3;
                        File srcDirChild = element$iv3 = $this$forEach$iv3[j];
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)srcDirChild);
                        String string = srcDirChild.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        FilesKt.copyRecursively$default((File)srcDirChild, (File)FilesKt.resolve((File)outputSrcDir, (String)string), (boolean)false, null, (int)6, null);
                    }
                }
            }
        }
        return Unit.INSTANCE;
    }
}

