/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.function.Function;
import org.gradle.cache.AsyncCacheAccess;
import org.gradle.cache.FileLock;
import org.gradle.cache.MultiProcessSafeIndexedCache;
import org.gradle.cache.internal.MultiProcessSafeAsyncPersistentIndexedCache;
import org.jspecify.annotations.Nullable;

public class AsyncCacheAccessDecoratedCache<K, V>
implements MultiProcessSafeAsyncPersistentIndexedCache<K, V> {
    private final AsyncCacheAccess asyncCacheAccess;
    private final MultiProcessSafeIndexedCache<K, V> indexedCache;

    public AsyncCacheAccessDecoratedCache(AsyncCacheAccess asyncCacheAccess, MultiProcessSafeIndexedCache<K, V> indexedCache) {
        this.asyncCacheAccess = asyncCacheAccess;
        this.indexedCache = indexedCache;
    }

    public String toString() {
        return "{async-cache cache: " + this.indexedCache + "}";
    }

    @Override
    public @Nullable V get(K key) {
        return (V)this.asyncCacheAccess.read(() -> this.indexedCache.getIfPresent(key));
    }

    @Override
    public V get(K key, Function<? super K, ? extends V> producer, Runnable completion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putLater(K key, V value, Runnable completion) {
        try {
            this.asyncCacheAccess.enqueue(() -> {
                try {
                    this.indexedCache.put(key, value);
                }
                finally {
                    completion.run();
                }
            });
        }
        catch (RuntimeException e) {
            completion.run();
            throw e;
        }
    }

    @Override
    public void removeLater(K key, Runnable completion) {
        try {
            this.asyncCacheAccess.enqueue(() -> {
                try {
                    this.indexedCache.remove(key);
                }
                finally {
                    completion.run();
                }
            });
        }
        catch (RuntimeException e) {
            completion.run();
            throw e;
        }
    }

    @Override
    public void afterLockAcquire(FileLock.State currentCacheState) {
        this.indexedCache.afterLockAcquire(currentCacheState);
    }

    @Override
    public void finishWork() {
        this.indexedCache.finishWork();
    }

    @Override
    public void beforeLockRelease(FileLock.State currentCacheState) {
        this.indexedCache.beforeLockRelease(currentCacheState);
    }
}

