/*
    Copyright Intel Corporation.
    
    This software and the related documents are Intel copyrighted materials, and
    your use of them is governed by the express license under which they were
    provided to you (License). Unless the License provides otherwise, you may
    not use, modify, copy, publish, distribute, disclose or transmit this
    software or the related documents without Intel's prior written permission.
    
    This software and the related documents are provided as is, with no express
    or implied warranties, other than those that are expressly stated in the
    License.
*/
#include <stdio.h>

#include "base.hpp"

int main() {
    auto version = ccl::get_library_version();

    printf("\nCompile-time CCL library version:\nmajor: %d\nminor: %d\nupdate: %d\n"
           "Product: %s\nBuild date: %s\nFull: %s\n",
           CCL_MAJOR_VERSION,
           CCL_MINOR_VERSION,
           CCL_UPDATE_VERSION,
           CCL_PRODUCT_STATUS,
           CCL_PRODUCT_BUILD_DATE,
           CCL_PRODUCT_FULL);

    printf("\nRuntime CCL library version:\nmajor: %d\nminor: %d\nupdate: %d\n"
           "Product: %s\nBuild date: %s\nFull: %s\ncl_backend name: %s\n",
           version.major,
           version.minor,
           version.update,
           version.product_status,
           version.build_date,
           version.full,
           version.cl_backend_name.c_str());

    printf("\noneCCL specification version: %s\n", ONECCL_SPEC_VERSION);

    if (CCL_MAJOR_VERSION == version.major && CCL_MINOR_VERSION <= version.minor) {
        printf("\nVersions are compatible\n");
    }
    else {
        perror("\nVersions are not compatible!\n");
        return -1;
    }

    printf("\nPASSED\n");

    return 0;
}
