/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fir.projectStructure.provider;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinCodeFragmentContextModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalModuleStateModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalScriptModuleStateModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalSourceModuleStateModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalSourceOutOfBlockModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleOutOfBlockModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleStateModificationEvent;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.idea.base.fir.projectStructure.modules.KaEntityBasedModuleCreationData;
import org.jetbrains.kotlin.idea.base.fir.projectStructure.modules.library.KaLibraryModuleImpl;
import org.jetbrains.kotlin.idea.base.fir.projectStructure.modules.library.KaLibrarySdkModuleImpl;
import org.jetbrains.kotlin.idea.base.fir.projectStructure.modules.source.KaSourceModuleImpl;
import org.jetbrains.kotlin.idea.base.projectStructure.KaSourceModuleKind;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0001\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\u0006\u0010\u001f\u001a\u00020\u001aJ\u000e\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\bJ\u000e\u0010\"\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u000bJ\u0016\u0010#\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020'H\u0002J\u0006\u0010(\u001a\u00020)J\u001c\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u00072\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010+\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/K2IDEProjectStructureProviderCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "libraryCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/modules/library/KaLibraryModuleImpl;", "sdkCache", "Lcom/intellij/platform/workspace/jps/entities/SdkId;", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/modules/library/KaLibrarySdkModuleImpl;", "productionSourceCache", "Lcom/intellij/platform/workspace/jps/entities/ModuleId;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;", "testSourceCache", "analysisMessageBus", "Lcom/intellij/util/messages/MessageBus;", "sdkAndLibrariesTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "sourcesTracker", "getCacheSdkAndLibrariesTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getCacheSourcesTracker", "invalidateCaches", "", "module", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "invalidateAllModuleCaches", "invalidateLibraryModuleCaches", "invalidateSourceModuleCaches", "cachedKaLibraryModule", "id", "cachedKaSdkModule", "cachedKaSourceModule", "kind", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KaSourceModuleKind;", "creationData", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/modules/KaEntityBasedModuleCreationData;", "isItSafeToCacheModules", "", "moduleCacheForKind", "dispose", "Companion", "kotlin.base.fir.project-structure"})
public final class K2IDEProjectStructureProviderCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<LibraryId, KaLibraryModuleImpl> libraryCache;
    @NotNull
    private final ConcurrentHashMap<SdkId, KaLibrarySdkModuleImpl> sdkCache;
    @NotNull
    private final ConcurrentHashMap<ModuleId, KaSourceModule> productionSourceCache;
    @NotNull
    private final ConcurrentHashMap<ModuleId, KaSourceModule> testSourceCache;
    @NotNull
    private final MessageBus analysisMessageBus;
    @NotNull
    private final SimpleModificationTracker sdkAndLibrariesTracker;
    @NotNull
    private final SimpleModificationTracker sourcesTracker;

    public K2IDEProjectStructureProviderCache(@NotNull Project project) {
        MessageBusConnection messageBusConnection;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.libraryCache = new ConcurrentHashMap();
        this.sdkCache = new ConcurrentHashMap();
        this.productionSourceCache = new ConcurrentHashMap();
        this.testSourceCache = new ConcurrentHashMap();
        this.analysisMessageBus = KotlinMessageBusProviderKt.getAnalysisMessageBus(this.project);
        this.sdkAndLibrariesTracker = new SimpleModificationTracker();
        this.sourcesTracker = new SimpleModificationTracker();
        MessageBusConnection $this$_init__u24lambda_u241 = messageBusConnection = this.analysisMessageBus.connect((Disposable)this);
        boolean bl = false;
        $this$_init__u24lambda_u241.subscribe(KotlinModificationEvent.Companion.getTOPIC(), arg_0 -> K2IDEProjectStructureProviderCache.lambda$1$lambda$0(this, arg_0));
    }

    @NotNull
    public final ModificationTracker getCacheSdkAndLibrariesTracker() {
        return (ModificationTracker)this.sdkAndLibrariesTracker;
    }

    @NotNull
    public final ModificationTracker getCacheSourcesTracker() {
        return (ModificationTracker)this.sourcesTracker;
    }

    private final void invalidateCaches(KaModule module) {
        KaModule kaModule = module;
        if (kaModule instanceof KaSourceModuleImpl) {
            this.invalidateSourceModuleCaches();
        } else if (kaModule instanceof KaLibraryModuleImpl) {
            this.libraryCache.remove(((KaLibraryModuleImpl)module).getEntityId());
            this.sdkAndLibrariesTracker.incModificationCount();
            this.invalidateSourceModuleCaches();
        } else if (kaModule instanceof KaLibrarySdkModuleImpl) {
            this.sdkCache.remove(((KaLibrarySdkModuleImpl)module).getEntityId());
            this.sdkAndLibrariesTracker.incModificationCount();
            this.invalidateSourceModuleCaches();
        }
    }

    private final void invalidateAllModuleCaches() {
        this.invalidateSourceModuleCaches();
        this.invalidateLibraryModuleCaches();
    }

    private final void invalidateLibraryModuleCaches() {
        this.libraryCache.clear();
        this.sdkCache.clear();
        this.sdkAndLibrariesTracker.incModificationCount();
    }

    public final void invalidateSourceModuleCaches() {
        this.productionSourceCache.clear();
        this.testSourceCache.clear();
        this.sourcesTracker.incModificationCount();
    }

    @NotNull
    public final KaLibraryModuleImpl cachedKaLibraryModule(@NotNull LibraryId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (!this.isItSafeToCacheModules()) {
            return new KaLibraryModuleImpl(id, this.project, this.creationData());
        }
        KaLibraryModuleImpl kaLibraryModuleImpl = this.libraryCache.computeIfAbsent(id, arg_0 -> K2IDEProjectStructureProviderCache.cachedKaLibraryModule$lambda$3(arg_0 -> K2IDEProjectStructureProviderCache.cachedKaLibraryModule$lambda$2(id, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)kaLibraryModuleImpl, (String)"computeIfAbsent(...)");
        return kaLibraryModuleImpl;
    }

    @NotNull
    public final KaLibrarySdkModuleImpl cachedKaSdkModule(@NotNull SdkId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (!this.isItSafeToCacheModules()) {
            return new KaLibrarySdkModuleImpl(this.project, id, this.creationData());
        }
        KaLibrarySdkModuleImpl kaLibrarySdkModuleImpl = this.sdkCache.computeIfAbsent(id, arg_0 -> K2IDEProjectStructureProviderCache.cachedKaSdkModule$lambda$5(arg_0 -> K2IDEProjectStructureProviderCache.cachedKaSdkModule$lambda$4(this, id, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)kaLibrarySdkModuleImpl, (String)"computeIfAbsent(...)");
        return kaLibrarySdkModuleImpl;
    }

    @NotNull
    public final KaSourceModule cachedKaSourceModule(@NotNull ModuleId id, @NotNull KaSourceModuleKind kind2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        if (!this.isItSafeToCacheModules()) {
            return new KaSourceModuleImpl(id, kind2, this.project, this.creationData());
        }
        ConcurrentHashMap<ModuleId, KaSourceModule> cache2 = this.moduleCacheForKind(kind2);
        KaSourceModule kaSourceModule = cache2.computeIfAbsent(id, arg_0 -> K2IDEProjectStructureProviderCache.cachedKaSourceModule$lambda$7(arg_0 -> K2IDEProjectStructureProviderCache.cachedKaSourceModule$lambda$6(id, kind2, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)kaSourceModule, (String)"computeIfAbsent(...)");
        return kaSourceModule;
    }

    private final KaEntityBasedModuleCreationData creationData() {
        return new KaEntityBasedModuleCreationData(this.isItSafeToCacheModules(), this.sourcesTracker.getModificationCount(), this.sdkAndLibrariesTracker.getModificationCount());
    }

    public final boolean isItSafeToCacheModules() {
        return !this.analysisMessageBus.hasUndeliveredEvents(KotlinModificationEvent.Companion.getTOPIC());
    }

    private final ConcurrentHashMap<ModuleId, KaSourceModule> moduleCacheForKind(KaSourceModuleKind kind2) {
        return switch (WhenMappings.$EnumSwitchMapping$0[kind2.ordinal()]) {
            case 1 -> this.productionSourceCache;
            case 2 -> this.testSourceCache;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public void dispose() {
    }

    private static final void lambda$1$lambda$0(K2IDEProjectStructureProviderCache this$0, KotlinModificationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        KotlinModificationEvent kotlinModificationEvent = event;
        if (Intrinsics.areEqual((Object)kotlinModificationEvent, (Object)KotlinGlobalModuleStateModificationEvent.INSTANCE)) {
            this$0.invalidateAllModuleCaches();
        } else if (kotlinModificationEvent instanceof KotlinModuleStateModificationEvent) {
            this$0.invalidateCaches(((KotlinModuleStateModificationEvent)event).getModule());
        } else if (kotlinModificationEvent instanceof KotlinGlobalSourceModuleStateModificationEvent) {
            this$0.invalidateSourceModuleCaches();
        } else if (!(kotlinModificationEvent instanceof KotlinCodeFragmentContextModificationEvent || Intrinsics.areEqual((Object)kotlinModificationEvent, (Object)KotlinGlobalSourceOutOfBlockModificationEvent.INSTANCE) || kotlinModificationEvent instanceof KotlinModuleOutOfBlockModificationEvent || Intrinsics.areEqual((Object)kotlinModificationEvent, (Object)KotlinGlobalScriptModuleStateModificationEvent.INSTANCE))) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final KaLibraryModuleImpl cachedKaLibraryModule$lambda$2(LibraryId $id, K2IDEProjectStructureProviderCache this$0, LibraryId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new KaLibraryModuleImpl($id, this$0.project, this$0.creationData());
    }

    private static final KaLibraryModuleImpl cachedKaLibraryModule$lambda$3(Function1 $tmp0, Object p0) {
        return (KaLibraryModuleImpl)$tmp0.invoke(p0);
    }

    private static final KaLibrarySdkModuleImpl cachedKaSdkModule$lambda$4(K2IDEProjectStructureProviderCache this$0, SdkId $id, SdkId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new KaLibrarySdkModuleImpl(this$0.project, $id, this$0.creationData());
    }

    private static final KaLibrarySdkModuleImpl cachedKaSdkModule$lambda$5(Function1 $tmp0, Object p0) {
        return (KaLibrarySdkModuleImpl)$tmp0.invoke(p0);
    }

    private static final KaSourceModule cachedKaSourceModule$lambda$6(ModuleId $id, KaSourceModuleKind $kind, K2IDEProjectStructureProviderCache this$0, ModuleId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new KaSourceModuleImpl($id, $kind, this$0.project, this$0.creationData());
    }

    private static final KaSourceModule cachedKaSourceModule$lambda$7(Function1 $tmp0, Object p0) {
        return (KaSourceModule)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/K2IDEProjectStructureProviderCache$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/K2IDEProjectStructureProviderCache;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.fir.project-structure"})
    @SourceDebugExtension(value={"SMAP\nK2IDEProjectStructureProviderCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2IDEProjectStructureProviderCache.kt\norg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/K2IDEProjectStructureProviderCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,180:1\n30#2,2:181\n*S KotlinDebug\n*F\n+ 1 K2IDEProjectStructureProviderCache.kt\norg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/K2IDEProjectStructureProviderCache$Companion\n*L\n177#1:181,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final K2IDEProjectStructureProviderCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<K2IDEProjectStructureProviderCache> serviceClass$iv = K2IDEProjectStructureProviderCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (K2IDEProjectStructureProviderCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KaSourceModuleKind.values().length];
            try {
                nArray[KaSourceModuleKind.PRODUCTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaSourceModuleKind.TEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

