/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0011\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u000289B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0016J6\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\"\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u000eH\u0016J\u0012\u0010'\u001a\u00020\u001b2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u001a\u0010*\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u000e2\b\u0010+\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010,\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000eH\u0016J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000eH\u0016J\u0018\u00101\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u000eH\u0016J.\u00103\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\"\u001a\u0004\u0018\u00010 H\u0016J\u0012\u00104\u001a\u00020\u001b2\b\u0010+\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u00105\u001a\u00020$H\u0002J\u001c\u00106\u001a\u00020$2\b\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u001c\u00107\u001a\u00020$2\b\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\"\u001a\u0004\u0018\u00010 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/CoroutineStateMachineVisitor;", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "Lcom/intellij/debugger/jdi/MethodBytecodeUtil$InstructionOffsetReader;", "method", "Lcom/sun/jdi/Method;", "resumeLocation", "Lcom/sun/jdi/Location;", "<init>", "(Lcom/sun/jdi/Method;Lcom/sun/jdi/Location;)V", "myState", "Lorg/jetbrains/kotlin/idea/debugger/core/CoroutineStateMachineVisitor$CurrentInsn;", "coroutineSuspendedState", "Lorg/jetbrains/kotlin/idea/debugger/core/CoroutineStateMachineVisitor$CoroutineSuspendedState;", "coroutineSuspendedLocalVarIndex", "", "currentByteCodeOffSet", "nextCallLabel", "Lorg/jetbrains/org/objectweb/asm/Label;", "firstReturnAfterSuspensionOffset", "getFirstReturnAfterSuspensionOffset", "()I", "setFirstReturnAfterSuspensionOffset", "(I)V", "nextCallOffset", "getNextCallOffset", "setNextCallOffset", "readBytecodeInstructionOffset", "", "offset", "visitMethodInsn", "opcodeAndSource", "owner", "", "name", "descriptor", "isInterface", "", "visitInsn", "opcode", "visitLdcInsn", "value", "", "visitJumpInsn", "label", "visitIntInsn", "operand", "visitIincInsn", "varIndex", "increment", "visitVarInsn", "var", "visitFieldInsn", "visitLabel", "reachedResumedLocation", "isGetCoroutineSuspended", "isSuspendFunction", "CurrentInsn", "CoroutineSuspendedState", "kotlin.jvm-debugger.core"})
final class CoroutineStateMachineVisitor
extends MethodNode
implements MethodBytecodeUtil.InstructionOffsetReader {
    @NotNull
    private final Location resumeLocation;
    @NotNull
    private CurrentInsn myState;
    @NotNull
    private CoroutineSuspendedState coroutineSuspendedState;
    private int coroutineSuspendedLocalVarIndex;
    private int currentByteCodeOffSet;
    @Nullable
    private Label nextCallLabel;
    private int firstReturnAfterSuspensionOffset;
    private int nextCallOffset;

    public CoroutineStateMachineVisitor(@NotNull Method method, @NotNull Location resumeLocation) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)resumeLocation, (String)"resumeLocation");
        super(589824, 1, method.name(), "", "(Ljava/lang/Object;)Ljava/lang/Object;", new String[0]);
        this.resumeLocation = resumeLocation;
        this.myState = CurrentInsn.NONE;
        this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
        this.coroutineSuspendedLocalVarIndex = -1;
        this.currentByteCodeOffSet = -1;
        this.firstReturnAfterSuspensionOffset = -1;
        this.nextCallOffset = -1;
    }

    public final int getFirstReturnAfterSuspensionOffset() {
        return this.firstReturnAfterSuspensionOffset;
    }

    public final void setFirstReturnAfterSuspensionOffset(int n) {
        this.firstReturnAfterSuspensionOffset = n;
    }

    public final int getNextCallOffset() {
        return this.nextCallOffset;
    }

    public final void setNextCallOffset(int n) {
        this.nextCallOffset = n;
    }

    public void readBytecodeInstructionOffset(int offset) {
        this.currentByteCodeOffSet = offset;
    }

    public void visitMethodInsn(int opcodeAndSource, @Nullable String owner, @Nullable String name2, @Nullable String descriptor2, boolean isInterface) {
        super.visitMethodInsn(opcodeAndSource, owner, name2, descriptor2, isInterface);
        if (this.coroutineSuspendedState == CoroutineSuspendedState.NONE && this.isGetCoroutineSuspended(name2, owner)) {
            this.coroutineSuspendedState = CoroutineSuspendedState.INVOKE_GET_COROUTINE_SUSPENDED;
        } else if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        } else if (this.myState != CurrentInsn.SUSPEND_METHOD_ARGS || this.isSuspendFunction(name2, descriptor2)) {
            if (this.myState == CurrentInsn.PUTFIELD_CONTINUATION_LABEL && this.isSuspendFunction(name2, descriptor2)) {
                this.myState = CurrentInsn.INVOKE_SUSPEND_METHOD;
            } else {
                this.myState = CurrentInsn.NONE;
                this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
            }
        }
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        } else if (this.myState != CurrentInsn.SUSPEND_METHOD_ARGS) {
            if (this.myState == CurrentInsn.INVOKE_SUSPEND_METHOD && opcode == 89) {
                this.myState = CurrentInsn.DUP;
            } else if (this.myState == CurrentInsn.ALOAD_SUSPEND_RESULT_FOR_SUSPEND_RETURN && opcode == 176) {
                this.firstReturnAfterSuspensionOffset = this.currentByteCodeOffSet;
            } else {
                this.myState = CurrentInsn.NONE;
                this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
            }
        }
    }

    public void visitLdcInsn(@Nullable Object value) {
        super.visitLdcInsn(value);
        if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        } else if (this.myState != CurrentInsn.SUSPEND_METHOD_ARGS) {
            this.myState = CurrentInsn.NONE;
            this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
        }
    }

    public void visitJumpInsn(int opcode, @Nullable Label label2) {
        super.visitJumpInsn(opcode, label2);
        if (this.myState == CurrentInsn.ALOAD_SUSPEND_RESULT_BEFORE_COMPARE && opcode == 166) {
            this.myState = CurrentInsn.IF_ACMPNE;
            this.nextCallLabel = label2;
        } else {
            this.myState = CurrentInsn.NONE;
            this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        } else if (this.myState != CurrentInsn.SUSPEND_METHOD_ARGS) {
            this.myState = CurrentInsn.NONE;
            this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
        }
    }

    public void visitIincInsn(int varIndex, int increment) {
        super.visitIincInsn(varIndex, increment);
        if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        } else if (this.myState != CurrentInsn.SUSPEND_METHOD_ARGS) {
            this.myState = CurrentInsn.NONE;
            this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
        }
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        if (this.coroutineSuspendedState == CoroutineSuspendedState.INVOKE_GET_COROUTINE_SUSPENDED && opcode == 58) {
            this.coroutineSuspendedLocalVarIndex = var;
        } else if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        } else if (this.myState != CurrentInsn.SUSPEND_METHOD_ARGS) {
            if (this.myState == CurrentInsn.DUP && opcode == 25 && var == this.coroutineSuspendedLocalVarIndex) {
                this.myState = CurrentInsn.ALOAD_SUSPEND_RESULT_BEFORE_COMPARE;
            } else if (this.myState == CurrentInsn.IF_ACMPNE && opcode == 25 && var == this.coroutineSuspendedLocalVarIndex) {
                this.myState = CurrentInsn.ALOAD_SUSPEND_RESULT_FOR_SUSPEND_RETURN;
            } else {
                this.myState = CurrentInsn.NONE;
                this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
            }
        }
    }

    public void visitFieldInsn(int opcode, @Nullable String owner, @Nullable String name2, @Nullable String descriptor2) {
        super.visitFieldInsn(opcode, owner, name2, descriptor2);
        if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        } else if (this.myState == CurrentInsn.SUSPEND_METHOD_ARGS && opcode == 181 && DebuggerUtil.access$checkContinuationLabelField(this.resumeLocation, name2, descriptor2, owner)) {
            this.myState = CurrentInsn.PUTFIELD_CONTINUATION_LABEL;
        } else if (this.myState != CurrentInsn.SUSPEND_METHOD_ARGS) {
            this.myState = CurrentInsn.NONE;
            this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
        }
    }

    public void visitLabel(@Nullable Label label2) {
        super.visitLabel(label2);
        if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        }
        if (Intrinsics.areEqual((Object)label2, (Object)this.nextCallLabel)) {
            this.nextCallOffset = this.currentByteCodeOffSet;
        }
    }

    private final boolean reachedResumedLocation() {
        return (long)this.currentByteCodeOffSet == this.resumeLocation.codeIndex();
    }

    private final boolean isGetCoroutineSuspended(String name2, String owner) {
        if (name2 == null || owner == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)name2, (Object)"getCOROUTINE_SUSPENDED") && Intrinsics.areEqual((Object)owner, (Object)"kotlin/coroutines/intrinsics/IntrinsicsKt");
    }

    private final boolean isSuspendFunction(String name2, String descriptor2) {
        if (name2 == null || descriptor2 == null) {
            return false;
        }
        CharSequence charSequence = descriptor2;
        String string = CoroutineUtilsKt.getCONTINUATION_TYPE().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)name2, (Object)"<init>");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/CoroutineStateMachineVisitor$CoroutineSuspendedState;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "INVOKE_GET_COROUTINE_SUSPENDED", "kotlin.jvm-debugger.core"})
    private static final class CoroutineSuspendedState
    extends Enum<CoroutineSuspendedState> {
        public static final /* enum */ CoroutineSuspendedState NONE = new CoroutineSuspendedState();
        public static final /* enum */ CoroutineSuspendedState INVOKE_GET_COROUTINE_SUSPENDED = new CoroutineSuspendedState();
        private static final /* synthetic */ CoroutineSuspendedState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CoroutineSuspendedState[] values() {
            return (CoroutineSuspendedState[])$VALUES.clone();
        }

        public static CoroutineSuspendedState valueOf(String value) {
            return Enum.valueOf(CoroutineSuspendedState.class, value);
        }

        @NotNull
        public static EnumEntries<CoroutineSuspendedState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = coroutineSuspendedStateArray = new CoroutineSuspendedState[]{CoroutineSuspendedState.NONE, CoroutineSuspendedState.INVOKE_GET_COROUTINE_SUSPENDED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/CoroutineStateMachineVisitor$CurrentInsn;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "SUSPEND_METHOD_ARGS", "PUTFIELD_CONTINUATION_LABEL", "INVOKE_SUSPEND_METHOD", "DUP", "ALOAD_SUSPEND_RESULT_BEFORE_COMPARE", "IF_ACMPNE", "ALOAD_SUSPEND_RESULT_FOR_SUSPEND_RETURN", "kotlin.jvm-debugger.core"})
    private static final class CurrentInsn
    extends Enum<CurrentInsn> {
        public static final /* enum */ CurrentInsn NONE = new CurrentInsn();
        public static final /* enum */ CurrentInsn SUSPEND_METHOD_ARGS = new CurrentInsn();
        public static final /* enum */ CurrentInsn PUTFIELD_CONTINUATION_LABEL = new CurrentInsn();
        public static final /* enum */ CurrentInsn INVOKE_SUSPEND_METHOD = new CurrentInsn();
        public static final /* enum */ CurrentInsn DUP = new CurrentInsn();
        public static final /* enum */ CurrentInsn ALOAD_SUSPEND_RESULT_BEFORE_COMPARE = new CurrentInsn();
        public static final /* enum */ CurrentInsn IF_ACMPNE = new CurrentInsn();
        public static final /* enum */ CurrentInsn ALOAD_SUSPEND_RESULT_FOR_SUSPEND_RETURN = new CurrentInsn();
        private static final /* synthetic */ CurrentInsn[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CurrentInsn[] values() {
            return (CurrentInsn[])$VALUES.clone();
        }

        public static CurrentInsn valueOf(String value) {
            return Enum.valueOf(CurrentInsn.class, value);
        }

        @NotNull
        public static EnumEntries<CurrentInsn> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = currentInsnArray = new CurrentInsn[]{CurrentInsn.NONE, CurrentInsn.SUSPEND_METHOD_ARGS, CurrentInsn.PUTFIELD_CONTINUATION_LABEL, CurrentInsn.INVOKE_SUSPEND_METHOD, CurrentInsn.DUP, CurrentInsn.ALOAD_SUSPEND_RESULT_BEFORE_COMPARE, CurrentInsn.IF_ACMPNE, CurrentInsn.ALOAD_SUSPEND_RESULT_FOR_SUSPEND_RETURN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

