/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.ConvertParameterToReceiverIntention;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMutableMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\u0006*\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertParameterToReceiverIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "<init>", "()V", "isApplicableTo", "", "element", "caretOffset", "", "overridesJavaMethod", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "configureChangeSignature", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureConfiguration;", "parameterIndex", "startInWriteAction", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertParameterToReceiverIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertParameterToReceiverIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertParameterToReceiverIntention\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,64:1\n213#2:65\n*S KotlinDebug\n*F\n+ 1 ConvertParameterToReceiverIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertParameterToReceiverIntention\n*L\n58#1:65\n*E\n"})
public final class ConvertParameterToReceiverIntention
extends SelfTargetingIntention<KtParameter> {
    public ConvertParameterToReceiverIntention() {
        super(KtParameter.class, KotlinBundle.lazyMessage((String)"convert.parameter.to.receiver", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtParameter element, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getNameIdentifier();
        if (psiElement == null) {
            return false;
        }
        PsiElement identifier = psiElement;
        if (!identifier.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        if (element.isVarArg()) {
            return false;
        }
        KtDeclarationWithBody ktDeclarationWithBody = element.getOwnerFunction();
        KtNamedFunction ktNamedFunction = ktDeclarationWithBody instanceof KtNamedFunction ? (KtNamedFunction)ktDeclarationWithBody : null;
        if (ktNamedFunction == null) {
            return false;
        }
        KtNamedFunction function = ktNamedFunction;
        if (function.getReceiverTypeReference() != null) {
            return false;
        }
        return !this.overridesJavaMethod(function);
    }

    private final boolean overridesJavaMethod(KtNamedFunction $this$overridesJavaMethod) {
        if (!$this$overridesJavaMethod.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default($this$overridesJavaMethod, null, 1, null);
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        Collection collection = functionDescriptor2.getOriginal().getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOverriddenDescriptors(...)");
        FunctionDescriptor functionDescriptor3 = (FunctionDescriptor)CollectionsKt.firstOrNull((Iterable)collection);
        if (functionDescriptor3 == null) {
            return false;
        }
        FunctionDescriptor baseDescriptor = functionDescriptor3;
        return baseDescriptor instanceof JavaCallableMemberDescriptor;
    }

    private final KotlinChangeSignatureConfiguration configureChangeSignature(int parameterIndex) {
        return new KotlinChangeSignatureConfiguration(parameterIndex){
            final /* synthetic */ int $parameterIndex;
            {
                this.$parameterIndex = $parameterIndex;
            }

            public KotlinMethodDescriptor configure(KotlinMethodDescriptor originalDescriptor) {
                Intrinsics.checkNotNullParameter((Object)originalDescriptor, (String)"originalDescriptor");
                return KotlinChangeSignatureKt.modify(originalDescriptor, (Function1<? super KotlinMutableMethodDescriptor, Unit>)((Function1)arg_0 -> configureChangeSignature.1.configure$lambda$0(originalDescriptor, this.$parameterIndex, arg_0)));
            }

            public boolean isPerformSilently(Collection<? extends PsiElement> affectedFunctions) {
                Intrinsics.checkNotNullParameter(affectedFunctions, (String)"affectedFunctions");
                return true;
            }

            private static final Unit configure$lambda$0(KotlinMethodDescriptor $originalDescriptor, int $parameterIndex, KotlinMutableMethodDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setReceiver((KotlinParameterInfo)$originalDescriptor.getParameters().get($parameterIndex));
                return Unit.INSTANCE;
            }
        };
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtParameter element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (ktNamedFunction == null) {
            return;
        }
        KtNamedFunction function = ktNamedFunction;
        int parameterIndex = function.getValueParameters().indexOf(element);
        DeclarationDescriptor declarationDescriptor = KotlinRefactoringUtilKt.resolveToExpectedDescriptorIfPossible((KtDeclaration)function);
        FunctionDescriptor functionDescriptor = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor descriptor2 = functionDescriptor;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KotlinChangeSignatureKt.runChangeSignature(project, editor, (CallableDescriptor)descriptor2, this.configureChangeSignature(parameterIndex), (PsiElement)element, this.getText());
    }
}

