/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageEditorAnnotator;
import com.intellij.coverage.CoverageEditorAnnotatorImpl;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageLineMarkerRenderer;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.util.Function;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoverageEngine {
    public static final ExtensionPointName<CoverageEngine> EP_NAME = ExtensionPointName.create((String)"com.intellij.coverageEngine");

    @NlsActions.ActionText
    public abstract String getPresentableText();

    public abstract boolean isApplicableTo(@NotNull RunConfigurationBase<?> var1);

    @NotNull
    public abstract CoverageEnabledConfiguration createCoverageEnabledConfiguration(@NotNull RunConfigurationBase<?> var1);

    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull String name, @NotNull Project project, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp) {
        if (name == null) {
            CoverageEngine.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CoverageEngine.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            CoverageEngine.$$$reportNull$$$0(2);
        }
        if (fileProvider == null) {
            CoverageEngine.$$$reportNull$$$0(3);
        }
        return this.createCoverageSuite(runner, name, fileProvider, null, timestamp, null, false, false, false, project);
    }

    @ApiStatus.NonExtendable
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageEnabledConfiguration config) {
        CoverageRunner runner;
        if (config == null) {
            CoverageEngine.$$$reportNull$$$0(4);
        }
        if ((runner = config.getCoverageRunner()) == null) {
            return null;
        }
        return this.createCoverageSuite(config.createSuiteName(), config.getConfiguration().getProject(), runner, config.createFileProvider(), config.createTimestamp(), config);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.OverrideOnly
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull String name, @NotNull Project project, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp, @NotNull CoverageEnabledConfiguration coverageEnabledConfiguration) {
        void config;
        if (name == null) {
            CoverageEngine.$$$reportNull$$$0(5);
        }
        if (project == null) {
            CoverageEngine.$$$reportNull$$$0(6);
        }
        if (runner == null) {
            CoverageEngine.$$$reportNull$$$0(7);
        }
        if (fileProvider == null) {
            CoverageEngine.$$$reportNull$$$0(8);
        }
        if (coverageEnabledConfiguration == null) {
            CoverageEngine.$$$reportNull$$$0(9);
        }
        return this.createCoverageSuite(runner, name, fileProvider, (CoverageEnabledConfiguration)config);
    }

    @Nullable
    public abstract CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner var1);

    @NotNull
    public abstract CoverageAnnotator getCoverageAnnotator(Project var1);

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CoverageEngine.$$$reportNull$$$0(10);
        }
        return true;
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        if (psiFile == null) {
            CoverageEngine.$$$reportNull$$$0(11);
        }
        if (suite == null) {
            CoverageEngine.$$$reportNull$$$0(12);
        }
        return true;
    }

    @ApiStatus.Internal
    @NotNull
    public Set<File> getCorrespondingOutputFiles(@NotNull PsiFile srcFile, @Nullable Module module, @NotNull CoverageSuitesBundle suite) {
        VirtualFile virtualFile;
        if (srcFile == null) {
            CoverageEngine.$$$reportNull$$$0(13);
        }
        if (suite == null) {
            CoverageEngine.$$$reportNull$$$0(14);
        }
        Set<File> set = (virtualFile = srcFile.getVirtualFile()) == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
        if (set == null) {
            CoverageEngine.$$$reportNull$$$0(15);
        }
        return set;
    }

    @ApiStatus.Internal
    public boolean recompileProjectAndRerunAction(@NotNull Module module, @NotNull CoverageSuitesBundle suite, @NotNull Runnable chooseSuiteAction) {
        if (module == null) {
            CoverageEngine.$$$reportNull$$$0(16);
        }
        if (suite == null) {
            CoverageEngine.$$$reportNull$$$0(17);
        }
        if (chooseSuiteAction == null) {
            CoverageEngine.$$$reportNull$$$0(18);
        }
        return false;
    }

    @ApiStatus.Internal
    @Nullable
    protected String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            CoverageEngine.$$$reportNull$$$0(19);
        }
        if (sourceFile == null) {
            CoverageEngine.$$$reportNull$$$0(20);
        }
        return null;
    }

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        if (sourceFile == null) {
            CoverageEngine.$$$reportNull$$$0(21);
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            CoverageEngine.$$$reportNull$$$0(22);
        }
        return set;
    }

    @ApiStatus.Internal
    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        if (qualifiedName == null) {
            CoverageEngine.$$$reportNull$$$0(23);
        }
        if (outputFile == null) {
            CoverageEngine.$$$reportNull$$$0(24);
        }
        if (sourceFile == null) {
            CoverageEngine.$$$reportNull$$$0(25);
        }
        if (suite == null) {
            CoverageEngine.$$$reportNull$$$0(26);
        }
        return false;
    }

    @ApiStatus.Internal
    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite) {
        if (classFile == null) {
            CoverageEngine.$$$reportNull$$$0(27);
        }
        if (suite == null) {
            CoverageEngine.$$$reportNull$$$0(28);
        }
        return null;
    }

    @ApiStatus.Internal
    public String generateBriefReport(@NotNull Editor editor, @NotNull PsiFile psiFile, int lineNumber, int startOffset, int endOffset, @Nullable LineData lineData) {
        if (editor == null) {
            CoverageEngine.$$$reportNull$$$0(29);
        }
        if (psiFile == null) {
            CoverageEngine.$$$reportNull$$$0(30);
        }
        int hits = lineData == null ? 0 : lineData.getHits();
        return CoverageBundle.message("hits.title", hits);
    }

    @ApiStatus.Internal
    public String generateBriefReport(@NotNull CoverageSuitesBundle bundle, @NotNull Editor editor, @NotNull PsiFile psiFile, @NotNull TextRange range, @Nullable LineData lineData) {
        if (bundle == null) {
            CoverageEngine.$$$reportNull$$$0(31);
        }
        if (editor == null) {
            CoverageEngine.$$$reportNull$$$0(32);
        }
        if (psiFile == null) {
            CoverageEngine.$$$reportNull$$$0(33);
        }
        if (range == null) {
            CoverageEngine.$$$reportNull$$$0(34);
        }
        int lineNumber = editor.getDocument().getLineNumber(range.getStartOffset());
        return this.generateBriefReport(editor, psiFile, lineNumber, range.getStartOffset(), range.getEndOffset(), lineData);
    }

    public boolean isReportGenerationAvailable(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            CoverageEngine.$$$reportNull$$$0(35);
        }
        if (dataContext == null) {
            CoverageEngine.$$$reportNull$$$0(36);
        }
        if (currentSuite == null) {
            CoverageEngine.$$$reportNull$$$0(37);
        }
        return false;
    }

    public void generateReport(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            CoverageEngine.$$$reportNull$$$0(38);
        }
        if (dataContext == null) {
            CoverageEngine.$$$reportNull$$$0(39);
        }
        if (currentSuite == null) {
            CoverageEngine.$$$reportNull$$$0(40);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public ExportToHTMLDialog createGenerateReportDialog(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        String path;
        VirtualFile file;
        if (project == null) {
            CoverageEngine.$$$reportNull$$$0(41);
        }
        if (dataContext == null) {
            CoverageEngine.$$$reportNull$$$0(42);
        }
        if (currentSuite == null) {
            CoverageEngine.$$$reportNull$$$0(43);
        }
        ExportToHTMLDialog dialog = new ExportToHTMLDialog(project, true);
        dialog.setTitle(CoverageBundle.message("generate.coverage.report.for", currentSuite.getPresentableName()));
        ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        if (StringUtil.isEmpty((String)settings.OUTPUT_DIRECTORY) && (file = ProjectUtil.guessProjectDir((Project)project)) != null && (path = file.getCanonicalPath()) != null) {
            settings.OUTPUT_DIRECTORY = FileUtil.toSystemDependentName((String)path) + File.separator + "htmlReport";
        }
        ExportToHTMLDialog exportToHTMLDialog = dialog;
        if (exportToHTMLDialog == null) {
            CoverageEngine.$$$reportNull$$$0(44);
        }
        return exportToHTMLDialog;
    }

    @ApiStatus.Internal
    public boolean coverageProjectViewStatisticsApplicableTo(VirtualFile fileOrDir) {
        return false;
    }

    @ApiStatus.Internal
    protected Object @NotNull [] postProcessExecutableLines(Object @NotNull [] lines, @NotNull Editor editor) {
        if (editor == null) {
            CoverageEngine.$$$reportNull$$$0(45);
        }
        if (lines == null) {
            CoverageEngine.$$$reportNull$$$0(46);
        }
        if (lines == null) {
            CoverageEngine.$$$reportNull$$$0(47);
        }
        return lines;
    }

    @ApiStatus.Internal
    public CoverageLineMarkerRenderer getLineMarkerRenderer(int lineNumber, @Nullable String className, @NotNull TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        if (lines == null) {
            CoverageEngine.$$$reportNull$$$0(48);
        }
        if (coverageSuite == null) {
            CoverageEngine.$$$reportNull$$$0(49);
        }
        return CoverageLineMarkerRenderer.getRenderer(lineNumber, className, lines, coverageByTestApplicable, coverageSuite, newToOldConverter, oldToNewConverter, subCoverageActive);
    }

    @ApiStatus.Internal
    protected boolean isGeneratedCode(Project project, String qualifiedName, Object lineData) {
        return false;
    }

    @ApiStatus.Internal
    @NotNull
    public CoverageEditorAnnotator createSrcFileAnnotator(PsiFile file, Editor editor) {
        return new CoverageEditorAnnotatorImpl(file, editor);
    }

    @NlsContexts.TabTitle
    @ApiStatus.Internal
    public static String getEditorTitle() {
        return CoverageBundle.message("coverage.tab.title", new Object[0]);
    }

    @Deprecated
    public CoverageViewExtension createCoverageViewExtension(Project project, CoverageSuitesBundle suiteBundle, CoverageViewManager.StateBean stateBean) {
        return this.createCoverageViewExtension(project, suiteBundle);
    }

    public CoverageViewExtension createCoverageViewExtension(Project project, CoverageSuitesBundle suiteBundle) {
        return null;
    }

    public boolean isInLibraryClasses(Project project, VirtualFile file) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return (Boolean)ReadAction.compute(() -> projectFileIndex.isInLibraryClasses(file) && !projectFileIndex.isInSource(file));
    }

    @ApiStatus.Internal
    protected boolean isInLibrarySource(Project project, VirtualFile file) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return (Boolean)ReadAction.compute(() -> projectFileIndex.isInLibrarySource(file));
    }

    @ApiStatus.Internal
    public boolean canHavePerTestCoverage(@NotNull RunConfigurationBase<?> conf) {
        if (conf == null) {
            CoverageEngine.$$$reportNull$$$0(50);
        }
        return false;
    }

    @ApiStatus.Internal
    public Set<String> getTestsForLine(Project project, CoverageSuitesBundle bundle, String classFQName, int lineNumber) {
        return Collections.emptySet();
    }

    @ApiStatus.Internal
    public boolean wasTestDataCollected(Project project, CoverageSuitesBundle bundle) {
        return false;
    }

    @ApiStatus.Internal
    public List<PsiElement> findTestsByNames(String @NotNull [] testNames, @NotNull Project project) {
        if (project == null) {
            CoverageEngine.$$$reportNull$$$0(51);
        }
        if (testNames == null) {
            CoverageEngine.$$$reportNull$$$0(52);
        }
        return Collections.emptyList();
    }

    @ApiStatus.Internal
    @Nullable
    public String getTestMethodName(@NotNull PsiElement element, @NotNull AbstractTestProxy testProxy) {
        if (element == null) {
            CoverageEngine.$$$reportNull$$$0(53);
        }
        if (testProxy == null) {
            CoverageEngine.$$$reportNull$$$0(54);
        }
        return null;
    }

    @ApiStatus.Internal
    public void collectTestLines(List<String> sanitizedTestNames, CoverageSuite suite, Map<String, Set<Integer>> trace) {
    }

    @ApiStatus.Internal
    protected void deleteAssociatedTraces(CoverageSuite suite) {
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(forRemoval=true)
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, String @Nullable [] filters, long lastCoverageTimeStamp, @Nullable String suiteToMerge, boolean coverageByTestEnabled, boolean branchCoverage, boolean bl) {
        void trackTestFolders;
        if (covRunner == null) {
            CoverageEngine.$$$reportNull$$$0(55);
        }
        if (name == null) {
            CoverageEngine.$$$reportNull$$$0(56);
        }
        if (coverageDataFileProvider == null) {
            CoverageEngine.$$$reportNull$$$0(57);
        }
        return this.createCoverageSuite(covRunner, name, coverageDataFileProvider, filters, lastCoverageTimeStamp, suiteToMerge, coverageByTestEnabled, branchCoverage, (boolean)trackTestFolders, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner runner, @NotNull String name, @NotNull CoverageFileProvider fileProvider, String @Nullable [] filters, long lastCoverageTimeStamp, @Nullable String suiteToMerge, boolean coverageByTestEnabled, boolean branchCoverage, boolean trackTestFolders, @Nullable Project project) {
        void project2;
        if (runner == null) {
            CoverageEngine.$$$reportNull$$$0(58);
        }
        if (name == null) {
            CoverageEngine.$$$reportNull$$$0(59);
        }
        if (fileProvider == null) {
            CoverageEngine.$$$reportNull$$$0(60);
        }
        AbstractMethodError error = new AbstractMethodError("Please override CoverageEngine#createCoverageSuite(String, Project, CoverageRunner, CoverageFileProvider, long) method");
        if (project2 == null || CoverageEngine.isCalledByDelegationFromThis(error)) {
            throw error;
        }
        Logger.getInstance(CoverageEngine.class).error((Throwable)error);
        return this.createCoverageSuite(name, (Project)project2, runner, fileProvider, lastCoverageTimeStamp);
    }

    @Deprecated
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner runner, @NotNull String name, @NotNull CoverageFileProvider fileProvider, @NotNull CoverageEnabledConfiguration config) {
        AbstractMethodError error;
        if (runner == null) {
            CoverageEngine.$$$reportNull$$$0(61);
        }
        if (name == null) {
            CoverageEngine.$$$reportNull$$$0(62);
        }
        if (fileProvider == null) {
            CoverageEngine.$$$reportNull$$$0(63);
        }
        if (config == null) {
            CoverageEngine.$$$reportNull$$$0(64);
        }
        if (CoverageEngine.isCalledByDelegationFromThis(error = new AbstractMethodError("Please override CoverageEngine#createCoverageSuite(String, Project, CoverageRunner, CoverageFileProvider, long, CoverageEnabledConfiguration) method"))) {
            throw error;
        }
        Logger.getInstance(CoverageEngine.class).error((Throwable)error);
        return this.createCoverageSuite(name, config.getConfiguration().getProject(), runner, fileProvider, config.createTimestamp(), config);
    }

    private static boolean isCalledByDelegationFromThis(Throwable e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace.length < 2) {
            return false;
        }
        StackTraceElement element = stackTrace[1];
        return element.getClassName().equals(CoverageEngine.class.getName()) && element.getMethodName().equals("createCoverageSuite");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 22, 44, 47 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 6: 
            case 35: 
            case 38: 
            case 41: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: 
            case 8: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProvider";
                break;
            }
            case 4: 
            case 9: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 10: 
            case 11: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 15: 
            case 22: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageEngine";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooseSuiteAction";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 20: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 29: 
            case 32: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 36: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 37: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "covRunner";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageDataFileProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageEngine";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondingOutputFiles";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNames";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerateReportDialog";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "postProcessExecutableLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageSuite";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "coverageEditorHighlightingApplicableTo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "acceptedByFilters";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingOutputFiles";
                break;
            }
            case 15: 
            case 22: 
            case 44: 
            case 47: {
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "recompileProjectAndRerunAction";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNames";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "includeUntouchedFileInCoverage";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectSrcLinesForUntouchedFile";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "generateBriefReport";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isReportGenerationAvailable";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "generateReport";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createGenerateReportDialog";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "postProcessExecutableLines";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerRenderer";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "canHavePerTestCoverage";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findTestsByNames";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethodName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 22, 44, 47 -> new IllegalStateException(string);
        };
    }
}

