/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers;

import java.util.List;
import java.util.Objects;
import net.loomchild.segment.srx.SrxDocument;
import org.languagetool.Language;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.SrxTools;

public class SRXSentenceTokenizer
implements SentenceTokenizer {
    private final SrxDocument srxDocument;
    private final Language language;
    private String parCode;

    public SRXSentenceTokenizer(Language language) {
        this(language, "/segment.srx");
    }

    public SRXSentenceTokenizer(Language language, String srxInClassPath) {
        this.language = Objects.requireNonNull(language);
        this.srxDocument = SrxTools.createSrxDocument(srxInClassPath);
        this.setSingleLineBreaksMarksParagraph(false);
    }

    @Override
    public final List<String> tokenize(String text) {
        return SrxTools.tokenize(text, this.srxDocument, this.language.getShortCode() + this.parCode);
    }

    @Override
    public final boolean singleLineBreaksMarksPara() {
        return "_one".equals(this.parCode);
    }

    @Override
    public final void setSingleLineBreaksMarksParagraph(boolean lineBreakParagraphs) {
        this.parCode = lineBreakParagraphs ? "_one" : "_two";
    }
}

