/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventResult;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class AfterSuiteEventProcessor
extends AbstractTestEventProcessor {
    public AfterSuiteEventProcessor(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    protected boolean isSuite() {
        return true;
    }

    @Override
    public void process(@NotNull ExternalSystemProgressEvent<? extends TestOperationDescriptor> testEvent) {
        if (testEvent == null) {
            AfterSuiteEventProcessor.$$$reportNull$$$0(0);
        }
        ExternalSystemFinishEvent finishEvent = (ExternalSystemFinishEvent)testEvent;
        String testId = testEvent.getEventId();
        TestEventResult result = TestEventResult.fromOperationResult(finishEvent.getOperationResult());
        this.doProcess(testId, result);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        if (eventXml == null) {
            AfterSuiteEventProcessor.$$$reportNull$$$0(1);
        }
        String testId = eventXml.getTestId();
        TestEventResult result = TestEventResult.fromValue(eventXml.getTestEventResultType());
        this.doProcess(testId, result);
    }

    private void doProcess(String testId, TestEventResult result) {
        SMTestProxy testProxy = this.findTestProxy(testId);
        if (testProxy == null) {
            return;
        }
        if (testProxy != this.getResultsViewer().getTestsRootNode()) {
            if (testProxy instanceof GradleSMTestProxy) {
                TestEventResult lastResult = ((GradleSMTestProxy)testProxy).getLastResult();
                if (lastResult == TestEventResult.FAILURE) {
                    result = TestEventResult.FAILURE;
                }
                ((GradleSMTestProxy)testProxy).setLastResult(result);
            }
            switch (result) {
                case SUCCESS: {
                    testProxy.setFinished();
                    break;
                }
                case FAILURE: {
                    testProxy.setTestFailed("", null, false);
                    break;
                }
                case SKIPPED: {
                    testProxy.setTestIgnored(null, null);
                    break;
                }
            }
            this.getResultsViewer().onSuiteFinished(testProxy);
            this.getExecutionConsole().getEventPublisher().onSuiteFinished(testProxy);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "testEvent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "eventXml";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/execution/test/runner/events/AfterSuiteEventProcessor";
        objectArray[2] = "process";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

