/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.TaskExecutor;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.hnsw.HnswBuilder;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.util.hnsw.HnswGraphSearcher;
import org.apache.lucene.util.hnsw.HnswLock;
import org.apache.lucene.util.hnsw.NeighborArray;
import org.apache.lucene.util.hnsw.NeighborQueue;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;

public class HnswConcurrentMergeBuilder
implements HnswBuilder {
    private static final int DEFAULT_BATCH_SIZE = 2048;
    private final TaskExecutor taskExecutor;
    private final ConcurrentMergeWorker[] workers;
    private final HnswLock hnswLock;
    private InfoStream infoStream = InfoStream.getDefault();
    private boolean frozen;

    public HnswConcurrentMergeBuilder(TaskExecutor taskExecutor, int numWorker, RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth, OnHeapHnswGraph hnsw, BitSet initializedNodes) throws IOException {
        this.taskExecutor = taskExecutor;
        AtomicInteger workProgress = new AtomicInteger(0);
        this.workers = new ConcurrentMergeWorker[numWorker];
        this.hnswLock = new HnswLock(hnsw);
        for (int i = 0; i < numWorker; ++i) {
            this.workers[i] = new ConcurrentMergeWorker(scorerSupplier.copy(), M, beamWidth, HnswGraphBuilder.randSeed, hnsw, this.hnswLock, initializedNodes, workProgress);
        }
    }

    @Override
    public OnHeapHnswGraph build(int maxOrd) throws IOException {
        if (this.infoStream.isEnabled("HNSW")) {
            this.infoStream.message("HNSW", "build graph from " + maxOrd + " vectors, with " + this.workers.length + " workers");
        }
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < this.workers.length) {
            int finalI = i++;
            futures.add(() -> {
                this.workers[finalI].run(maxOrd);
                return null;
            });
        }
        this.taskExecutor.invokeAll(futures);
        this.finish();
        this.frozen = true;
        return this.workers[0].getCompletedGraph();
    }

    @Override
    public void addGraphNode(int node) throws IOException {
        throw new UnsupportedOperationException("This builder is for merge only");
    }

    @Override
    public void setInfoStream(InfoStream infoStream) {
        this.infoStream = infoStream;
        for (ConcurrentMergeWorker worker : this.workers) {
            worker.setInfoStream(infoStream);
        }
    }

    @Override
    public OnHeapHnswGraph getCompletedGraph() throws IOException {
        if (!this.frozen) {
            this.finish();
            this.frozen = true;
        }
        return this.getGraph();
    }

    private void finish() throws IOException {
        this.workers[0].finish();
    }

    @Override
    public OnHeapHnswGraph getGraph() {
        return this.workers[0].getGraph();
    }

    void setBatchSize(int newSize) {
        for (ConcurrentMergeWorker worker : this.workers) {
            worker.batchSize = newSize;
        }
    }

    private static class MergeSearcher
    extends HnswGraphSearcher {
        private final HnswLock hnswLock;
        private int[] nodeBuffer;
        private int upto;
        private int size;

        private MergeSearcher(NeighborQueue candidates, HnswLock hnswLock, BitSet visited) {
            super(candidates, visited);
            this.hnswLock = hnswLock;
        }

        @Override
        void graphSeek(HnswGraph graph, int level, int targetNode) {
            try (HnswLock.LockedRow rowLock = this.hnswLock.read(level, targetNode);){
                NeighborArray neighborArray = rowLock.row;
                if (this.nodeBuffer == null || this.nodeBuffer.length < neighborArray.size()) {
                    this.nodeBuffer = new int[neighborArray.size()];
                }
                this.size = neighborArray.size();
                if (this.size >= 0) {
                    System.arraycopy(neighborArray.nodes(), 0, this.nodeBuffer, 0, this.size);
                }
            }
            this.upto = -1;
        }

        @Override
        int graphNextNeighbor(HnswGraph graph) {
            if (++this.upto < this.size) {
                return this.nodeBuffer[this.upto];
            }
            return Integer.MAX_VALUE;
        }
    }

    private static final class ConcurrentMergeWorker
    extends HnswGraphBuilder {
        private final AtomicInteger workProgress;
        private final BitSet initializedNodes;
        private int batchSize = 2048;

        private ConcurrentMergeWorker(RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth, long seed, OnHeapHnswGraph hnsw, HnswLock hnswLock, BitSet initializedNodes, AtomicInteger workProgress) throws IOException {
            super(scorerSupplier, M, beamWidth, seed, hnsw, hnswLock, new MergeSearcher(new NeighborQueue(beamWidth, true), hnswLock, new FixedBitSet(hnsw.maxNodeId() + 1)));
            this.workProgress = workProgress;
            this.initializedNodes = initializedNodes;
        }

        private void run(int maxOrd) throws IOException {
            int start = this.getStartPos(maxOrd);
            while (start != -1) {
                int end = Math.min(maxOrd, start + this.batchSize);
                this.addVectors(start, end);
                start = this.getStartPos(maxOrd);
            }
        }

        private int getStartPos(int maxOrd) {
            int start = this.workProgress.getAndAdd(this.batchSize);
            if (start < maxOrd) {
                return start;
            }
            return -1;
        }

        @Override
        public void addGraphNode(int node) throws IOException {
            if (this.initializedNodes != null && this.initializedNodes.get(node)) {
                return;
            }
            super.addGraphNode(node);
        }
    }
}

