/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.Objects;
import java.util.function.Predicate;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.presentation.PredicateDescription;

public class ShouldMatch
extends BasicErrorMessageFactory {
    public static final String ADVICE = String.format("%n%nYou can use 'matches(Predicate p, String description)' to have a better error message%nFor example:%n  assertThat(player).matches(p -> p.isRookie(), \"is rookie\");%nwill give an error message looking like:%n%nExpecting actual:%n  player%nto match 'is rookie' predicate", new Object[0]);

    public static <T> ErrorMessageFactory shouldMatch(T actual, Predicate<? super T> predicate, PredicateDescription predicateDescription) {
        Objects.requireNonNull(predicateDescription, "The predicate description must not be null");
        return new ShouldMatch(actual, predicateDescription);
    }

    private ShouldMatch(Object actual, PredicateDescription description) {
        super("%nExpecting actual:%n  %s%nto match %s predicate." + (description.isDefault() ? ADVICE : ""), actual, description);
    }
}

