/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitBranch;
import git4idea.GitUtil;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import java.util.HashSet;

public class GitBranchesSearcher {
    private static final Logger LOG = Logger.getInstance(GitBranchesSearcher.class);
    private final GitBranch myLocal;
    private GitBranch myRemote;

    public GitBranchesSearcher(Project project, VirtualFile root, boolean findRemote) throws VcsException {
        LOG.debug("constructing, root: " + root.getPath() + " findRemote = " + findRemote);
        HashSet<GitBranch> usedBranches = new HashSet<GitBranch>();
        GitRepository repository2 = GitUtil.getRepositoryForRoot(project, root);
        this.myLocal = repository2.getCurrentBranch();
        LOG.debug("local: " + String.valueOf(this.myLocal));
        if (this.myLocal == null) {
            return;
        }
        usedBranches.add(this.myLocal);
        GitBranch remote = this.myLocal;
        while (true) {
            GitBranchTrackInfo trackInfo;
            GitBranch gitBranch = remote = (trackInfo = repository2.getBranchTrackInfo(remote.getName())) == null ? null : trackInfo.getRemoteBranch();
            if (remote == null) {
                LOG.debug("remote == null, exiting");
                return;
            }
            if (!findRemote || remote.isRemote()) {
                LOG.debug("remote found, isRemote: " + remote.isRemote() + " remoteName: " + remote.getFullName());
                this.myRemote = remote;
                return;
            }
            if (usedBranches.contains(remote)) {
                LOG.debug("loop found for: " + remote.getFullName() + ", exiting");
                return;
            }
            usedBranches.add(remote);
        }
    }

    public GitBranch getLocal() {
        return this.myLocal;
    }

    public GitBranch getRemote() {
        return this.myRemote;
    }
}

