/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.ContentManager;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import git4idea.log.GitShowExternalLogActionKt;
import git4idea.log.MyContentComponent;
import git4idea.log.ShowLogTask;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lgit4idea/log/GitShowExternalLogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.vcs.git"})
public final class GitShowExternalLogAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        GitVcs gitVcs = GitVcs.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"getInstance(...)");
        GitVcs vcs = gitVcs;
        List roots = GitShowExternalLogActionKt.access$getGitRootsFromUser(project2);
        if (roots.isEmpty()) {
            return;
        }
        ToolWindow window = ToolWindowManager.Companion.getInstance(project2).getToolWindow("Version Control");
        if (project2.isDefault() || !ProjectLevelVcsManager.getInstance((Project)project2).hasActiveVcss() || window == null) {
            ProgressManager.getInstance().run((Task)new ShowLogTask(project2, roots, vcs, true, (Function2<? super VcsLogManager, ? super Disposable, Unit>)((Function2)(arg_0, arg_1) -> GitShowExternalLogAction.actionPerformed$lambda$0(roots, project2, arg_0, arg_1))));
        } else {
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)roots, (CharSequence)"\n", null, null, (int)0, null, GitShowExternalLogAction::actionPerformed$lambda$1, (int)30, null)};
            String string = GitBundle.message("git.log.external.tab.description", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String description = string;
            ContentManager contentManager = window.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
            GitShowExternalLogActionKt.showExternalGitLogInToolwindow(project2, window, vcs, roots, GitShowExternalLogActionKt.access$calcTabName(contentManager, roots), description);
        }
    }

    private static final Unit actionPerformed$lambda$0(List $roots, Project $project, VcsLogManager $this$ShowLogTask, Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)$this$ShowLogTask, (String)"$this$ShowLogTask");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        MainVcsLogUi ui = $this$ShowLogTask.createLogUi(GitShowExternalLogActionKt.access$calcLogId($roots), null);
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)ui));
        MyContentComponent content = new MyContentComponent((JComponent)new VcsLogPanel($this$ShowLogTask, (VcsLogUiEx)ui), $roots);
        JComponent jComponent = content;
        String string = GitBundle.message("git.log.external.window.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GitShowExternalLogActionKt.access$showLogContentWindow($project, jComponent, string, disposable);
        return Unit.INSTANCE;
    }

    private static final CharSequence actionPerformed$lambda$1(VirtualFile obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        String string = obj.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }
}

