/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ByteOrderMarkFilterInputStream;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLLocationFilter;
import com.dd.plist.XMLLocationInformation;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLPropertyListParser {
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();

    public static DocumentBuilder getDocBuilder() throws ParserConfigurationException {
        DocumentBuilder builder = FACTORY.newDocumentBuilder();
        builder.setEntityResolver(new PlistDtdResolver());
        return builder;
    }

    public static NSObject parse(File f) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        return XMLPropertyListParser.parse(f.toPath());
    }

    public static NSObject parse(Path path) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        try (InputStream fileInputStream = Files.newInputStream(path, new OpenOption[0]);){
            NSObject nSObject = XMLPropertyListParser.parse(fileInputStream);
            return nSObject;
        }
    }

    public static NSObject parse(byte[] bytes) throws ParserConfigurationException, SAXException, PropertyListFormatException, IOException {
        try (ByteArrayInputStream inputStream2 = new ByteArrayInputStream(bytes);){
            NSObject nSObject = XMLPropertyListParser.parse(inputStream2);
            return nSObject;
        }
    }

    public static NSObject parse(InputStream is) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        ByteOrderMarkFilterInputStream filteredInputStream = new ByteOrderMarkFilterInputStream(is, false);
        return XMLPropertyListParser.parse(XMLPropertyListParser.parseXml(new InputSource(filteredInputStream), false));
    }

    public static NSObject parse(Reader reader) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        return XMLPropertyListParser.parse(XMLPropertyListParser.parseXml(new InputSource(reader), false));
    }

    public static NSObject parse(File f, boolean withLineInformation) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        return XMLPropertyListParser.parse(f.toPath(), withLineInformation);
    }

    public static NSObject parse(Path path, boolean withLineInformation) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        try (InputStream fileInputStream = Files.newInputStream(path, new OpenOption[0]);){
            NSObject nSObject = XMLPropertyListParser.parse(fileInputStream, withLineInformation);
            return nSObject;
        }
    }

    public static NSObject parse(byte[] bytes, boolean withLineInformation) throws ParserConfigurationException, SAXException, PropertyListFormatException, IOException {
        try (ByteArrayInputStream inputStream2 = new ByteArrayInputStream(bytes);){
            NSObject nSObject = XMLPropertyListParser.parse(inputStream2, withLineInformation);
            return nSObject;
        }
    }

    public static NSObject parse(InputStream is, boolean withLineInformation) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        ByteOrderMarkFilterInputStream filteredInputStream = new ByteOrderMarkFilterInputStream(is, false);
        return XMLPropertyListParser.parse(XMLPropertyListParser.parseXml(new InputSource(filteredInputStream), withLineInformation));
    }

    public static NSObject parse(Reader reader, boolean withLineInformation) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        return XMLPropertyListParser.parse(XMLPropertyListParser.parseXml(new InputSource(reader), withLineInformation));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NSObject parse(Document doc) throws PropertyListFormatException, IOException {
        void var3_6;
        String xpath;
        DocumentType docType = doc.getDoctype();
        if (docType == null ? !doc.getDocumentElement().getNodeName().equals("plist") : !docType.getName().equals("plist")) {
            throw new PropertyListFormatException("The given XML document is not a property list.");
        }
        if (doc.getDocumentElement().getNodeName().equals("plist")) {
            xpath = "/plist";
            List<Node> rootNodes = XMLPropertyListParser.filterElementNodes(doc.getDocumentElement().getChildNodes());
            if (rootNodes.isEmpty()) {
                throw new PropertyListFormatException("The given XML property list has no root element!");
            }
            if (rootNodes.size() != 1) throw new PropertyListFormatException("The given XML property list has more than one root element!");
            Node node = rootNodes.get(0);
            return XMLPropertyListParser.parseObject((Node)var3_6, xpath + "/" + var3_6.getNodeName());
        } else {
            Element element = doc.getDocumentElement();
            xpath = "";
        }
        return XMLPropertyListParser.parseObject((Node)var3_6, xpath + "/" + var3_6.getNodeName());
    }

    private static Document parseXml(InputSource inputSource, boolean withLineInformation) throws IOException, SAXException, ParserConfigurationException {
        if (withLineInformation) {
            XMLReader xmlReader = XMLPropertyListParser.createSafeXmlReader();
            XMLLocationFilter locationFilter = new XMLLocationFilter(xmlReader);
            SAXSource saxSource = new SAXSource(locationFilter, inputSource);
            DOMResult domResult = new DOMResult();
            try {
                Transformer transformer = XMLPropertyListParser.createSafeTransformer();
                transformer.transform(saxSource, domResult);
            }
            catch (TransformerException e2) {
                throw new IOException(e2.getMessage(), e2);
            }
            return (Document)domResult.getNode();
        }
        return XMLPropertyListParser.getDocBuilder().parse(inputSource);
    }

    private static XMLReader createSafeXmlReader() throws SAXException, ParserConfigurationException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        parserFactory.setXIncludeAware(false);
        SAXParser parser = parserFactory.newSAXParser();
        return parser.getXMLReader();
    }

    private static Transformer createSafeTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return transformerFactory.newTransformer();
    }

    private static NSObject parseObject(Node n, String xpath) throws PropertyListFormatException {
        String type = n.getNodeName();
        XMLLocationInformation loc = new XMLLocationInformation(n, xpath);
        NSObject parsedObject = null;
        try {
            switch (type) {
                case "dict": {
                    NSDictionary dict = new NSDictionary();
                    parsedObject = dict;
                    List<Node> children = XMLPropertyListParser.filterElementNodes(n.getChildNodes());
                    for (int i2 = 0; i2 < children.size(); i2 += 2) {
                        Node key = children.get(i2);
                        String keyString = XMLPropertyListParser.getNodeTextContents(key);
                        Node value = children.get(i2 + 1);
                        String childPath = xpath + "/*[" + (1 + i2 + 1) + "]";
                        dict.put(keyString, XMLPropertyListParser.parseObject(value, childPath));
                    }
                    break;
                }
                case "array": {
                    List<Node> children = XMLPropertyListParser.filterElementNodes(n.getChildNodes());
                    NSArray array = new NSArray(children.size());
                    parsedObject = array;
                    for (int i3 = 0; i3 < children.size(); ++i3) {
                        String childPath = xpath + "/*[" + (i3 + 1) + "]";
                        array.setValue(i3, XMLPropertyListParser.parseObject(children.get(i3), childPath));
                    }
                    break;
                }
                case "true": {
                    parsedObject = new NSNumber(true);
                    break;
                }
                case "false": {
                    parsedObject = new NSNumber(false);
                    break;
                }
                case "integer": 
                case "real": {
                    parsedObject = new NSNumber(XMLPropertyListParser.getNodeTextContents(n));
                    break;
                }
                case "string": {
                    parsedObject = new NSString(XMLPropertyListParser.getNodeTextContents(n));
                    break;
                }
                case "data": {
                    parsedObject = new NSData(XMLPropertyListParser.getNodeTextContents(n));
                    break;
                }
                case "date": {
                    parsedObject = new NSDate(XMLPropertyListParser.getNodeTextContents(n));
                }
            }
        }
        catch (PropertyListFormatException ex2) {
            throw ex2;
        }
        catch (Exception ex3) {
            throw new PropertyListFormatException(loc.hasLineInformation() ? "The " + n.getNodeName() + " node at line " + loc.getLineNumber() + " and column " + loc.getColumnNumber() + " could not be parsed." : "The " + n.getNodeName() + " node at " + xpath + " could not be parsed.", loc, ex3);
        }
        if (parsedObject != null) {
            parsedObject.setLocationInformation(loc);
        }
        return parsedObject;
    }

    private static List<Node> filterElementNodes(NodeList list) {
        ArrayList<Node> result2 = new ArrayList<Node>(list.getLength());
        for (int i2 = 0; i2 < list.getLength(); ++i2) {
            if (list.item(i2).getNodeType() != 1) continue;
            result2.add(list.item(i2));
        }
        return result2;
    }

    private static String getNodeTextContents(Node n) {
        if (n.getNodeType() == 3 || n.getNodeType() == 4) {
            Text txtNode = (Text)n;
            String content = txtNode.getWholeText();
            if (content == null) {
                return "";
            }
            return content;
        }
        if (n.hasChildNodes()) {
            NodeList children = n.getChildNodes();
            for (int i2 = 0; i2 < children.getLength(); ++i2) {
                Node child = children.item(i2);
                if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
                Text txtNode = (Text)child;
                String content = txtNode.getWholeText();
                if (content == null) {
                    return "";
                }
                return content;
            }
        }
        return "";
    }

    static {
        try {
            FACTORY.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FACTORY.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FACTORY.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FACTORY.setXIncludeAware(false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        FACTORY.setExpandEntityReferences(false);
        FACTORY.setNamespaceAware(false);
        FACTORY.setIgnoringComments(true);
        FACTORY.setCoalescing(true);
        FACTORY.setValidating(false);
    }

    private static class PlistDtdResolver
    implements EntityResolver {
        private static final String PLIST_PUBLIC_ID_1 = "-//Apple Computer//DTD PLIST 1.0//EN";
        private static final String PLIST_PUBLIC_ID_2 = "-//Apple//DTD PLIST 1.0//EN";

        PlistDtdResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (PLIST_PUBLIC_ID_1.equals(publicId) || PLIST_PUBLIC_ID_2.equals(publicId)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }
    }
}

