/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.gnu.trove;

import java.io.Serializable;
import org.jetbrains.coverage.gnu.trove.TIntFunction;
import org.jetbrains.coverage.gnu.trove.TIntProcedure;
import org.jetbrains.coverage.gnu.trove.TObjectHash;
import org.jetbrains.coverage.gnu.trove.TObjectHashingStrategy;
import org.jetbrains.coverage.gnu.trove.TObjectIntIterator;
import org.jetbrains.coverage.gnu.trove.TObjectIntProcedure;
import org.jetbrains.coverage.gnu.trove.TObjectProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectIntHashMap<K>
extends TObjectHash<K>
implements Serializable {
    protected transient int[] _values;

    public TObjectIntHashMap() {
    }

    /*
     * WARNING - void declaration
     */
    public TObjectIntHashMap(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectIntHashMap(int initialCapacity, float loadFactor) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectIntHashMap(TObjectHashingStrategy<K> strategy) {
        super(var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectIntHashMap(int initialCapacity, TObjectHashingStrategy<K> strategy) {
        super((int)var1_1, var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectIntHashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy<K> strategy) {
        super((int)var1_1, (float)var2_2, var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    public TObjectIntIterator<K> iterator() {
        return new TObjectIntIterator(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int setUp(int initialCapacity) {
        void var1_1;
        int capacity = super.setUp(initialCapacity);
        this._values = new int[capacity];
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int put(K key, int value) {
        void var3_3;
        void var2_2;
        void var1_1;
        int previous = 0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        Object oldKey = this._set[index];
        this._set[index] = var1_1;
        this._values[index] = var2_2;
        if (isNewMapping) {
            this.postInsertHook(oldKey == null);
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        int[] oldVals = this._values;
        this._set = new Object[newCapacity];
        this._values = new int[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            void var2_3;
            if (oldKeys[i] == null || oldKeys[i] == REMOVED) continue;
            Object o = oldKeys[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                TObjectIntHashMap tObjectIntHashMap = this;
                tObjectIntHashMap.throwObjectContractViolation(tObjectIntHashMap._set[-index - 1], o);
            }
            this._set[index] = var2_3;
            this._values[index] = oldVals[i];
        }
    }

    /*
     * WARNING - void declaration
     */
    public int get(K key) {
        void var1_2;
        int index = this.index(key);
        if (index < 0) {
            return 0;
        }
        return this._values[var1_2];
    }

    @Override
    public void clear() {
        super.clear();
        Object[] keys = this._set;
        int[] vals = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = null;
            vals[i] = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int remove(K key) {
        void var2_3;
        int prev = 0;
        int index = this.index(key);
        if (index >= 0) {
            void var1_2;
            prev = this._values[index];
            this.removeAt((int)var1_2);
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        if (!(other instanceof TObjectIntHashMap)) {
            return false;
        }
        TObjectIntHashMap that = (TObjectIntHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure((TObjectIntHashMap)var1_1));
    }

    @Override
    protected void removeAt(int index) {
        super.removeAt(index);
        this._values[var1_1] = 0;
    }

    /*
     * WARNING - void declaration
     */
    public int[] getValues() {
        void var1_1;
        int[] vals = new int[this.size()];
        int[] v = this._values;
        Object[] keys = this._set;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED) continue;
            vals[j++] = v[i];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Object[] keys() {
        void var1_1;
        Object[] keys = new Object[this.size()];
        Object[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == null || k[i] == REMOVED) continue;
            keys[j++] = k[i];
        }
        return var1_1;
    }

    public boolean containsValue(int val) {
        Object[] keys = this._set;
        int[] vals = this._values;
        int i = this._values.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(K key) {
        void var1_1;
        return this.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean forEachKey(TObjectProcedure<K> procedure) {
        void var1_1;
        return this.forEach(var1_1);
    }

    public boolean forEachValue(TIntProcedure procedure) {
        Object[] keys = this._set;
        int[] values = this._values;
        int i = this._values.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectIntProcedure<K> procedure) {
        Object[] keys = this._set;
        int[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean retainEntries(TObjectIntProcedure<K> procedure) {
        void var2_2;
        boolean modified = false;
        Object[] keys = this._set;
        int[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return (boolean)var2_2;
    }

    public void transformValues(TIntFunction function) {
        Object[] keys = this._set;
        int[] values = this._values;
        int i = this._values.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED) continue;
            values[i] = function.execute(values[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean increment(K key) {
        void var1_1;
        return this.adjustValue(var1_1, 1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean adjustValue(K key, int amount) {
        void var2_3;
        void var1_2;
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        void v0 = var1_2;
        this._values[v0] = this._values[v0] + var2_3;
        return true;
    }

    private static final class EqProcedure
    implements TObjectIntProcedure {
        private final TObjectIntHashMap _otherMap;

        /*
         * WARNING - void declaration
         */
        EqProcedure(TObjectIntHashMap otherMap) {
            void var1_1;
            this._otherMap = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean execute(Object key, int value) {
            void var1_1;
            void var2_2;
            int n = this._otherMap.index(key);
            return n >= 0 && EqProcedure.eq((int)var2_2, this._otherMap.get(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean eq(int v1, int v2) {
            void var1_1;
            return v1 == var1_1;
        }
    }
}

