/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ByteBufferCleaner {
    private static final MethodHandle cleanerHandle;
    private static final MethodHandle cleanerCleanHandle;

    public static void unmapBuffer(@NotNull ByteBuffer buffer) throws Exception {
        if (buffer == null) {
            ByteBufferCleaner.$$$reportNull$$$0(0);
        }
        if (!buffer.isDirect()) {
            return;
        }
        try {
            Object cleaner = cleanerHandle.invoke(buffer);
            if (cleaner != null) {
                cleanerCleanHandle.invoke(cleaner);
            }
        }
        catch (Error | Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> directBufferClass = Class.forName("sun.nio.ch.DirectBuffer");
            Class<?> cleanerClass = directBufferClass.getDeclaredMethod("cleaner", new Class[0]).getReturnType();
            cleanerHandle = lookup.findVirtual(directBufferClass, "cleaner", MethodType.methodType(cleanerClass));
            cleanerCleanHandle = lookup.findVirtual(cleanerClass, "clean", MethodType.methodType(Void.TYPE));
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/lang/ByteBufferCleaner", "unmapBuffer"));
    }
}

