/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.error.ShouldBeASCII;
import org.assertj.core.error.ShouldBeAlphabetic;
import org.assertj.core.error.ShouldBeAlphanumeric;
import org.assertj.core.error.ShouldBeBlank;
import org.assertj.core.error.ShouldBeHexadecimal;
import org.assertj.core.error.ShouldBePrintable;
import org.assertj.core.error.ShouldBeVisible;
import org.assertj.core.error.ShouldContainCharSequence;
import org.assertj.core.error.ShouldContainOneOrMoreWhitespaces;
import org.assertj.core.error.ShouldContainOnlyWhitespaces;
import org.assertj.core.error.ShouldNotBeBlank;
import org.assertj.core.error.ShouldNotContainAnyWhitespaces;
import org.assertj.core.error.ShouldNotContainOnlyWhitespaces;
import org.assertj.core.error.ShouldNotEndWithWhitespaces;
import org.assertj.core.error.ShouldNotStartWithWhitespaces;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Strings;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.IterableUtil;

public abstract class AbstractCharSequenceAssert<SELF extends AbstractCharSequenceAssert<SELF, ACTUAL>, ACTUAL extends CharSequence>
extends AbstractAssert<SELF, ACTUAL>
implements EnumerableAssert<SELF, Character> {
    Strings strings = Strings.instance();

    protected AbstractCharSequenceAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.strings.assertNullOrEmpty(this.info, (CharSequence)this.actual);
    }

    @Override
    public void isEmpty() {
        this.strings.assertEmpty(this.info, (CharSequence)this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.strings.assertNotEmpty(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isBlank() {
        this.assertBlank((CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    private void assertBlank(CharSequence actual) {
        if (!AbstractCharSequenceAssert.isBlank(actual)) {
            throw this.assertionError(ShouldBeBlank.shouldBeBlank(actual));
        }
    }

    public SELF isNotBlank() {
        this.assertNotBlank((CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    private void assertNotBlank(CharSequence actual) {
        if (AbstractCharSequenceAssert.isBlank(actual)) {
            throw this.assertionError(ShouldNotBeBlank.shouldNotBeBlank(actual));
        }
    }

    public SELF containsWhitespaces() {
        this.assertContainsWhitespaces((CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    private void assertContainsWhitespaces(CharSequence actual) {
        if (!AbstractCharSequenceAssert.containsWhitespaces(actual)) {
            throw this.assertionError(ShouldContainOneOrMoreWhitespaces.shouldContainOneOrMoreWhitespaces(actual));
        }
    }

    public SELF containsOnlyWhitespaces() {
        this.assertContainsOnlyWhitespaces((CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    private void assertContainsOnlyWhitespaces(CharSequence actual) {
        if (!AbstractCharSequenceAssert.containsOnlyWhitespaces(actual)) {
            throw this.assertionError(ShouldContainOnlyWhitespaces.shouldContainOnlyWhitespaces(actual));
        }
    }

    public SELF doesNotContainAnyWhitespaces() {
        this.assertDoesNotContainAnyWhitespaces((CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    private void assertDoesNotContainAnyWhitespaces(CharSequence actual) {
        if (AbstractCharSequenceAssert.containsWhitespaces(actual)) {
            throw this.assertionError(ShouldNotContainAnyWhitespaces.shouldNotContainAnyWhitespaces(actual));
        }
    }

    public SELF doesNotContainOnlyWhitespaces() {
        this.assertDoesNotContainOnlyWhitespaces((CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    private void assertDoesNotContainOnlyWhitespaces(CharSequence actual) {
        if (AbstractCharSequenceAssert.containsOnlyWhitespaces(actual)) {
            throw this.assertionError(ShouldNotContainOnlyWhitespaces.shouldNotContainOnlyWhitespaces(actual));
        }
    }

    @Deprecated(since="3", forRemoval=true)
    public SELF isJavaBlank() {
        this.assertJavaBlank((CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    private void assertJavaBlank(CharSequence actual) {
        if (!AbstractCharSequenceAssert.containsOnlyWhitespaces(actual)) {
            throw this.assertionError(ShouldBeBlank.shouldBeBlank(actual));
        }
    }

    @Deprecated(since="3", forRemoval=true)
    public SELF isNotJavaBlank() {
        this.assertNotJavaBlank((CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    private void assertNotJavaBlank(CharSequence actual) {
        if (AbstractCharSequenceAssert.containsOnlyWhitespaces(actual)) {
            throw this.assertionError(ShouldNotBeBlank.shouldNotBeBlank(actual));
        }
    }

    @Override
    public SELF hasSize(int expected) {
        this.strings.assertHasSize(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThan(int expected) {
        this.strings.assertHasSizeLessThan(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThanOrEqualTo(int expected) {
        this.strings.assertHasSizeLessThanOrEqualTo(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThan(int expected) {
        this.strings.assertHasSizeGreaterThan(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThanOrEqualTo(int expected) {
        this.strings.assertHasSizeGreaterThanOrEqualTo(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public SELF hasSizeBetween(int lowerBoundary, int higherBoundary) {
        this.strings.assertHasSizeBetween(this.info, (CharSequence)this.actual, lowerBoundary, higherBoundary);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF hasLineCount(int expectedLineCount) {
        this.strings.assertHasLineCount(this.info, (CharSequence)this.actual, expectedLineCount);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF hasSameSizeAs(CharSequence other) {
        this.strings.assertHasSameSizeAs((AssertionInfo)this.info, (CharSequence)this.actual, other);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Object other) {
        this.strings.assertHasSameSizeAs((AssertionInfo)this.info, (CharSequence)this.actual, other);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.strings.assertHasSameSizeAs((AssertionInfo)this.info, (CharSequence)this.actual, other);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isEqualToIgnoringCase(CharSequence expected) {
        this.strings.assertEqualsIgnoringCase(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isNotEqualToIgnoringCase(CharSequence expected) {
        this.strings.assertNotEqualsIgnoringCase(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsOnlyDigits() {
        this.strings.assertContainsOnlyDigits(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsOnlyOnce(CharSequence sequence) {
        this.strings.assertContainsOnlyOnce(this.info, (CharSequence)this.actual, sequence);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF contains(CharSequence ... values) {
        this.strings.assertContains(this.info, (CharSequence)this.actual, values);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsAnyOf(CharSequence ... values) {
        this.strings.assertContainsAnyOf(this.info, (CharSequence)this.actual, values);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF contains(Iterable<? extends CharSequence> values) {
        this.strings.assertContains(this.info, (CharSequence)this.actual, IterableUtil.toArray(values, CharSequence.class));
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsSequence(CharSequence ... values) {
        this.strings.assertContainsSequence(this.info, (CharSequence)this.actual, values);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsSequence(Iterable<? extends CharSequence> values) {
        this.strings.assertContainsSequence(this.info, (CharSequence)this.actual, IterableUtil.toArray(values, CharSequence.class));
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsSubsequence(CharSequence ... values) {
        this.strings.assertContainsSubsequence(this.info, (CharSequence)this.actual, values);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsSubsequence(Iterable<? extends CharSequence> values) {
        this.strings.assertContainsSubsequence(this.info, (CharSequence)this.actual, IterableUtil.toArray(values, CharSequence.class));
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsIgnoringCase(CharSequence sequence) {
        this.strings.assertContainsIgnoringCase(this.info, (CharSequence)this.actual, sequence);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsIgnoringWhitespaces(CharSequence ... values) {
        this.assertContainsIgnoringWhitespaces(values);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    private void assertContainsIgnoringWhitespaces(CharSequence ... values) {
        Strings.doCommonCheckForCharSequence(this.info, (CharSequence)this.actual, values);
        String actualWithoutWhitespace = Strings.removeAllWhitespaces((CharSequence)this.actual);
        Set notFound = Arrays.stream(values).map(Strings::removeAllWhitespaces).filter(value -> !this.objects.getComparisonStrategy().stringContains(actualWithoutWhitespace, (String)value)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (notFound.isEmpty()) {
            return;
        }
        if (values.length == 1) {
            throw this.assertionError(ShouldContainCharSequence.shouldContainIgnoringWhitespaces((CharSequence)this.actual, values[0], this.objects.getComparisonStrategy()));
        }
        throw this.assertionError(ShouldContainCharSequence.shouldContainIgnoringWhitespaces((CharSequence)this.actual, values, notFound, this.objects.getComparisonStrategy()));
    }

    public SELF containsIgnoringNewLines(CharSequence ... values) {
        this.strings.assertContainsIgnoringNewLines(this.info, (CharSequence)this.actual, values);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotContain(CharSequence ... values) {
        this.strings.assertDoesNotContain(this.info, (CharSequence)this.actual, values);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotContain(Iterable<? extends CharSequence> values) {
        this.strings.assertDoesNotContain(this.info, (CharSequence)this.actual, IterableUtil.toArray(values, CharSequence.class));
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotContainIgnoringCase(CharSequence ... values) {
        this.strings.assertDoesNotContainIgnoringCase(this.info, (CharSequence)this.actual, values);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotContainPattern(CharSequence pattern) {
        this.strings.assertDoesNotContainPattern((AssertionInfo)this.info, (CharSequence)this.actual, pattern);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotContainPattern(Pattern pattern) {
        this.strings.assertDoesNotContainPattern((AssertionInfo)this.info, (CharSequence)this.actual, pattern);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF startsWith(CharSequence prefix) {
        this.strings.assertStartsWith(this.info, (CharSequence)this.actual, prefix);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF startsWithIgnoringCase(CharSequence prefix) {
        this.strings.assertStartsWithIgnoringCase(this.info, (CharSequence)this.actual, prefix);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotStartWith(CharSequence prefix) {
        this.strings.assertDoesNotStartWith(this.info, (CharSequence)this.actual, prefix);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotStartWithIgnoringCase(CharSequence prefix) {
        this.strings.assertDoesNotStartWithIgnoringCase(this.info, (CharSequence)this.actual, prefix);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF endsWith(CharSequence suffix) {
        this.strings.assertEndsWith(this.info, (CharSequence)this.actual, suffix);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF endsWithIgnoringCase(CharSequence suffix) {
        this.strings.assertEndsWithIgnoringCase(this.info, (CharSequence)this.actual, suffix);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotEndWith(CharSequence suffix) {
        this.strings.assertDoesNotEndWith(this.info, (CharSequence)this.actual, suffix);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotEndWithIgnoringCase(CharSequence suffix) {
        this.strings.assertDoesNotEndWithIgnoringCase(this.info, (CharSequence)this.actual, suffix);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF matches(CharSequence regex) {
        this.strings.assertMatches((AssertionInfo)this.info, (CharSequence)this.actual, regex);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF matchesSatisfying(CharSequence regex, Consumer<Matcher> matchSatisfies) {
        return this.internalMatchesSatisfying(Pattern.compile(regex.toString()), matchSatisfies);
    }

    public SELF doesNotMatch(CharSequence regex) {
        this.strings.assertDoesNotMatch((AssertionInfo)this.info, (CharSequence)this.actual, regex);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF matches(Pattern pattern) {
        this.strings.assertMatches((AssertionInfo)this.info, (CharSequence)this.actual, pattern);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF matchesSatisfying(Pattern pattern, Consumer<Matcher> matchSatisfies) {
        return this.internalMatchesSatisfying(pattern, matchSatisfies);
    }

    private SELF internalMatchesSatisfying(Pattern pattern, Consumer<Matcher> matchSatisfies) {
        Matcher matcher = pattern.matcher((CharSequence)this.actual);
        this.strings.assertMatches((AssertionInfo)this.info, (CharSequence)this.actual, matcher);
        matchSatisfies.accept(matcher);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotMatch(Pattern pattern) {
        this.strings.assertDoesNotMatch((AssertionInfo)this.info, (CharSequence)this.actual, pattern);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Deprecated(since="3", forRemoval=true)
    public SELF isXmlEqualTo(CharSequence expectedXml) {
        this.strings.assertXmlEqualsTo(this.info, (CharSequence)this.actual, expectedXml);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Deprecated(since="3", forRemoval=true)
    public SELF isXmlEqualToContentOf(File xmlFile) {
        this.isXmlEqualTo(Assertions.contentOf(xmlFile));
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    @Deprecated(since="3", forRemoval=true)
    public final SELF usingElementComparator(Comparator<? super Character> customComparator) {
        throw new UnsupportedOperationException("custom element Comparator is not supported for CharSequence comparison");
    }

    @Override
    @Deprecated(since="3", forRemoval=true)
    public final SELF usingDefaultElementComparator() {
        throw new UnsupportedOperationException("custom element Comparator is not supported for CharSequence comparison");
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator, String customComparatorDescription) {
        this.strings = new Strings(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractCharSequenceAssert)super.usingComparator((Comparator)customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.strings = Strings.instance();
        return (SELF)((AbstractCharSequenceAssert)super.usingDefaultComparator());
    }

    @Override
    @CheckReturnValue
    public SELF inHexadecimal() {
        return (SELF)((AbstractCharSequenceAssert)super.inHexadecimal());
    }

    @Override
    @CheckReturnValue
    public SELF inBinary() {
        return (SELF)((AbstractCharSequenceAssert)super.inBinary());
    }

    @CheckReturnValue
    public SELF inUnicode() {
        this.info.useUnicodeRepresentation();
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isEqualToIgnoringWhitespace(CharSequence expected) {
        this.strings.assertEqualsIgnoringWhitespace(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isNotEqualToIgnoringWhitespace(CharSequence expected) {
        this.strings.assertNotEqualsIgnoringWhitespace(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isEqualToNormalizingWhitespace(CharSequence expected) {
        this.strings.assertEqualsNormalizingWhitespace(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isNotEqualToNormalizingWhitespace(CharSequence expected) {
        this.strings.assertNotEqualsNormalizingWhitespace(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isEqualToNormalizingPunctuationAndWhitespace(CharSequence expected) {
        this.strings.assertEqualsNormalizingPunctuationAndWhitespace(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isSubstringOf(CharSequence sequence) {
        this.strings.assertIsSubstringOf(this.info, (CharSequence)this.actual, sequence);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsPattern(CharSequence regex) {
        this.strings.assertContainsPattern((AssertionInfo)this.info, (CharSequence)this.actual, regex);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsPatternSatisfying(CharSequence regex, Consumer<Matcher> matchSatisfies) {
        return this.internalContainsPatternSatisfying(Pattern.compile(regex.toString()), matchSatisfies);
    }

    public SELF containsPattern(Pattern pattern) {
        this.strings.assertContainsPattern((AssertionInfo)this.info, (CharSequence)this.actual, pattern);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsPatternSatisfying(Pattern pattern, Consumer<Matcher> matchSatisfies) {
        return this.internalContainsPatternSatisfying(pattern, matchSatisfies);
    }

    private SELF internalContainsPatternSatisfying(Pattern pattern, Consumer<Matcher> matchSatisfies) {
        Matcher matcher = pattern.matcher((CharSequence)this.actual);
        this.strings.assertContainsPattern((AssertionInfo)this.info, (CharSequence)this.actual, matcher);
        matchSatisfies.accept(matcher);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isEqualToNormalizingNewlines(CharSequence expected) {
        this.strings.assertIsEqualToNormalizingNewlines(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isEqualToIgnoringNewLines(CharSequence expected) {
        this.strings.assertIsEqualToIgnoringNewLines(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isLowerCase() {
        this.strings.assertLowerCase(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isMixedCase() {
        this.strings.assertMixedCase(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isUpperCase() {
        this.strings.assertUpperCase(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isEqualToNormalizingUnicode(CharSequence expected) {
        this.strings.assertEqualsToNormalizingUnicode(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isAlphabetic() {
        this.isNotNull();
        if (!Pattern.matches("\\p{Alpha}+", (CharSequence)this.actual)) {
            this.throwAssertionError(ShouldBeAlphabetic.shouldBeAlphabetic(this.actual));
        }
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isAlphanumeric() {
        this.isNotNull();
        if (!Pattern.matches("\\p{Alnum}+", (CharSequence)this.actual)) {
            this.throwAssertionError(ShouldBeAlphanumeric.shouldBeAlphanumeric(this.actual));
        }
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isASCII() {
        this.isNotNull();
        if (!Pattern.matches("\\p{ASCII}+", (CharSequence)this.actual)) {
            this.throwAssertionError(ShouldBeASCII.shouldBeASCII(this.actual));
        }
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isHexadecimal() {
        this.isNotNull();
        if (!Pattern.matches("\\p{XDigit}+", (CharSequence)this.actual)) {
            this.throwAssertionError(ShouldBeHexadecimal.shouldBeHexadecimal(this.actual));
        }
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isPrintable() {
        this.isNotNull();
        if (!Pattern.matches("\\p{Print}+", (CharSequence)this.actual)) {
            this.throwAssertionError(ShouldBePrintable.shouldBePrintable(this.actual));
        }
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isVisible() {
        this.isNotNull();
        if (!Pattern.matches("\\p{Graph}+", (CharSequence)this.actual)) {
            this.throwAssertionError(ShouldBeVisible.shouldBeVisible(this.actual));
        }
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotStartWithWhitespaces() {
        this.isNotNull();
        if (((CharSequence)this.actual).length() > 0 && Character.isWhitespace(((CharSequence)this.actual).codePoints().findFirst().getAsInt())) {
            this.throwAssertionError(ShouldNotStartWithWhitespaces.shouldNotStartWithWhitespaces((CharSequence)this.actual));
        }
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotEndWithWhitespaces() {
        this.isNotNull();
        if (((CharSequence)this.actual).length() > 0 && Character.isWhitespace(((CharSequence)this.actual).codePoints().reduce((v1, v2) -> v2).getAsInt())) {
            this.throwAssertionError(ShouldNotEndWithWhitespaces.shouldNotEndWithWhitespaces((CharSequence)this.actual));
        }
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    private static boolean isBlank(CharSequence actual) {
        return AbstractCharSequenceAssert.isNullOrEmpty(actual) || AbstractCharSequenceAssert.strictlyContainsWhitespaces(actual);
    }

    private static boolean containsOnlyWhitespaces(CharSequence actual) {
        return !AbstractCharSequenceAssert.isNullOrEmpty(actual) && AbstractCharSequenceAssert.strictlyContainsWhitespaces(actual);
    }

    private static boolean containsWhitespaces(CharSequence actual) {
        return !AbstractCharSequenceAssert.isNullOrEmpty(actual) && AbstractCharSequenceAssert.containsOneOrMoreWhitespaces(actual);
    }

    private static boolean isNullOrEmpty(CharSequence actual) {
        return actual == null || actual.length() == 0;
    }

    private static boolean strictlyContainsWhitespaces(CharSequence actual) {
        return actual.chars().allMatch(Character::isWhitespace);
    }

    private static boolean containsOneOrMoreWhitespaces(CharSequence actual) {
        return actual.chars().anyMatch(Character::isWhitespace);
    }
}

